<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');

ini_set('display_errors', 1);
error_reporting(E_ALL);

/* ================== CONFIG ================== */
$DB_HOST   = 'localhost';
$DB_USER   = 'mari7851_admin';
$DB_PASS   = 'zVq1$rBmIRbEo$K6';
$DB_NAME   = 'mari7851_banco';
$TABLE_LOG = 'monitoramento_imagens';
$TABLE_NOTIF = 'notificacao_imagens'; // <<< NOVO

$API_NAME  = 'whatsapp-pic-api.php';
$RAPID_KEY = '0218e0716bmsh409331ab320a927p1dbf42jsn3a7a348cea06';

$MAX_RETRIES = 3; // tentativas por variação (com/sem 9)

/* ============== helpers de erro JSON ============== */
function json_fail(int $code, string $msg, array $extra = []) {
  http_response_code($code);
  echo json_encode(['erro' => $msg] + $extra, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
  exit;
}
set_exception_handler(function($e){ json_fail(500, 'excecao: '.$e->getMessage()); });
register_shutdown_function(function(){
  $e = error_get_last();
  if ($e && in_array($e['type'], [E_ERROR,E_PARSE,E_CORE_ERROR,E_COMPILE_ERROR])) {
    json_fail(500, 'fatal: '.$e['message'].' @'.$e['file'].':'.$e['line']);
  }
});

/* ================== DB + LOG ================== */
function pdoMake() {
  global $DB_HOST,$DB_USER,$DB_PASS,$DB_NAME;
  return new PDO("mysql:host={$DB_HOST};dbname={$DB_NAME};charset=utf8mb4",
    $DB_USER,$DB_PASS,
    [PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC]);
}

function logMonitoramento($apiNome,$status,$numero,$temImagem,$iniciouEm,$latenciaSeg,$erroMsg=null){
  global $TABLE_LOG;
  try{
    $sql="INSERT INTO {$TABLE_LOG}
          (api_nome,status,numero_consulta,erro_msg,tem_imagem,iniciou_em,latencia_seg)
          VALUES (:api,:st,:num,:err,:img,:ini,:lat)";
    pdoMake()->prepare($sql)->execute([
      ':api'=>$apiNome, ':st'=>$status, ':num'=>$numero, ':err'=>$erroMsg,
      ':img'=>(int)$temImagem, ':ini'=>$iniciouEm, ':lat'=>(int)$latenciaSeg
    ]);
  }catch(Throwable $e){ error_log('log fail: '.$e->getMessage()); }
}

/* <<< NOVO: notificação resumida para UI (notificacao_imagens)
   Campos esperados: id | api_nome | mensagem | horario | tempo | tem_imagem */
function logNotificacao($apiNome, $mensagem, $horario, $tempoSeg, $temImagem){
  global $TABLE_NOTIF;
  try{
    $sql = "INSERT INTO {$TABLE_NOTIF} (api_nome, mensagem, horario, tempo, tem_imagem)
            VALUES (:api, :msg, :hor, :tmp, :img)";
    pdoMake()->prepare($sql)->execute([
      ':api'=>$apiNome,
      ':msg'=>$mensagem,
      ':hor'=>$horario,             // formato 'Y-m-d H:i:s'
      ':tmp'=>(int)$tempoSeg,       // segundos
      ':img'=>(int)$temImagem       // 0/1
    ]);
  }catch(Throwable $e){ error_log('notif fail: '.$e->getMessage()); }
}

/* ================== UTIL ================== */
function gerarURL($arquivo){
  $proto = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host  = $_SERVER['HTTP_HOST'];
  return "$proto://$host/app/imagens/$arquivo";
}

function salvarMiniaturaBytes($bytes,$nomeArquivo){
  $img=@imagecreatefromstring($bytes);
  if(!$img) return false;
  $mini=imagecreatetruecolor(90,90);
  imagecopyresampled($mini,$img,0,0,0,0,90,90,imagesx($img),imagesy($img));
  $dir=$_SERVER['DOCUMENT_ROOT'].'/app/imagens/';
  if(!is_dir($dir)) mkdir($dir,0755,true);
  $path=$dir.$nomeArquivo;
  imagejpeg($mini,$path,90); // salva como JPG
  imagedestroy($img); imagedestroy($mini);
  return gerarURL($nomeArquivo);
}

/* gera 55DD9xxxxx e 55DDxxxxx */
function gerarVariacoesComDDI($numero){
  $num=preg_replace('/\D/','',$numero);
  if(substr($num,0,2)==='55') $num=substr($num,2);
  if(!preg_match('/^(\d{2})(\d{8,9})$/',$num,$m)) return [];
  $ddd=$m[1]; $resto=$m[2];
  $com9  = preg_match('/^9\d{8}$/',$resto) ? $ddd.$resto : $ddd.'9'.$resto;
  $sem9  = preg_match('/^9\d{8}$/',$resto) ? $ddd.substr($resto,1) : $ddd.$resto;
  return ['55'.$com9,'55'.$sem9];
}

/* ============== chamada crua (headers + body) ============== */
function jpic2_call_once($numero, $apiKey) {
  $url = "https://whatsapp-pic-api.p.rapidapi.com/jpic2?phone={$numero}";
  $ch = curl_init();
  curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 20,
    CURLOPT_HEADER => true,
    CURLOPT_HTTPHEADER => [
      "x-rapidapi-host: whatsapp-pic-api.p.rapidapi.com",
      "x-rapidapi-key: {$apiKey}"
    ],
  ]);
  $resp = curl_exec($ch);
  $err  = curl_error($ch);
  $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  $hsz  = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
  $hdrs = substr($resp, 0, $hsz);
  $body = substr($resp, $hsz);
  curl_close($ch);

  // parse headers -> array
  $headers = [];
  foreach (explode("\r\n", $hdrs) as $h) {
    if (strpos($h, ':') !== false) {
      [$k,$v] = array_map('trim', explode(':', $h, 2));
      $headers[strtolower($k)] = $v;
    }
  }
  return [$http, $headers, $body, $err];
}

/* ============== chamada com retries (429) ============== */
function chamarJpic2($numero, $apiKey, $maxRetries = 3) {
  $attempt = 0;
  $lastErr = null;

  while ($attempt++ < $maxRetries) {
    [$http, $headers, $body, $err] = jpic2_call_once($numero, $apiKey);

    if ($err) return ['ok'=>false, 'status'=>'error', 'http'=>$http, 'err'=>"cURL: $err"];

    if ($http === 200 && $body) {
      $json = json_decode($body, true);
      if (!is_array($json)) {
        return ['ok'=>false, 'status'=>'error', 'http'=>$http, 'err'=>'json inválido: '.json_last_error_msg()];
      }
      if (!empty($json['image']) && strlen($json['image']) > 500) {
        return ['ok'=>true, 'status'=>'success', 'image_b64'=>$json['image'], 'url_raw'=>$json['url'] ?? null];
      }
      $msg = $json['message'] ?? $json['error'] ?? 'not found';
      return ['ok'=>false, 'status'=>'not_found', 'http'=>$http, 'err'=>$msg];
    }

    if ($http === 429) {
      $retryAfter = isset($headers['retry-after']) ? (int)$headers['retry-after'] : null;
      $sleep = $retryAfter !== null ? max(1, $retryAfter)
             : min(10, (1 << ($attempt-1))) + mt_rand(0, 1000)/1000;
      sleep((int)floor($sleep));
      usleep((int)(($sleep - floor($sleep)) * 1e6));
      $lastErr = 'rate limit';
      continue;
    }

    $lastErr = "HTTP $http";
    break;
  }

  return ['ok'=>false, 'status'=>'error', 'http'=>429, 'err'=>$lastErr ?: 'rate limit'];
}

/* ================== FLUXO ================== */
try {
  $inicio_micro = microtime(true);
  $iniciou_em   = date('Y-m-d H:i:s');

  $numeroOriginal = $_POST['numero'] ?? null;
  $numeroOriginal = $numeroOriginal ? preg_replace('/\D/','',$numeroOriginal) : null;

  if(!$numeroOriginal){
    $lat = max(0,(int)round(microtime(true)-$inicio_micro));
    logMonitoramento($API_NAME,'error','faltou_numero',0,$iniciou_em,$lat,'Nenhum número no POST');
    // <<< NOVO
    logNotificacao($API_NAME,'Consulta abortada: nenhum número informado no POST.',$iniciou_em,$lat,0);

    echo json_encode(['url'=>gerarURL('perfilsemfoto.jpg'),'nome'=>'','mensagem'=>'','evento_plausible'=>'naotemimagem'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
    exit;
  }

  $variacoes = gerarVariacoesComDDI($numeroOriginal);
  $imagemEncontrada=false; $statusFinal='not_found'; $erroMsg=null; $urlFinal=null;
  $nome=''; $mensagem=''; // esta API não traz nome/mensagem

  foreach($variacoes as $num){
    $r = chamarJpic2($num, $RAPID_KEY, $MAX_RETRIES);

    if($r['ok'] && $r['status']==='success'){
      $bytes=base64_decode($r['image_b64'], true);
      if($bytes===false){ $erroMsg='base64 inválido'; $statusFinal='error'; continue; }
      $nomeArquivo='img_'.$num.'.jpg';
      $urlFinal=salvarMiniaturaBytes($bytes,$nomeArquivo);
      if($urlFinal){ $imagemEncontrada=true; $statusFinal='success'; break; }
      else { $erroMsg='falha ao salvar miniatura'; $statusFinal='error'; }
    } else {
      $statusTent = $r['status'] ?? 'error';
      if($statusTent==='error') $statusFinal='error';
      if(!empty($r['err'])) $erroMsg=$r['err'];
    }
  }

  $latTotal = max(0,(int)round(microtime(true)-$inicio_micro));

  if($imagemEncontrada){
    setcookie('temimagem','sim',time()+86400*30,'/');
    setcookie('nome_perfil',$nome,time()+86400*30,'/');
    setcookie('mensagem_perfil',$mensagem,time()+86400*30,'/');

    echo json_encode(['url'=>$urlFinal,'nome'=>$nome,'mensagem'=>$mensagem,'evento_plausible'=>'temimagem'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);

    logMonitoramento($API_NAME,'success',$numeroOriginal,1,$iniciou_em,$latTotal,null);
    // <<< NOVO
    logNotificacao($API_NAME,"Imagem encontrada para o número {$numeroOriginal}.",$iniciou_em,$latTotal,1);

  } else {
    setcookie('temimagem','nao',time()+86400*30,'/');
    setcookie('nome_perfil',$nome,time()+86400*30,'/');
    setcookie('mensagem_perfil',$mensagem,time()+86400*30,'/');

    $urlPadrao=gerarURL('perfilsemfoto.jpg');
    echo json_encode(['url'=>$urlPadrao,'nome'=>$nome,'mensagem'=>$mensagem,'evento_plausible'=>'naotemimagem'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);

    logMonitoramento($API_NAME,$statusFinal,$numeroOriginal,0,$iniciou_em,$latTotal,$erroMsg);
    // <<< NOVO
    $msgNotif = ($statusFinal==='error')
      ? "Erro na consulta para o número {$numeroOriginal}: ".($erroMsg ?: 'erro desconhecido')."."
      : "Sem imagem de perfil para o número {$numeroOriginal}.";
    logNotificacao($API_NAME,$msgNotif,$iniciou_em,$latTotal,0);
  }

} catch(Throwable $e){
  json_fail(500,'excecao: '.$e->getMessage());
}
