<?php
header('Content-Type: application/json');
date_default_timezone_set('America/Sao_Paulo');

/* =============== DB + LOG =============== */
function pdoConn(): PDO {
    $dsn  = "mysql:host=localhost;dbname=mari7851_banco;charset=utf8mb4";
    $user = "mari7851_admin";
    $pass = "zVq1$rBmIRbEo$K6";
    return new PDO($dsn, $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
}
$nomeapi = 'whatsapp-data1';
function logMonitoramento(string $nomeapi, string $status, string $numeroConsulta, int $temImagem, string $iniciouEm, int $latenciaSeg, ?string $erroMsg=null): void {
    try {
        $sql = "INSERT INTO monitoramento_imagens
                (api_nome, status, numero_consulta, erro_msg, tem_imagem, iniciou_em, latencia_seg)
                VALUES (:api, :status, :num, :erro, :img, :ini, :lat)";
        $stmt = pdoConn()->prepare($sql);
        $stmt->execute([
            ':api'   => $nomeapi,
            ':status'=> $status,              // 'success' | 'not_found' | 'error'
            ':num'   => $numeroConsulta,
            ':erro'  => $erroMsg,
            ':img'   => $temImagem,           // 0/1
            ':ini'   => $iniciouEm,           // 'Y-m-d H:i:s'
            ':lat'   => $latenciaSeg          // segundos (int)
        ]);
    } catch (Throwable $e) {
        error_log("Falha ao logar monitoramento_imagens: ".$e->getMessage());
    }
}
/* ======================================= */

function sendToTelegram($message) {
    if (rand(1, 100) > 100) return; // desativado (sempre não envia)
    $bot_token = "7574620663:AAHVrt1wimE5ZlbAoCZnq8L9myIm0CK3Wus";
    $chat_id = "-1002456760125";
    $url = "https://api.telegram.org/bot$bot_token/sendMessage";
    $data = ['chat_id'=>$chat_id, 'text'=>$message, 'parse_mode'=>'HTML'];
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_exec($ch);
    curl_close($ch);
}

function gerarURL($arquivo) {
    $protocolo = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    return "$protocolo://$host/app/imagens/$arquivo";
}

function baixarImagemSegura($url) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_USERAGENT => 'Mozilla/5.0',
        CURLOPT_TIMEOUT => 10,
    ]);
    $data = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ($httpCode === 200 && $data) ? $data : false;
}

function consultarAPI($numero, $chaveApi) {
    $url = "https://whatsapp-data1.p.rapidapi.com/number/$numero?base64=false&telegram=false&google=false";
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 20,
        CURLOPT_HTTPHEADER => [
            "x-rapidapi-host: whatsapp-data1.p.rapidapi.com",
            "x-rapidapi-key: $chaveApi"
        ],
    ]);
    $resposta = curl_exec($ch);
    $erro = curl_error($ch);
    curl_close($ch);
    return $erro ? null : json_decode($resposta, true);
}

function salvarMiniatura($urlImagem, $nomeArquivo) {
    $conteudo = baixarImagemSegura($urlImagem);
    if (!$conteudo) return false;
    $img = @imagecreatefromstring($conteudo);
    if (!$img) return false;
    $mini = imagecreatetruecolor(90, 90);
    imagecopyresampled($mini, $img, 0, 0, 0, 0, 90, 90, imagesx($img), imagesy($img));
    $ext = pathinfo(parse_url($urlImagem, PHP_URL_PATH), PATHINFO_EXTENSION);
    $dir = $_SERVER['DOCUMENT_ROOT'] . '/app/imagens/';
    if (!is_dir($dir)) mkdir($dir, 0755, true);
    $path = $dir . $nomeArquivo;
    ($ext === 'png') ? imagepng($mini, $path) : imagejpeg($mini, $path);
    imagedestroy($img); imagedestroy($mini);
    return gerarURL($nomeArquivo);
}

/* ======== MEDIÇÃO DO TEMPO TOTAL ======== */
$inicio_micro = microtime(true);
$iniciou_em   = date('Y-m-d H:i:s'); // base para o log

// Número
$numeroOriginal = isset($_POST['numero']) ? preg_replace('/\D/', '', $_POST['numero']) : null;
if (empty($numeroOriginal)) {
    sendToTelegram("⚠️ Nenhum número recebido. Retornando padrão.");
    $lat = max(0, (int) round(microtime(true) - $inicio_micro));
    logMonitoramento('whatsapp-data1', 'error', 'faltou_numero', 0, $iniciou_em, $lat, 'Nenhum número no POST');
    echo json_encode(['url' => gerarURL('perfilsemfoto.jpg')], JSON_UNESCAPED_SLASHES);
    exit;
}
if (substr($numeroOriginal, 0, 2) !== '55') $numeroOriginal = '55'.$numeroOriginal;

sendToTelegram("🔍 Consultando novo número: <b>$numeroOriginal</b>");

$apiNome  = 'whatsapp-data1';
$chaveApi = "207ced630bmsh399be83dedfd489p1fe8f3jsn0bae555cec6b";
$tentativas = 0;
$resposta = null;
$erroMsg = null;

// loop de tentativas
do {
    $tentativas++;
    $resposta = consultarAPI($numeroOriginal, $chaveApi);

    if (isset($resposta['message']) && str_contains($resposta['message'], 'rate limit')) {
        $erroMsg = 'rate limit';
        sendToTelegram("⚠️ RATE LIMIT atingido para $apiNome");
        sleep(3);
        continue;
    }

    if ($resposta && !empty($resposta['profilePic'])) {
        $urlImagem = $resposta['profilePic'];
        $nomeArquivo = 'img_' . $numeroOriginal . '.' . pathinfo(parse_url($urlImagem, PHP_URL_PATH), PATHINFO_EXTENSION);
        $urlFinal = salvarMiniatura($urlImagem, $nomeArquivo);
        if (!$urlFinal) { $erroMsg = 'falha ao salvar miniatura'; break; }

        $nome = $resposta['verifiedName'] ?? $resposta['pushname'] ?? '';
        $mensagem = $resposta['about'] ?? '';

        setcookie('temimagem', 'sim', time() + 86400 * 30, "/");
        setcookie('nome_perfil', $nome, time() + 86400 * 30, "/");
        setcookie('mensagem_perfil', $mensagem, time() + 86400 * 30, "/");

        sendToTelegram("✅ Imagem encontrada ($apiNome): <code>$urlFinal</code>");

        // LOG success
        $latTotal = max(0, (int) round(microtime(true) - $inicio_micro));
        logMonitoramento('imgwpp.php', 'success', $numeroOriginal, 1, $iniciou_em, $latTotal, null);

        echo json_encode([
            'url' => $urlFinal,
            'nome' => $nome,
            'mensagem' => $mensagem,
            'evento_plausible' => 'temimagem'
        ], JSON_UNESCAPED_SLASHES);
        exit;
    }

    if ($tentativas === 1) sleep(5);

} while ($tentativas < 2);

// sem imagem (pode ter nome/mensagem)
$nome = $resposta['verifiedName'] ?? $resposta['pushname'] ?? '';
$mensagem = $resposta['about'] ?? '';
$urlPadrao = gerarURL('perfilsemfoto.jpg');

setcookie('temimagem', 'nao', time() + 86400 * 30, "/");
setcookie('nome_perfil', $nome, time() + 86400 * 30, "/");
setcookie('mensagem_perfil', $mensagem, time() + 86400 * 30, "/");

sendToTelegram("🛑 Nenhuma imagem encontrada ($apiNome) para <b>$numeroOriginal</b>");

// LOG not_found / error
$latTotal = max(0, (int) round(microtime(true) - $inicio_micro));
$status = $erroMsg ? 'error' : 'not_found';
logMonitoramento('whatsapp-data1.php', $status, $numeroOriginal, 0, $iniciou_em, $latTotal, $erroMsg);

echo json_encode([
    'url' => $urlPadrao,
    'nome' => $nome,
    'mensagem' => $mensagem,
    'evento_plausible' => 'naotemimagem'
], JSON_UNESCAPED_SLASHES);
