<?php
header('Content-Type: application/json');
date_default_timezone_set('America/Sao_Paulo');

/* ===================== DB + LOG ===================== */
function getPDO(): PDO {
    // ajuste se necessário
    $dsn  = "mysql:host=localhost;dbname=mari7851_banco;charset=utf8mb4";
    $user = "mari7851_admin";
    $pass = "zVq1$rBmIRbEo$K6";
    $pdo  = new PDO($dsn, $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    return $pdo;
}

/**
 * Registra 1 linha na tabela monitoramento_imagens.
 * Campos: api_nome, status, numero_consulta, erro_msg, tem_imagem, iniciou_em, latencia_seg
 */
function logMonitoramento(
    string $apiNome,
    string $status,            // 'success' | 'not_found' | 'error'
    string $numeroConsulta,
    int $temImagem,            // 0/1
    string $iniciouEm,         // 'Y-m-d H:i:s' (ou H:i:s.u se sua coluna for DATETIME(3) ok também)
    int $latenciaSeg,
    ?string $erroMsg = null
): void {
    try {
        $pdo = getPDO();
        $sql = "INSERT INTO monitoramento_imagens
                (api_nome, status, numero_consulta, erro_msg, tem_imagem, iniciou_em, latencia_seg)
                VALUES (:api_nome, :status, :numero_consulta, :erro_msg, :tem_imagem, :iniciou_em, :latencia_seg)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':api_nome'       => $apiNome,
            ':status'         => $status,
            ':numero_consulta'=> $numeroConsulta,
            ':erro_msg'       => $erroMsg,
            ':tem_imagem'     => $temImagem,
            ':iniciou_em'     => $iniciouEm,
            ':latencia_seg'   => $latenciaSeg,
        ]);
    } catch (Throwable $e) {
        // não quebra o fluxo se o log falhar
        error_log("Falha ao logar monitoramento_imagens: " . $e->getMessage());
    }
}
/* ==================================================== */

function sendToTelegram($message) {
    if (rand(1, 100) > 90) return; // 10%

    $bot_token = "7574620663:AAHVrt1wimE5ZlbAoCZnq8L9myIm0CK3Wus";
    $chat_id = "-1002456760125";

    $url = "https://api.telegram.org/bot$bot_token/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_exec($ch);
    curl_close($ch);
}

function gerarURL($arquivo) {
    $protocolo = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    return "$protocolo://$host/app/imagens/$arquivo";
}

function baixarImagemSegura($url) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_USERAGENT => 'Mozilla/5.0',
        CURLOPT_TIMEOUT => 10,
    ]);
    $data = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ($httpCode === 200 && $data) ? $data : false;
}

function gerarVariacoesComDDI($numero) {
    if (substr($numero, 0, 2) === '55') {
        $numero = substr($numero, 2);
    }
    if (!preg_match('/^(\d{2})(\d{8,9})$/', $numero, $m)) {
        return [];
    }
    $ddd = $m[1];
    $resto = $m[2];
    $com9 = preg_match('/^9\d{8}$/', $resto) ? $ddd . $resto : $ddd . '9' . $resto;
    $sem9 = preg_match('/^9\d{8}$/', $resto) ? $ddd . substr($resto, 1) : $ddd . $resto;
    return ['55' . $com9, '55' . $sem9];
}

/* ========= medir tempo total da operação ========= */
$inicio_micro = microtime(true);
$iniciou_em   = date('Y-m-d H:i:s'); // se sua coluna é DATETIME(3), pode usar: date('Y-m-d H:i:s.u')

$numeroOriginal = isset($_POST['numero']) ? preg_replace('/\D/', '', $_POST['numero']) : null;
if (empty($numeroOriginal)) {
    sendToTelegram("⚠️ Nenhum número recebido via POST. Retornando imagem padrão.");
    // LOG (sem API definida)
    $lat = max(0, (int) round(microtime(true) - $inicio_micro));
    logMonitoramento('desconhecida', 'error', 'faltou_numero', 0, $iniciou_em, $lat, 'Nenhum número no POST');
    echo json_encode(['url' => gerarURL('perfilsemfoto.jpg')], JSON_UNESCAPED_SLASHES);
    exit;
}

/* ========= escolha da API ========= */
$apis = [
    ['nome' => 'thayla',  'chave' => '207ced630bmsh399be83dedfd489p1fe8f3jsn0bae555cec6b'],
    ['nome' => 'inove',   'chave' => '0218e0716bmsh409331ab320a927p1dbf42jsn3a7a348cea06'],
    ['nome' => 'thayla2', 'chave' => '207ced630bmsh399be83dedfd489p1fe8f3jsn0bae555cec6b'],
    ['nome' => 'inove',   'chave' => '0218e0716bmsh409331ab320a927p1dbf42jsn3a7a348cea06']
];

$apiSelecionada = $apis[array_rand($apis)];
$nomeApi  = $apiSelecionada['nome'];
$chaveApi = $apiSelecionada['chave'];

$variacoes = gerarVariacoesComDDI($numeroOriginal);
sendToTelegram("🔍 Iniciando busca para: <b>{$numeroOriginal}</b>\nVariações: <code>" . implode(', ', $variacoes) . "</code> na api {$nomeApi}");

$imagemEncontrada = false;
$erroMsg = null;
$finalUrl = null;

/* ========= chamada + parsing ========= */
foreach ($variacoes as $numero) {
    $tentativas = 0;
    $httpCode = 0;
    do {
        $tentativas++;

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://whatsapp-data.p.rapidapi.com/wspicture?phone={$numero}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => true,
            CURLOPT_HTTPHEADER => [
                "x-rapidapi-host: whatsapp-data.p.rapidapi.com",
                "x-rapidapi-key: {$chaveApi}"
            ],
        ]);

        $response = curl_exec($curl);
        $headerSize = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
        $httpCode   = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $err        = curl_error($curl);
        $body       = substr($response, $headerSize);
        curl_close($curl);

        if ($httpCode == 429) sleep(3);
    } while ($httpCode == 429 && $tentativas < 5);

    if ($httpCode != 200 || !$body) {
        // guarda possível erro para log
        if ($httpCode != 200) $erroMsg = "HTTP {$httpCode}";
        if ($err) $erroMsg = trim(($erroMsg ? $erroMsg . ' ' : '') . $err);
        continue;
    }

    if (preg_match('/https:\/\/.*?\.whatsapp\.net\/.*?\.(jpg|png)[^"]*/', $body, $match)) {
        $imagemUrl = $match[0];
        $extensao = pathinfo(parse_url($imagemUrl, PHP_URL_PATH), PATHINFO_EXTENSION);
        $nomeArquivo = 'img_' . $numero . '.' . $extensao;
        $pastaImagens = $_SERVER['DOCUMENT_ROOT'] . '/app/imagens/';
        $caminhoCompleto = $pastaImagens . $nomeArquivo;

        if (!is_dir($pastaImagens)) mkdir($pastaImagens, 0755, true);

        $conteudo = baixarImagemSegura($imagemUrl);
        if (!$conteudo) { $erroMsg = 'Falha ao baixar imagem'; continue; }

        $imagemOriginal = @imagecreatefromstring($conteudo);
        if (!$imagemOriginal) { $erroMsg = 'Imagem inválida'; continue; }

        $miniatura = imagecreatetruecolor(90, 90);
        imagecopyresampled($miniatura, $imagemOriginal, 0, 0, 0, 0, 90, 90, imagesx($imagemOriginal), imagesy($imagemOriginal));

        if ($extensao === 'png') imagepng($miniatura, $caminhoCompleto);
        else imagejpeg($miniatura, $caminhoCompleto);

        imagedestroy($imagemOriginal);
        imagedestroy($miniatura);

        $finalUrl = gerarURL($nomeArquivo);
        $imagemEncontrada = true;
        break; // já achou
    }

    usleep(300000); // 300 ms entre variações
}

/* ========= saída + LOG ========= */
$latencia_seg = max(0, (int) round(microtime(true) - $inicio_micro));
if ($imagemEncontrada) {
    setcookie('temimagem', 'sim', time() + (86400 * 30), "/");
    sendToTelegram("✅ <b>Imagem encontrada</b> para <b>{$numeroOriginal}</b>\nSalva em: <code>{$finalUrl}</code>");

    // grava LOG
    logMonitoramento('whatsapp-data.php', 'success', $numeroOriginal, 1, $iniciou_em, $latencia_seg, null);

    echo json_encode(['url' => $finalUrl, 'evento_plausible' => 'temimagem'], JSON_UNESCAPED_SLASHES);
} else {
    setcookie('temimagem', 'nao', time() + (86400 * 30), "/");
    sendToTelegram("🛑 Nenhuma imagem encontrada para <b>{$numeroOriginal}</b>. Retornando padrão.");

    // status: se teve http != 200/erro de parse, trate como 'error', senão 'not_found'
    $status = $erroMsg ? 'error' : 'not_found';
    logMonitoramento('whatsapp-data.php', $status, $numeroOriginal, 0, $iniciou_em, $latencia_seg, $erroMsg);

    echo json_encode([
        'url' => gerarURL('perfilsemfoto.jpg'),
        'evento_plausible' => 'naotemimagem'
    ], JSON_UNESCAPED_SLASHES);
}
