<?php
$email = $_GET['email'] ?? 'seu-email@exemplo.com';
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <title>Espião - Email Enviado</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-image: url('6240b66d5c50c8661eee78b439a7d33c.webp');
            background-size: cover;
            background-repeat: repeat-y;
            height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding-top: 120px;
            color: #333;
        }

        .alerta {
            background-color: #ffe5e5;
            border: 2px solid #ff0000;
            color: #b30000;
            padding: 25px;
            border-radius: 10px;
            max-width: 600px;
            text-align: center;
            font-weight: bold;
            font-size: 16px;
            animation: pulse 1s infinite alternate;
        }

        .contador {
            font-size: 28px;
            font-weight: bold;
            color: red;
            margin-top: 20px;
            animation: piscar 1s infinite;
        }

        @keyframes piscar {
            0% { opacity: 1; }
            50% { opacity: 0.2; }
            100% { opacity: 1; }
        }

        @keyframes pulse {
            from { border-color: #ff0000; }
            to { border-color: #ff4d4d; }
        }

        .email-info {
            margin-top: 20px;
            font-size: 16px;
        }

        .email-info span {
            font-weight: bold;
            color: #008000;
        }
    </style>
</head>
<body>
    <img src="topo.png" alt="" class="img-fluid fixed-top">

  <div class="alerta">
    📩 <strong>Acabamos de enviar um e-mail para você</strong><br><br>

    O remetente é <strong>Maria Cecilia, da nossa equipe</strong>.<br>
    O e-mail contém um link exclusivo para você visualizar os arquivos que encontramos.<br><br>

    ⚠️ <strong>Importante:</strong> esse link é <u>válido por apenas 30 segundos</u>, por motivos de segurança.<br>
    Após esse tempo, ele irá <strong>expirar e não funcionará mais</strong>.<br><br>

    ✅ Acesse seu e-mail agora e procure a mensagem.<br>
    🔍 <strong>Se não encontrar na caixa de entrada, verifique a pasta de spam ou lixo eletrônico.</strong>
</div>

    <div class="contador" id="contador">35</div>

    <div class="email-info">
        Acesse o email enviado para: <span><?php echo htmlspecialchars($email); ?></span>
    </div>

<script>
    // === Verifica e define o cookie ===
    function getCookie(nome) {
        const valor = `; ${document.cookie}`;
        const partes = valor.split(`; ${nome}=`);
        if (partes.length === 2) return partes.pop().split(';').shift();
    }

    function setCookie(nome, valor, dias) {
        const d = new Date();
        d.setTime(d.getTime() + (dias * 24 * 60 * 60 * 1000));
        const expira = "expires=" + d.toUTCString();
        document.cookie = `${nome}=${valor}; ${expira}; path=/`;
    }

    // Redireciona imediatamente se o cookie existir
    if (getCookie('email') === 'enviado') {
        window.location.href = '5.html';
    } else {
        // Caso não exista, define o cookie
        setCookie('email', 'enviado', 1);
    }

    // Redirecionamento após 1 minuto (60.000 ms)
    setTimeout(() => {
        window.location.href = '5.html';
    }, 60000);
</script>


    <script>
        let tempo = 35;
        const contador = document.getElementById('contador');
        const intervalo = setInterval(() => {
            tempo--;
            contador.innerText = tempo;
            if (tempo <= 0) {
                clearInterval(intervalo);
                contador.innerText = "Link expirado!";
                contador.style.color = '#555';
            }
        }, 1000);
    </script>
</body>
</html>
