<?php
function analisarRedirecionamento($urlInicial) {
    echo "🔍 Testando: $urlInicial<br>";

    $caminho = [];
    $urlAtual = $urlInicial;
    $refCapturado = null;
    $limite = 10;

    for ($i = 0; $i < $limite; $i++) {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $urlAtual,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADER => true,
            CURLOPT_NOBODY => false,
            CURLOPT_FOLLOWLOCATION => false,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
        ]);

        $resposta = curl_exec($ch);
        $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if (!$resposta) {
            echo "❌ Falha ao acessar: $urlAtual<br>";
            break;
        }

        // Separar header e corpo
        list($headersRaw, $html) = explode("\r\n\r\n", $resposta, 2);
        $headers = explode("\r\n", $headersRaw);

        $location = null;
        foreach ($headers as $linha) {
            if (stripos($linha, 'Location:') === 0) {
                $location = trim(substr($linha, 9));
                break;
            }
        }

        $caminho[] = $urlAtual;

        // Verifica se capturou ref na URL
        if (!$refCapturado && strpos($urlAtual, '?') !== false) {
            parse_str(parse_url($urlAtual, PHP_URL_QUERY), $queryParams);
            if (isset($queryParams['ref'])) {
                $refCapturado = $queryParams['ref'];
            }
        }

        // Se não tiver Location mas tiver meta-refresh no HTML
        if (!$location) {
            if (preg_match('/<meta[^>]+http-equiv=["\']refresh["\'][^>]*content=["\']\s*\d+;\s*url=([^"\']+)["\']/i', $html, $metaMatch)) {
                $location = trim($metaMatch[1]);
                if (strpos($location, 'http') !== 0) {
                    // Se for relativo
                    $parsed = parse_url($urlAtual);
                    $base = $parsed['scheme'] . '://' . $parsed['host'];
                    $location = $base . '/' . ltrim($location, '/');
                }
            }
        }

        if (!$location) break;

        $urlAtual = $location;
    }

    echo "📍 URL final: $urlAtual<br>";
    echo "📌 Ref capturado: " . ($refCapturado ?? 'não encontrado') . "<br>";
    echo "🧭 Caminho dos Location (se houver):<br>";
    foreach ($caminho as $c) {
        echo "- $c<br>";
    }
}

// 🔧 Coloque aqui a URL a testar:
$urlParaTestar = "https://go.perfectpay.com.br/PPU38CPR3JI";
analisarRedirecionamento($urlParaTestar);
