<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);



$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
if ($mysqli->connect_error) {
    http_response_code(500);
    exit("Erro ao conectar ao banco de dados.");
}

$dataAgora = date('Y-m-d H:i:s');

$mysqli->query("UPDATE horarios SET solicitado = '$dataAgora' WHERE id = 1");

// Checagem inicial: respeitar controle de calma
$res = $mysqli->query("SELECT calma, tentativas FROM esperar WHERE id = 1 LIMIT 1");
if ($res && $res->num_rows > 0) {
    $row = $res->fetch_assoc();
    $calma = $row['calma'];
    $tentativas = intval($row['tentativas']);

    if ($calma === 'sim') {
        if ($tentativas > 0) {
            $novaTentativa = $tentativas - 1;
            $mysqli->query("UPDATE esperar SET tentativas = $novaTentativa WHERE id = 1");
            exit; // Finaliza imediatamente sem continuar
        } else {
            // Resetar o estado, pode continuar
            $mysqli->query("UPDATE esperar SET calma = 'não', tentativas = 0 WHERE id = 1");
        }
    }
}

// Funções de conversão base personalizada 31
function decimalParaBasePersonalizada($decimal, $length = 5) {
    $alfabeto = '0123456789ABCDEFGHIJKLMNOPQRSTU';
    $base = strlen($alfabeto);
    $resultado = '';
    do {
        $resultado = $alfabeto[$decimal % $base] . $resultado;
        $decimal = intdiv($decimal, $base);
    } while ($decimal > 0);
    return str_pad($resultado, $length, '0', STR_PAD_LEFT);
}

function basePersonalizadaParaDecimal($codigo) {
    $alfabeto = '0123456789ABCDEFGHIJKLMNOPQRSTU';
    $base = strlen($alfabeto);
    $codigo = strtoupper($codigo);
    $decimal = 0;
    for ($i = 0; $i < strlen($codigo); $i++) {
        $valor = strpos($alfabeto, $codigo[$i]);
        if ($valor === false) return false;
        $decimal = $decimal * $base + $valor;
    }
    return $decimal;
}

// Funções de scraping
function obterHTMLViaCurl($url) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 20,
        CURLOPT_CONNECTTIMEOUT => 10,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
    ]);
    $html = curl_exec($ch);
    $info = curl_getinfo($ch);
    curl_close($ch);
    return [$html ?: false, $info['url'] ?? $url];
}

function detectarRedirecionamentoExterno($url) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HEADER => true,
        CURLOPT_NOBODY => true,
        CURLOPT_FOLLOWLOCATION => false,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
    ]);

    $response = curl_exec($ch);
    curl_close($ch);

    if (!$response) return [false, null];

    if (preg_match('/Location:\s*(.*)/i', $response, $match)) {
        $redirect = trim($match[1]);
        parse_str(parse_url($redirect, PHP_URL_QUERY) ?? '', $qs);
        $refExtraido = $qs['ref'] ?? null;
        return [$redirect, $refExtraido];
    }

    return [false, null];
}


function extrairNomeProduto($html) {
    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    $possiveis = [
        '//div[@id="you-are-buying"]//span',
        '//span[contains(text(), "Você está adquirindo")]/following-sibling::span',
        '//h2[contains(@class, "product-name")]',
        '//h1[contains(@class, "product-title")]'
    ];
    foreach ($possiveis as $path) {
        $nodes = $xpath->query($path);
        foreach ($nodes as $node) {
            $texto = trim($node->nodeValue);
            if ($texto !== '' && stripos($texto, 'VOCÊ ESTÁ ADQUIRINDO') === false) {
                return $texto;
            }
        }
    }
    return false;
}

function extrairImagemProduto($html) {
    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    $possiveis = [
        '//img[@id="product-image"]',
        '//img[contains(@class, "product-image")]',
        '//div[contains(@class, "product-img")]/img'
    ];
    foreach ($possiveis as $path) {
        $img = $xpath->query($path);
        if ($img->length > 0) {
            return $img->item(0)->getAttribute('src');
        }
    }
    return false;
}

function decodificarCfEmail($cfemail) {
    $r = '';
    $k = hexdec(substr($cfemail, 0, 2));
    for ($i = 2; $i < strlen($cfemail); $i += 2) {
        $charCode = hexdec(substr($cfemail, $i, 2)) ^ $k;
        $r .= chr($charCode);
    }
    return $r;
}

function extrairEmailSuporte($html) {
    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    $a = $xpath->query('//a[contains(@class, "__cf_email__")]');
    if ($a->length > 0) {
        $cfemail = $a->item(0)->getAttribute('data-cfemail');
        return decodificarCfEmail($cfemail);
    }
    return null;
}

function produtoNaoAprovado($html) {
    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    $temAlerta = $xpath->query('//div[contains(@class, "alert") and contains(@class, "alert-info")]');
    $temProduto = $xpath->query('//div[@id="you-are-buying"]');
    return ($temAlerta->length > 0 && $temProduto->length === 0);
}

function bloqueioCloudflare($html) {
    return (
        stripos($html, '<title>Just a moment...</title>') !== false ||
        stripos($html, 'id="challenge-error-text"') !== false ||
        stripos($html, 'Enable JavaScript and cookies to continue') !== false
    );
}

function verificarPaginaInternacional($html) {
    if (empty($html) || !is_string($html)) return false;

    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    $nodes = $xpath->query('//*[contains(@class, "is-international")]');
    return $nodes->length > 0;
}

// Híbrida: extrai ref de URL, input, ou template via regex
function extrairAffiliationIdViaRegex($html) {
    if (preg_match('/<input[^>]+name=["\']affiliationId["\'][^>]+value=["\']([^"\']+)["\']/', $html, $matches)) {
        return $matches[1];
    }
    return null;
}

function extrairTituloPagina($html) {
    if (empty($html)) return null; // Adiciona essa verificação!

    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $nodes = $dom->getElementsByTagName('title');
    if ($nodes->length > 0) {
        return trim($nodes->item(0)->nodeValue);
    }
    return null;
}
function extrairReferencia($html, $urlFinal) {
    $ref = null;

    // 1. Tentativa direta da URL final (query string ?ref=)
    if (!empty($urlFinal)) {
        $query = parse_url($urlFinal, PHP_URL_QUERY);
        if ($query) {
            parse_str($query, $params);
            if (!empty($params['ref'])) {
                $ref = $params['ref'];
            }
        }
    }

    // 2. Se não achou na URL, tenta buscar via XPath no HTML
    if (!$ref && !empty($html)) {
        libxml_use_internal_errors(true);
        $dom = new DOMDocument();
        @$dom->loadHTML($html);
        $xpath = new DOMXPath($dom);

        // Busca por inputs ocultos comuns para afiliado
        $input = $xpath->query('//input[@type="hidden" and (@id="affiliationId" or @name="affiliationId")]');
        if ($input->length > 0) {
            $ref = $input->item(0)->getAttribute('value');
        }
    }

    // 3. Fallback: Regex direto no HTML (ex: <input name="affiliationId" value="XYZ">)
    if (!$ref && !empty($html)) {
        if (preg_match('/<input[^>]+name=["\']affiliationId["\'][^>]+value=["\']([^"\']+)["\']/', $html, $matches)) {
            $ref = $matches[1];
        }
    }

    return $ref ?: null;
}


// Execução principal
$prefixoURL = 'https://go.perfectpay.com.br/PPU38C';
$res = $mysqli->query("SELECT codigo FROM ultimoacesso WHERE id = 1");
$codigoBase = ($res && $res->num_rows > 0) ? $res->fetch_assoc()['codigo'] : '00000';
$baseDecimal = basePersonalizadaParaDecimal($codigoBase);
$getOffset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;
$getLimit  = isset($_GET['limit']) ? intval($_GET['limit']) : 10;

for ($i = 0; $i < $getLimit; $i++) {
    $codigoDecimal = $baseDecimal + $i + 1;
    $sufixo = decimalParaBasePersonalizada($codigoDecimal);
    $url = $prefixoURL . $sufixo;

    echo "<hr><strong>🔗 Testando código:</strong> $sufixo<br>";
    echo "<strong>URL:</strong> <a href='$url' target='_blank'>$url</a><br>";

    list($html, $urlFinal) = obterHTMLViaCurl($url);
    $dataHoje = date('Y-m-d H:i:s');
    $referencia = extrairReferencia($html, $urlFinal);
    $internacional = verificarPaginaInternacional($html) ? 'sim' : null;

if ($urlFinal !== $url && strpos($urlFinal, 'perfectpay.com.br') === false) {
    echo "<span style='color:red;'>🚨 Redirecionado para outro domínio externo:</span> <a href='$urlFinal' target='_blank'>$urlFinal</a><br>";

    // Tenta extrair o título da página externa
    $titulo = extrairTituloPagina($html);

    $stmt = $mysqli->prepare("INSERT INTO produtos (id, nome, link, imagem, data, email_suporte, referencia, pagina_vendas, titulo, link_solicitado)
                              VALUES (?, NULL, ?, NULL, ?, NULL, ?, 'sim', ?, ?)
                              ON DUPLICATE KEY UPDATE link=VALUES(link), data=VALUES(data), referencia=VALUES(referencia), titulo=VALUES(titulo), pagina_vendas='sim', link_solicitado = VALUES(link_solicitado)");
    $stmt->bind_param("ssssss", $sufixo, $urlFinal, $dataHoje, $referencia, $titulo, $url);
    $stmt->execute();
    $stmt->close();
    // Verifica redirecionamento externo e salva domínio
    $dominioExtraido = parse_url($urlFinal, PHP_URL_HOST);

if ($dominioExtraido) {
    $dominioExtraido = strtolower(trim($dominioExtraido));

    // Remove o prefixo www. se existir
    if (strpos($dominioExtraido, 'www.') === 0) {
        $dominioExtraido = substr($dominioExtraido, 4);
    }
    $dominioEscapado = $mysqli->real_escape_string($dominioExtraido);
    $refEscapado = $referencia ? $mysqli->real_escape_string($referencia) : '';

    // Verifica se já existe esse domínio
    $res = $mysqli->query("SELECT id, ref FROM dominios WHERE dominio = '$dominioEscapado' LIMIT 1");

    if ($res && $res->num_rows > 0) {
        $row = $res->fetch_assoc();
        $refAtual = $row['ref'];

        if (empty($refAtual) && !empty($refEscapado)) {
            // Atualiza a ref que está vazia
            $stmt = $mysqli->prepare("UPDATE dominios SET ref = ? WHERE id = ?");
            $stmt->bind_param("si", $refEscapado, $row['id']);
            $stmt->execute();
            $stmt->close();
            echo "<span style='color:blue;'>🔄 Atualizado ref existente vazia: $dominioExtraido → ref='$refEscapado'</span><br>";
        } else {
            echo "<span style='color:gray;'>📌 Domínio já cadastrado com ref: $dominioExtraido</span><br>";
        }

    } else {
        // Não existe ainda → pode inserir
        $dataAgora = date('Y-m-d H:i:s');
        $stmt = $mysqli->prepare("INSERT INTO dominios (dominio, ref, data, data_ultm_ckts) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $dominioExtraido, $refEscapado, $dataAgora, $dataAgora);
        $stmt->execute();
        $stmt->close();
        echo "<span style='color:green;'>🆕 Novo domínio salvo: $dominioExtraido com ref='$refEscapado'</span><br>";
    }
}

    $mysqli->query("UPDATE ultimoacesso SET codigo = '$sufixo' WHERE id = 1");
    continue;

}

    if (!$html || bloqueioCloudflare($html)) {
        echo "<span style='color:red;'>❌ Erro ao acessar ou bloqueado por Cloudflare.</span><br>";
           // Verifica status atual da tabela `esperar`
    $res = $mysqli->query("SELECT calma, tentativas FROM esperar WHERE id = 1 LIMIT 1");
      $mysqli->query("UPDATE ultimoacesso SET codigo = '$sufixo' WHERE id = 1");
    if ($res && $res->num_rows > 0) {
        $row = $res->fetch_assoc();
        if ($row['calma'] === 'sim') {
            $novaTentativa = intval($row['tentativas']) + 1;
            $mysqli->query("UPDATE esperar SET tentativas = $novaTentativa WHERE id = 1");
        } else {
            $mysqli->query("UPDATE esperar SET calma = 'sim', tentativas = 1 WHERE id = 1");
        }
    } else {
        // Se a linha não existir
        $mysqli->query("INSERT INTO esperar (id, calma, tentativas) VALUES (1, 'sim', 1)
                        ON DUPLICATE KEY UPDATE calma = 'sim', tentativas = 1");
    }

    // Finaliza a execução imediatamente para não forçar mais requisições
    exit;
    }
    if (rtrim($urlFinal, '/') === 'https://perfectpay.com.br') {
        echo "<span style='color:orange;'>⚠️ Produto ainda não foi criado.</span><br>";
         $mysqli->query("UPDATE ultimoproduto SET encontrou = 'sim' WHERE id = 1");
        continue;
    }
    if (produtoNaoAprovado($html)) {
        echo "<span style='color:red;'>🚫 Produto $sufixo não aprovado ou removido.</span><br>";
         $mysqli->query("UPDATE ultimoacesso SET codigo = '$sufixo' WHERE id = 1");
          $mysqli->query("INSERT INTO esperar (id, calma, tentativas) VALUES (1, 'sim', 1)
                        ON DUPLICATE KEY UPDATE calma = 'não', tentativas = 0");
    exit;
    }

    $nome = extrairNomeProduto($html) ?: null;
    $imagem = extrairImagemProduto($html) ?: null;
    $email = extrairEmailSuporte($html) ?: null;

    echo "<strong>📦 Produto:</strong> " . htmlspecialchars($nome ?? '-') . "<br>";
    echo "<strong>📧 Suporte:</strong> " . htmlspecialchars($email ?? '-') . "<br>";
    echo "<strong>🖼️ Imagem:</strong><br><img src='" . htmlspecialchars($imagem ?? '') . "' width='400'><br>";

    $stmt = $mysqli->prepare("INSERT INTO produtos (id, nome, link, imagem, data, email_suporte, referencia, pagina_vendas, internacional, link_solicitado)
                              VALUES (?, ?, ?, ?, ?, ?, ?, NULL, ?, ?)
                              ON DUPLICATE KEY UPDATE nome=VALUES(nome), link=VALUES(link), imagem=VALUES(imagem),
                              data=VALUES(data), email_suporte=VALUES(email_suporte), referencia=VALUES(referencia) , internacional=VALUES(internacional), link_solicitado = VALUES(link_solicitado)");
    $stmt->bind_param("sssssssss", $sufixo, $nome, $urlFinal, $imagem, $dataHoje, $email, $referencia, $internacional, $url);
    $stmt->execute();
    $stmt->close();
     $mysqli->query("UPDATE ultimoproduto SET encontrou = 'não' WHERE id = 1");
$mysqli->query("UPDATE ultimoacesso SET codigo = '$sufixo' WHERE id = 1");
$dataAgora = date('Y-m-d H:i:s');

$mysqli->query("UPDATE horarios SET realizado = '$dataAgora' WHERE id = 1");
    flush();
    sleep(2);
}
?>
