<?php
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
if ($mysqli->connect_error) die("Erro na conexão");
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Ofertas</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <style>
    html, body {
      height: 100%;
      margin: 0;
    }
    body {
      font-family: 'Roboto', sans-serif;
      background-color: #F9FAFC;
      display: flex;
      flex-direction: column;
    }
    .sidebar {
      width: 260px;
      height: 100vh;
      background: #fff;
      border-right: 1px solid #E0E0E0;
      position: fixed;
      top: 0;
      left: 0;
      padding: 2rem 1.5rem;
      box-shadow: 0 0 6px rgba(0, 0, 0, 0.05);
    }
    .sidebar .nav-link {
      display: flex;
      align-items: center;
      gap: 12px;
      font-size: 14px;
      font-weight: 500;
      color: #555;
      padding: 12px;
      border-radius: 6px;
      transition: 0.2s;
    }
    .sidebar .nav-link:hover {
      background-color: #f2f2f2;
    }
    .sidebar .nav-link.active {
      color: #2F80ED;
      border-left: 3px solid #2F80ED;
      background-color: #f2f2f2;
    }
    .content {
      margin-left: 260px;
      padding: 24px 32px 0 32px;
      display: flex;
      flex-direction: column;
      height: 100vh;
      overflow: hidden;
    }
    .content-header {
      margin-bottom: 10px;
    }
    .btn-primary {
      background-color: #2F80ED;
      border: none;
      font-weight: 500;
      padding: 10px 18px;
      border-radius: 6px;
    }
    .card-table {
      background: #fff;
      border-radius: 8px;
      padding: 16px;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
      overflow: hidden;
      display: flex;
      flex-direction: column;
      flex: 1;
      margin-bottom: 16px;
    }
    .scroll-wrapper {
      flex: 1;
      overflow-y: auto;
      padding-right: 8px;
      max-height: calc(95vh - 160px);
      mask-image: linear-gradient(to bottom, transparent 0px, black 20px, black calc(100% - 20px), transparent 100%);
      -webkit-mask-image: linear-gradient(to bottom, transparent 0px, black 20px, black calc(100% - 20px), transparent 100%);
    }
    thead th {
      font-size: 16px;
      font-weight: 200;
      padding: 14px;
      border-bottom: 1px solid #e0e0e0;
      color: #444;
      position: sticky;
      top: 0;
      background: #fff;
      z-index: 2;
      box-shadow: 0 2px 4px rgba(0,0,0,0.03);
    }
    tbody td {
      font-size: 16px;
      padding: 14px;
      border-bottom: 1px solid #f0f0f0;
      vertical-align: middle;
    }
    tbody tr:hover {
      background-color: #FAFAFA;
    }
    .produto-img {
      width: 60px;
      height: 60px;
      border-radius: 3px;
      object-fit: cover;
      margin-right: 12px;
    }
    .produto-nome, .produto-email, .produto-anuncio, .produto-internacional, .produto-checkout, .produto-posicao {
      color: black;
      font-size: 16px;
      font-weight: 400;
    }
    .produto-titulo{
          color: black;
      font-size: 17px;
      font-weight: 500;
    }
    .online-dot {
      width: 8px;
      height: 8px;
      background-color: #28a745;
      border-radius: 50%;
      display: inline-block;
    }
    .nav-tabs .nav-link {
  font-weight: 500;
  color: #555;
}
.nav-tabs .nav-link.active {
  color: #2F80ED;
  border-color: #2F80ED #2F80ED #fff;
}
  </style>
</head>
<body>

<aside class="sidebar">
  <h5 class="mb-4 fw-bold text-primary">Painel</h5>

  <!-- Produtos com submenu -->
  <div class="nav flex-column">
    <a class="nav-link d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#submenuProdutos" role="button" aria-expanded="false" aria-controls="submenuProdutos">
      <span><i class="fas fa-box"></i> Produtos</span>
      <i class="fas fa-chevron-down small"></i>
    </a>
    <div class="collapse show" id="submenuProdutos"> <!-- remova "show" se quiser fechado por padrão -->
      <a href="painel.php" class="nav-link ps-4 active">Escalados</a>
      <a href="painel_novos.php" class="nav-link ps-4">Novos Produtos</a>
    </div>
  </div>

  <!-- Restante do menu -->
  <a href="painel_dominios.php" class="nav-link"><i class="fas fa-globe"></i> Domínios</a>
  <a href="#" class="nav-link"><i class="fas fa-tags"></i> Checkouts</a>
  <a href="#" class="nav-link"><i class="fas fa-bullhorn"></i> Anúncios</a>
</aside>

<main class="content">
  <div class="content-header">
    <form method="GET" class="w-100">
      <div class="input-group">
        <input type="text" name="busca" class="form-control form-control" placeholder="Buscar produto, email, referência...">
      </div>
    </form>
  </div>
  <div class="px-3 py-2 text-muted small" id="contador-resultados">Carregando...</div>
  <div class="card-table">
    <div class="scroll-wrapper">
      <table class="table table-hover align-middle mb-0">
        <thead>
          <tr>
            <th>Imagem</th>
            <th>Produto</th>
            <th>Email</th>
            <th class="text-right">Anúncios</th>
            <th class="text-center">Checkouts</th>
            <th class="text-center">Internacional</th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
    </div>
  </div>
</main><!-- Modal fullscreen com abas -->
<div class="modal fade" id="modalDetalhes" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-fullscreen">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalTituloProduto">Detalhes do Produto</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <div class="modal-body p-0 d-flex flex-column" id="conteudoModal">

        <!-- Abas no topo -->
        <ul class="nav nav-tabs px-4 pt-3" id="tabsModal" role="tablist">
          <li class="nav-item" role="presentation">
            <button class="nav-link active" id="aba-geral-tab" data-bs-toggle="tab" data-bs-target="#aba-geral" type="button" role="tab">Geral</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="aba-links-tab" data-bs-toggle="tab" data-bs-target="#aba-links" type="button" role="tab">Links</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="aba-checkouts-tab" data-bs-toggle="tab" data-bs-target="#aba-checkouts" type="button" role="tab">Checkouts</button>
          </li>
        </ul>

        <!-- Conteúdo das abas -->
        <div class="tab-content flex-grow-1 overflow-auto p-4" style="min-height: 80vh;">
          <div class="tab-pane fade show active" id="aba-geral" role="tabpanel">
            <div class="card p-3" id="conteudo-aba-geral">Carregando...</div>
          </div>
          <div class="tab-pane fade" id="aba-links" role="tabpanel">
            <div class="card p-3" id="conteudo-aba-links">Carregando...</div>
          </div>
          <div class="tab-pane fade" id="aba-checkouts" role="tabpanel">
            <div class="card p-3" id="conteudo-aba-checkouts">Carregando...</div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>

</div>

<script>
let offset = 0;
const limite = 20;
let buscando = false;
let buscaAtual = '';
let ultimaBusca = '';
let debounce;
let totalResultados = 0;
const input = document.querySelector("input[name='busca']");
const tbody = document.querySelector("tbody");
const contador = document.getElementById("contador-resultados");

async function carregarOfertas(reset = false) {
  if (buscando) return;
  buscando = true;
  if (reset) {
    offset = 0;
    totalResultados = 0;
    tbody.innerHTML = '';
  }
  const url = `buscar_ofertas.php?offset=${offset}&limite=${limite}&busca=${encodeURIComponent(buscaAtual)}`;
  const resposta = await fetch(url);
  const json = await resposta.json();
  const dados = json.resultados || [];
  const total = json.total || 0;

  if (dados.length === 0 && offset === 0) {
    contador.textContent = "Nenhum resultado encontrado.";
    tbody.innerHTML = '<tr><td colspan="7" class="text-center py-4">Nenhum resultado encontrado.</td></tr>';
  } else {
    dados.forEach(o => {
      const internacional = o.dolar === 'sim'
        ? `<span class="badge-internacional">Sim</span>`
        : `<span style="color: #999; font-size: 12px;">Não</span>`;

      const icones = o.anuncios > 0
        ? `<i class="fab fa-facebook-square" style="color:#1877F2;"></i><span class="online-dot"></span>`
        : '';

      const linha = `
        <tr>
          <td><img src="${o.imagem_produto}" class="produto-img" alt=""></td>
          <td class="produto-nome">${o.nome}</td>
          <td class="produto-email">${o.email}</td>
          <td class="produto-anuncio text-right">
            <div style="display: flex; justify-content: end; align-items: center; gap: 6px;">
              ${o.anuncios} ${icones}
            </div>
          </td>
          <td class="text-center produto-checkout">${o.checkouts}</td>
          <td class="text-center produto-internacional">${internacional}</td>
        </tr>`;
      tbody.insertAdjacentHTML("beforeend", linha);
    });
    offset += limite;
    totalResultados += dados.length;
    contador.textContent = `${total} resultado${total === 1 ? '' : 's'} encontrado${total === 1 ? '' : 's'}.`;
  }
  buscando = false;
}

input.addEventListener("input", () => {
  clearTimeout(debounce);
  debounce = setTimeout(() => {
    buscaAtual = input.value.trim();
    if (buscaAtual !== ultimaBusca) {
      ultimaBusca = buscaAtual;
      carregarOfertas(true);
    }
  }, 300);
});

const scrollWrapper = document.querySelector(".scroll-wrapper");
scrollWrapper.addEventListener('scroll', () => {
  const fimScroll = scrollWrapper.scrollTop + scrollWrapper.clientHeight >= scrollWrapper.scrollHeight - 100;
  if (fimScroll && !buscando) {
    carregarOfertas();
  }
});

tbody.addEventListener("click", async function(e) {
  const tr = e.target.closest("tr");
  if (!tr) return;

  const email = tr.querySelector(".produto-email")?.innerText?.trim();
  const nomeProduto = tr.querySelector(".produto-nome")?.innerText?.trim();

  if (!email) return;

  // Atualiza o título do modal com o nome do produto
  if (nomeProduto) {
    document.getElementById("modalTituloProduto").textContent = nomeProduto;
  }

  // Mostra mensagens de carregamento nas abas
  document.getElementById("conteudo-aba-geral").innerHTML = `<div class="text-center p-4">Carregando...</div>`;
  document.getElementById("conteudo-aba-links").innerHTML = `<div class="text-center p-4">Carregando...</div>`;
  document.getElementById("conteudo-aba-checkouts").innerHTML = `<div class="text-center p-4">Carregando...</div>`;

  // Faz as requisições para carregar os conteúdos
  const geral = await fetch(`produtos_por_email.php?email=${encodeURIComponent(email)}`).then(r => r.text());
  const links = await fetch(`detalhes_links.php?email=${encodeURIComponent(email)}`).then(r => r.text());
  const checkouts = await fetch(`detalhes_checkouts.php?email=${encodeURIComponent(email)}`).then(r => r.text());

  // Coloca o conteúdo em cada aba
  document.getElementById("conteudo-aba-geral").innerHTML = geral;
  document.getElementById("conteudo-aba-links").innerHTML = links;
  document.getElementById("conteudo-aba-checkouts").innerHTML = checkouts;

  // Abre o modal
  const modal = new bootstrap.Modal(document.getElementById("modalDetalhes"));
  modal.show();
});

document.getElementById("modalDetalhes").addEventListener('hidden.bs.modal', () => {
  document.querySelectorAll('.modal-backdrop').forEach(e => e.remove());
  document.body.classList.remove('modal-open');
  document.body.style.overflow = '';
});

carregarOfertas();
</script>
</body>
</html>
