<?php
header('Content-Type: application/json');

// DADOS DE CONEXÃO
$host = 'localhost';
$db = 'wwmari_db';
$user = 'wwmari_admin';
$pass = '1UQ4^%naXgaFc8Zq8B&bL*85Nj5dkt*A';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['erro' => 'Erro ao conectar no banco']);
    exit;
}

// RECEBE O EXPERIMENTO VIA GET
$experimento = $_GET['experimento'] ?? null;

if (!$experimento) {
    echo json_encode(['erro' => 'Parâmetro "experimento" é obrigatório']);
    exit;
}

// TOTAL DE PARTICIPANTES DO TESTE A/B PARA O EXPERIMENTO
try {
    $stmtAb = $pdo->prepare("
        SELECT COUNT(*) AS total_ab
        FROM ab_test_resultados
        WHERE experimento = :experimento
        AND data_criado BETWEEN (NOW() - INTERVAL 10 HOUR) AND (NOW() - INTERVAL 5 MINUTE)
    ");
    $stmtAb->execute([':experimento' => $experimento]);
    $total_ab = (int) $stmtAb->fetchColumn();
} catch (PDOException $e) {
    $total_ab = 0;
}

// TOTAL DE EVENTOS FACEBOOK NO MESMO INTERVALO (SEM FILTRO DE EXPERIMENTO)
try {
    $stmtFb = $pdo->prepare("
        SELECT COUNT(*) AS total_fb
        FROM eventos_facebook
        WHERE data_registro BETWEEN (NOW() - INTERVAL 10 HOUR) AND (NOW() - INTERVAL 5 MINUTE)
    ");
    $stmtFb->execute();
    $total_fb = (int) $stmtFb->fetchColumn();
} catch (PDOException $e) {
    $total_fb = 0;
}

// CÁLCULO DA PORCENTAGEM
$percentual = $total_fb > 0
    ? round(($total_ab / $total_fb) * 100, 2)
    : 0.0;

// RESPOSTA JSON
echo json_encode([
    'total_ab_test' => $total_ab,
    'total_eventos_facebook' => $total_fb,
    'percentual_participacao_ab' => $percentual
]);
