<?php
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
if ($mysqli->connect_error) {
    echo json_encode(['erro' => 'Erro na conexão']);
    exit;
}

$busca = isset($_GET['busca']) ? trim($mysqli->real_escape_string($_GET['busca'])) : '';
$offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;
$limite = isset($_GET['limite']) ? intval($_GET['limite']) : 200;

$where = "1";
if ($busca !== '') {
    $busca_sql = "%$busca%";
    $where .= " AND (
        SUBSTRING_INDEX(SUBSTRING_INDEX(link, '/', 3), '/', -1) LIKE '$busca_sql'
    )";
}

// BUSCA DOMÍNIOS ÚNICOS
$sql = "
  SELECT DISTINCT 
    TRIM(LEADING 'www.' FROM SUBSTRING_INDEX(SUBSTRING_INDEX(link, '/', 3), '/', -1)) AS dominio
    FROM ofertas
    WHERE link IS NOT NULL AND link != ''
    AND $where
    ORDER BY dominio
    LIMIT $limite OFFSET $offset
";

$res = $mysqli->query($sql);
$dados = [];

if ($res) {
    while ($row = $res->fetch_assoc()) {
        $dominio = $row['dominio'];
        $dominio_like = "%$dominio%";

        // BUSCA ATÉ 10 REFERÊNCIAS ÚNICAS DO DOMÍNIO
        $referencias = [];
        $referencias_listadas = [];
        $res_refs = $mysqli->query("
            SELECT DISTINCT referencia 
            FROM produtos 
            WHERE link LIKE '$dominio_like' 
            AND referencia IS NOT NULL AND TRIM(referencia) != ''
            LIMIT 10
        ");

        if ($res_refs) {
            while ($ref_row = $res_refs->fetch_assoc()) {
                $ref = $ref_row['referencia'];
                $referencias_listadas[] = $ref;

                // BUSCA O NOME MAIS FREQUENTE DA REFERÊNCIA
                $nome_produto = '';
                $res_nome = $mysqli->query("
                    SELECT nome, COUNT(*) as qtd 
                    FROM produtos 
                    WHERE referencia = '{$mysqli->real_escape_string($ref)}' 
                    AND nome IS NOT NULL AND TRIM(nome) != ''
                    GROUP BY nome 
                    ORDER BY qtd DESC 
                    LIMIT 1
                ");
                if ($res_nome && $row_nome = $res_nome->fetch_assoc()) {
                    $nome_produto = $row_nome['nome'];
                }

                $referencias[] = [
                    'nome' => $nome_produto !== '' ? $nome_produto : $ref
                ];
            }
        }

        // CONTA TODAS LINHAS QUE POSSUEM A REFERÊNCIA OU O DOMÍNIO, SEM DUPLICAR
        $total_dom = 0;
        $cond_referencias = "0";
        if (count($referencias_listadas) > 0) {
            $referencias_escaped = array_map([$mysqli, 'real_escape_string'], $referencias_listadas);
            $refs_str = "'" . implode("','", $referencias_escaped) . "'";
            $cond_referencias = "referencia IN ($refs_str)";
        }

        $sql_total_linhas = "
            SELECT COUNT(DISTINCT id) AS total
            FROM produtos
            WHERE ($cond_referencias OR link LIKE '$dominio_like')
        ";
        $res_total_linhas = $mysqli->query($sql_total_linhas);
        if ($res_total_linhas && $row_total = $res_total_linhas->fetch_assoc()) {
            $total_dom = intval($row_total['total']);
        }

        // BUSCA A QUANTIDADE DE ANÚNCIOS DA TABELA `dominios`
        $qnt_anuncios = 0;
        $res_anuncios = $mysqli->query("
            SELECT qnt_anuncios 
            FROM dominios 
            WHERE dominio = '{$mysqli->real_escape_string($dominio)}'
            LIMIT 1
        ");
        if ($res_anuncios && $row_anuncios = $res_anuncios->fetch_assoc()) {
            $qnt_anuncios = intval($row_anuncios['qnt_anuncios']);
        }

        $dados[] = [
            'dominio' => $dominio,
            'referencias' => $referencias,
            'quantidade_mesmo_dominio' => $total_dom,
            'qnt_anuncios' => $qnt_anuncios
        ];
    }
}

// Ordena os dados pela quantidade de anúncios (decrescente)
usort($dados, function ($a, $b) {
    return $b['qnt_anuncios'] <=> $a['qnt_anuncios'];
});

// BUSCAR DOMÍNIOS QUE ESTÃO EM `dominios` MAS NÃO EM `dominios_padrao`
$dominios_faltando = [];
$res_faltando = $mysqli->query("
    SELECT d.dominio
    FROM dominios d
    LEFT JOIN dominios_padrao dp ON d.dominio = dp.dominio
    WHERE dp.dominio IS NULL
");

if ($res_faltando) {
    while ($row = $res_faltando->fetch_assoc()) {
        $dominios_faltando[] = $row['dominio'];
    }
}

// JSON de resposta
echo json_encode([
    'total' => count($dados),
    'resultados' => $dados,
    'dominios_faltando' => $dominios_faltando
]);
