<?php
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
if ($mysqli->connect_error) {
    exit("❌ Erro ao conectar: " . $mysqli->connect_error);
}

// Busca os 3 domínios com prioridade alta e mais antigos pela data_ultm_anun
$query = "
    SELECT DISTINCT dominio 
    FROM dominios 
    WHERE prioridade = 'alta'
      AND dominio NOT IN (SELECT dominio FROM dominios_padrao)
    ORDER BY data_ultm_anun ASC 
    LIMIT 3
";

$res = $mysqli->query($query);
if (!$res) {
    exit("❌ Erro ao buscar domínios: " . $mysqli->error);
}

function getJsonComTimeout($url, $timeout = 120) {
    $ch = curl_init($url);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        $error = curl_error($ch);
        curl_close($ch);
        return ['success' => false, 'error' => $error];
    }

    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode != 200) {
        return ['success' => false, 'error' => "HTTP $httpCode"];
    }

    return ['success' => true, 'data' => json_decode($response, true)];
}

while ($row = $res->fetch_assoc()) {
    $dominio = $row['dominio'];
    $url = "http://revelador2025.online:3000/?dominio=" . urlencode($dominio);
    
    echo "🔍 Consultando: $url\n";

    $resposta = getJsonComTimeout($url, 120);

    if (!$resposta['success']) {
        echo "❌ Erro ao consultar domínio: $dominio → {$resposta['error']}\n";
        continue;
    }

    $json = $resposta['data'];
    if (!isset($json['total'])) {
        echo "⚠️ Resposta inesperada para $dominio\n";
        continue;
    }

    $total = intval($json['total']);
    $dataAgora = date('Y-m-d H:i:s');

    // Atualiza todos os registros que têm esse domínio
    $dominioEscapado = $mysqli->real_escape_string($dominio);
    $update = $mysqli->query("
        UPDATE dominios 
        SET qnt_anuncios = $total, data_ultm_anun = '$dataAgora' 
        WHERE dominio = '$dominioEscapado'
    ");

    if ($update) {
        echo "✅ Atualizado: $dominio → $total anúncios encontrados\n";
    } else {
        echo "❌ Erro ao atualizar domínio: $dominio\n";
    }

    
  $inserirHistorico = $mysqli->query("
    INSERT INTO historico_anuncios (data, dominio, anuncios_ativos)
    VALUES ('$dataAgora', '$dominioEscapado', $total)
");

if ($inserirHistorico) {
    echo "📝 Histórico salvo com sucesso para $dominio\n";
} else {
    echo "❌ Erro ao salvar histórico de $dominio: " . $mysqli->error . "\n";
}


    sleep(5);
}

echo "\n🟢 Finalizado.\n";
?>
