<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

// DADOS DE CONEXÃO
$host = 'localhost';
$db = 'wwmari_db';
$user = 'wwmari_admin';
$pass = '1UQ4^%naXgaFc8Zq8B&bL*85Nj5dkt*A';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['erro' => 'Erro ao conectar no banco']);
    exit;
}

// Parâmetros recebidos
$experimento = $_GET['experimento'] ?? null;
$dataInicio = $_GET['data_inicio'] ?? null;
$dataFim = $_GET['data_fim'] ?? null;

if (!$experimento) {
    echo json_encode(['erro' => 'Experimento é obrigatório']);
    exit;
}

// Consulta usando datas para contagem
$sql = "SELECT
  variacao,
  COUNT(*) AS total,
  COUNT(horario_iniciou_compra) AS iniciou,
  COUNT(horario_convertido) AS convertido,
  COUNT(horario_convertido_upsell) AS upsell,
  SUM(
    CASE 
      WHEN horario_convertido IS NOT NULL THEN IFNULL(valor, 25.35)
      ELSE 0
    END
  ) AS valor
FROM ab_test_resultados
WHERE experimento = :experimento";

$params = [':experimento' => $experimento];

if ($dataInicio && $dataFim) {
    $sql .= " AND data_criado BETWEEN :inicio AND :fim";
    $params[':inicio'] = $dataInicio . " 00:00:00";
    $params[':fim'] = $dataFim . " 23:59:59";
}

$sql .= " AND data_criado <= DATE_SUB(NOW(), INTERVAL 20 MINUTE) GROUP BY variacao";


$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$dados = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($dados);
