<?php
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");

if ($mysqli->connect_error) {
    die("Erro na conexão com o banco de dados");
}

$id = intval($_GET['id'] ?? 0);

$result = $mysqli->query("SELECT * FROM ofertas WHERE id = $id");
if (!$result || $result->num_rows === 0) {
    die("Oferta não encontrada.");
}

$oferta = $result->fetch_assoc();

// Busca produtos com mesma referência (prioridade)
$referencia = $mysqli->real_escape_string($oferta['referencia']);

$checkouts = [];
$externos = [];

if (!empty($referencia)) {
    $resProdutos = $mysqli->query("SELECT * FROM produtos WHERE referencia = '$referencia'");
} else {
    $linkBase = strtok($oferta['link'], '?');
    $linkBase = $mysqli->real_escape_string($linkBase);
    $resProdutos = $mysqli->query("SELECT * FROM produtos WHERE link LIKE '$linkBase%'");
}

if ($resProdutos) {
    while ($p = $resProdutos->fetch_assoc()) {
        if (str_starts_with($p['link'], 'https://checkout')) {
            $checkouts[] = $p;
        } else {
            $externos[] = $p;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Detalhes da Oferta</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
    <h3>Detalhes da Oferta</h3>
    <p><strong>ID:</strong> <?= $oferta['id'] ?></p>
    <p><strong>Referência:</strong> <?= htmlspecialchars($oferta['referencia']) ?></p>
    <p><strong>Nome:</strong> <?= htmlspecialchars($oferta['nome']) ?></p>
    <p><strong>Link:</strong> <a href="<?= htmlspecialchars($oferta['link']) ?>" target="_blank"><?= htmlspecialchars($oferta['link']) ?></a></p>
    <p><strong>Checkouts:</strong> <?= $oferta['checkouts'] ?></p>
    <p><strong>Anúncios:</strong> <?= $oferta['anuncios'] ?></p>
    <p><strong>Dólar:</strong> <?= $oferta['dolar'] ?></p>

    <hr>
    <h4>Produtos Relacionados</h4>

    <?php if (count($checkouts) > 0): ?>
        <h5>Checkouts encontrados (<?= count($checkouts) ?>)</h5>
        <table class="table table-sm table-bordered">
            <thead class="table-light">
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Link</th>
                <th>Imagem</th>
                <th>Email</th>
                <th>Data</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($checkouts as $produto): ?>
                <tr>
                    <td><?= htmlspecialchars($produto['id']) ?></td>
                    <td><?= htmlspecialchars($produto['nome']) ?></td>
                    <td><a href="<?= htmlspecialchars($produto['link']) ?>" target="_blank"><?= substr($produto['link'], 0, 35) ?>...</a></td>
                    <td><a href="<?= htmlspecialchars($produto['imagem']) ?>" target="_blank">Ver</a></td>
                    <td><?= htmlspecialchars($produto['email_suporte']) ?></td>
                    <td><?= htmlspecialchars($produto['data']) ?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>

    <?php if (count($externos) > 0): ?>
        <h5>Links externos encontrados (<?= count($externos) ?>)</h5>
        <table class="table table-sm table-bordered">
            <thead class="table-light">
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Link</th>
                <th>Imagem</th>
                <th>Email</th>
                <th>Data</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($externos as $produto): ?>
                <tr>
                    <td><?= htmlspecialchars($produto['id']) ?></td>
                    <td><?= htmlspecialchars($produto['nome']) ?></td>
                    <td><a href="<?= htmlspecialchars($produto['link']) ?>" target="_blank"><?= substr($produto['link'], 0, 35) ?>...</a></td>
                    <td><a href="<?= htmlspecialchars($produto['imagem']) ?>" target="_blank">Ver</a></td>
                    <td><?= htmlspecialchars($produto['email_suporte']) ?></td>
                    <td><?= htmlspecialchars($produto['data']) ?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>

    <?php if (count($checkouts) === 0 && count($externos) === 0): ?>
        <p>Nenhum produto relacionado encontrado.</p>
    <?php endif; ?>

    <a href="index.php" class="btn btn-secondary mt-3">← Voltar</a>
</div>
</body>
</html>
