<?php
header('Content-Type: application/json');

// DADOS DE CONEXÃO
$host = 'localhost';
$db = 'wwmari_db';
$user = 'wwmari_admin';
$pass = '1UQ4^%naXgaFc8Zq8B&bL*85Nj5dkt*A';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['erro' => 'Erro ao conectar no banco']);
    exit;
}

// RECEBE O JSON
$data = json_decode(file_get_contents('php://input'), true);

$event_id = $data['event_id'] ?? null;
$fbp     = $data['fbp']     ?? null;
$fbc     = $data['fbc']     ?? null;
$cidade  = $data['cidade']  ?? null;
$estado  = $data['estado']  ?? null;
$cep     = $data['cep']     ?? null;
$ultima_pagina = $data['ultima_pagina'] ?? null;


if (!$event_id) {
    http_response_code(400);
    echo json_encode(['erro' => 'event_id ausente']);
    exit;
}

// BUSCA DADOS ATUAIS
try {
    $stmt = $pdo->prepare("SELECT fbp, fbc, cidade, estado, cep, ultima_pagina FROM eventos_facebook WHERE event_id = :event_id");
    $stmt->execute(['event_id' => $event_id]);
    $existente = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$existente) {
        http_response_code(404);
        echo json_encode(['erro' => 'event_id não encontrado']);
        exit;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['erro' => 'Erro ao buscar dados atuais']);
    exit;
}

// MONTA CAMPOS PARA ATUALIZAR APENAS SE ESTÃO VAZIOS NO BANCO
$campos = [];
$valores = [];

if ($fbp && empty($existente['fbp'])) {
    $campos[] = "fbp = :fbp";
    $valores['fbp'] = $fbp;
}
if ($fbc && empty($existente['fbc'])) {
    $campos[] = "fbc = :fbc";
    $valores['fbc'] = $fbc;
}
if ($cidade && empty($existente['cidade'])) {
    $campos[] = "cidade = :cidade";
    $valores['cidade'] = $cidade;
}
if ($estado && empty($existente['estado'])) {
    $campos[] = "estado = :estado";
    $valores['estado'] = $estado;
}
if ($cep && empty($existente['cep'])) {
    $campos[] = "cep = :cep";
    $valores['cep'] = $cep;
}

if ($ultima_pagina && empty($existente['ultima_pagina'])) {
    $campos[] = "ultima_pagina = :ultima_pagina";
    $valores['ultima_pagina'] = $ultima_pagina;
}


if (empty($campos)) {
    echo json_encode(['status' => 'nenhum campo elegível para atualização']);
    exit;
}

$valores['event_id'] = $event_id;

$sql = "UPDATE eventos_facebook SET " . implode(', ', $campos) . " WHERE event_id = :event_id";

try {
    $stmt = $pdo->prepare($sql);
    $stmt->execute($valores);
    echo json_encode(['status' => 'campos atualizados', 'atualizados' => array_keys($valores)]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['erro' => 'Erro ao atualizar']);
}
