<?php
header('Content-Type: application/json');

// DADOS DE CONEXÃO
$host = 'localhost';
$db = 'wwmari_db';
$user = 'wwmari_admin';
$pass = '1UQ4^%naXgaFc8Zq8B&bL*85Nj5dkt*A';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['erro' => 'Erro ao conectar no banco']);
    exit;
}

// Dados JSON recebidos
$input = json_decode(file_get_contents('php://input'), true);

// Campos esperados
$experimento = $input['experimento'] ?? null;
$variacao = $input['variacao'] ?? null;
$usuario = $input['identificacao_usuario'] ?? null;
$convertido = isset($input['convertido']) ? (int)$input['convertido'] : null;
$upsell = isset($input['convertido_upsell']) ? (int)$input['convertido_upsell'] : null;
$iniciou = isset($input['iniciou_compra']) ? (int)$input['iniciou_compra'] : null;
$paginaIniciada = isset($input['pagina_iniciada']) && trim($input['pagina_iniciada']) !== ''
    ? trim($input['pagina_iniciada'])
    : null;
$valor = isset($input['valor']) ? floatval($input['valor']) : null;
    

// Validação mínima
if (!$usuario) {
    http_response_code(400);
    echo json_encode(['erro' => 'Campo identificacao_usuario é obrigatório']);
    exit;
}

// Verifica se já existe
$stmt = $pdo->prepare("SELECT id FROM ab_test_resultados WHERE identificacao_usuario = :usuario");
$stmt->execute([':usuario' => $usuario]);

if ($stmt->rowCount()) {
    // UPDATE dinâmico apenas dos campos enviados
    $updates = [];
    $params = [ ':usuario' => $usuario ];

    if (!is_null($convertido)) {
        $updates[] = "convertido = :convertido";
        $params[':convertido'] = $convertido;
        if ($convertido == 1) {
            $updates[] = "horario_convertido = NOW()";
        }
    }

    if (!is_null($upsell)) {
        $updates[] = "convertido_upsell = :upsell";
        $params[':upsell'] = $upsell;
        if ($upsell == 1) {
            $updates[] = "horario_convertido_upsell = NOW()";
        }
    }

    if (!is_null($iniciou)) {
        $updates[] = "iniciou_compra = :iniciou";
        $params[':iniciou'] = $iniciou;
        if ($iniciou == 1) {
            $updates[] = "horario_iniciou_compra = NOW()";
        }
    }
if (!is_null($paginaIniciada)) {
    $updates[] = "pagina_iniciada = :pagina";
    $params[':pagina'] = $paginaIniciada;
}
    if (!empty($updates)) {
        $sql = "UPDATE ab_test_resultados SET " . implode(", ", $updates) . ", data_atualizado = NOW() 
                WHERE identificacao_usuario = :usuario";
        $update = $pdo->prepare($sql);
        $update->execute($params);
    }

} else {
    // INSERE novo registro
    if (!$experimento || !$variacao) {
        http_response_code(400);
        echo json_encode(['erro' => 'Campos experimento e variacao são obrigatórios na criação']);
        exit;
    }

   $sql = "INSERT INTO ab_test_resultados 
(experimento, variacao, identificacao_usuario, convertido, convertido_upsell, iniciou_compra, horario_convertido, horario_convertido_upsell, horario_iniciou_compra, pagina_iniciada, valor, data_criado, data_atualizado) 
VALUES (:exp, :var, :usuario, :conv, :upsell, :iniciou, :horario_convertido, :horario_upsell, :horario_iniciou, :pagina, :valor, NOW(), NOW())";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':exp' => $experimento,
        ':var' => $variacao,
        ':usuario' => $usuario,
        ':conv' => $convertido ?? 0,
        ':upsell' => $upsell ?? 0,
        ':pagina' => $paginaIniciada,
        ':valor' => $valor,
        ':iniciou' => $iniciou ?? 0,
        ':horario_convertido' => ($convertido === 1) ? date('Y-m-d H:i:s') : null,
        ':horario_upsell' => ($upsell === 1) ? date('Y-m-d H:i:s') : null,
        ':horario_iniciou' => ($iniciou === 1) ? date('Y-m-d H:i:s') : null,
    ]);
}

echo json_encode(['status' => 'ok']);
