<?php
header('Content-Type: application/json');

$lat = floatval($_GET['lat'] ?? 0);
$lon = floatval($_GET['lon'] ?? 0);
$radius = 300000; // até 3 km

// 🔍 Tags mais comuns para motéis no OpenStreetMap
$query = "
[out:json];
(
  node[\"tourism\"=\"motel\"](around:$radius,$lat,$lon);
  way[\"tourism\"=\"motel\"](around:$radius,$lat,$lon);
  node[\"name\"~\"(?i)motel\"](around:$radius,$lat,$lon);
  way[\"name\"~\"(?i)motel\"](around:$radius,$lat,$lon);
);
out center;
";

$url = "https://overpass-api.de/api/interpreter?data=" . urlencode($query);
$response = @file_get_contents($url);
$data = json_decode($response, true);

// Processa os resultados
$resultados = [];

if (!empty($data['elements'])) {
    foreach ($data['elements'] as $el) {
        $nome = $el['tags']['name'] ?? 'Estabelecimento sem nome';
        $lat2 = $el['lat'] ?? ($el['center']['lat'] ?? null);
        $lon2 = $el['lon'] ?? ($el['center']['lon'] ?? null);

        if ($lat2 && $lon2) {
            $resultados[] = [
                'nome' => $nome,
                'latitude' => $lat2,
                'longitude' => $lon2
            ];
        }
    }
}

echo json_encode($resultados);