<?php
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
$mysqli->set_charset("utf8mb4");

$antesDe = $_GET['antes_de'] ?? '';
$limite = 50;
$produtos = [];

if (!$mysqli->connect_error && $antesDe) {
    $antesDecimal = base_convert($antesDe, 36, 10);
    $res = $mysqli->query("SELECT * FROM produtos");

    while ($p = $res->fetch_assoc()) {
        $decId = base_convert($p['id'], 36, 10);
        if ($decId < $antesDecimal) {
            $produtos[] = $p;
        }
    }

    usort($produtos, fn($a, $b) =>
        base_convert($b['id'], 36, 10) <=> base_convert($a['id'], 36, 10)
    );

    $produtos = array_slice($produtos, 0, $limite);
}

foreach ($produtos as $produto): ?>
  <div class="col-6 col-sm-4 col-md-3 col-lg-2 mb-4 checkout-card" data-id="<?= $produto['id'] ?>">
    <div class="card h-100 shadow">
      <?php if ($produto['pagina_vendas'] !== 'sim'): ?>
        <div class="produto-img-wrapper">
          <img src="<?= htmlspecialchars($produto['imagem']) ?>" alt="Imagem do produto">
        </div>
      <?php endif; ?>
      <div class="card-body text-center">
        <h5 class="card-title"><?= htmlspecialchars($produto['nome'] ?? $produto['titulo']) ?></h5>
        <small class="d-block text-muted">Ref: <?= htmlspecialchars($produto['referencia']) ?></small>
        <p class="card-text">
          <?php if ($produto['pagina_vendas'] !== 'sim'): ?>
            <small class="text-muted"><?= htmlspecialchars($produto['data']) ?></small><br>
            <a href="<?= htmlspecialchars($produto['link']) ?>" class="btn btn-primary mt-2" target="_blank">Acessar Checkout</a>
          <?php else: ?>
            <a href="<?= htmlspecialchars($produto['link']) ?>" class="btn btn-outline-dark mt-2" target="_blank">Acessar Página</a>
          <?php endif; ?>
        </p>
      </div>
    </div>
  </div>
<?php endforeach; ?>
