<?php
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");

if ($mysqli->connect_error) {
    die("Erro na conexão com o banco de dados");
}

$id = intval($_GET['id'] ?? 0);

$result = $mysqli->query("SELECT * FROM ofertas WHERE id = $id");
if (!$result || $result->num_rows === 0) {
    die("Oferta não encontrada.");
}

$oferta = $result->fetch_assoc();

// Busca produtos com mesma referência (prioridade)
$referencia = $mysqli->real_escape_string($oferta['referencia']);
$produtos = [];

if (!empty($referencia)) {
    $resProdutos = $mysqli->query("SELECT * FROM produtos WHERE referencia = '$referencia'");
} else {
    // Se não houver referência, tenta pelo link base
    $linkBase = strtok($oferta['link'], '?');
    $linkBase = $mysqli->real_escape_string($linkBase);
    $resProdutos = $mysqli->query("SELECT * FROM produtos WHERE link LIKE '$linkBase%'");
}

if ($resProdutos) {
    $produtos = $resProdutos->fetch_all(MYSQLI_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Detalhes da Oferta</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
    <h3>Detalhes da Oferta</h3>
    <p><strong>ID:</strong> <?= $oferta['id'] ?></p>
    <p><strong>Referência:</strong> <?= htmlspecialchars($oferta['referencia']) ?></p>
    <p><strong>Nome:</strong> <?= htmlspecialchars($oferta['nome']) ?></p>
    <p><strong>Link:</strong> <a href="<?= htmlspecialchars($oferta['link']) ?>" target="_blank"><?= htmlspecialchars($oferta['link']) ?></a></p>
    <p><strong>Checkouts:</strong> <?= $oferta['checkouts'] ?></p>
    <p><strong>Anúncios:</strong> <?= $oferta['anuncios'] ?></p>
    <p><strong>Dólar:</strong> <?= $oferta['dolar'] ?></p>

    <hr>
    <h4>Produtos Relacionados</h4>
    <?php if (count($produtos) > 0): ?>
        <table class="table table-sm table-bordered">
            <thead class="table-light">
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Link</th>
                <th>Imagem</th>
                <th>Email</th>
                <th>Data</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($produtos as $produto): ?>
                <tr>
                    <td><?= htmlspecialchars($produto['id']) ?></td>
                    <td><?= htmlspecialchars($produto['nome']) ?></td>
                    <td><a href="<?= htmlspecialchars($produto['link']) ?>" target="_blank"><?= substr($produto['link'], 0, 35) ?>...</a></td>
                    <td><a href="<?= htmlspecialchars($produto['imagem']) ?>" target="_blank">Ver</a></td>
                    <td><?= htmlspecialchars($produto['email_suporte']) ?></td>
                    <td><?= htmlspecialchars($produto['data']) ?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>Nenhum produto relacionado encontrado.</p>
    <?php endif; ?>
    <a href="index.php" class="btn btn-secondary mt-3">← Voltar</a>
</div>
</body>
</html>
