<?php

function logTentativa($mensagem) {
    file_put_contents('log_api.txt', "[" . date('Y-m-d H:i:s') . "] $mensagem\n", FILE_APPEND);
}

// Entrada do número
$numero = $_POST['numero'] ?? '';
$numero = preg_replace('/[^0-9]/', '', $numero);

// Garante que o número comece com 55
if (!str_starts_with($numero, '55')) {
    $numero = '55' . $numero;
}


// Validação inicial
if (!$numero) {
    retornaImagemPadrao();
}

// Gera versão sem o 9 após o DDD (se houver)
$numero = preg_replace('/[^0-9]/', '', $numero);

// Garante que o número comece com 55
if (!str_starts_with($numero, '55')) {
    $numero = '55' . $numero;
}

// Remove o 9 após o DDD, se houver (gera número alternativo)
$numeroSem9 = preg_replace('/^(55\d{2})9/', '$1', $numero);

// Host e caminhos
$host = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
$host .= $_SERVER['HTTP_HOST'];
$pasta = 'imagens';
$caminhoPadrao = "$host/perfilsemfoto.jpg";
$nomeArquivo = "$numero.jpg";
$caminhoFinal = "$pasta/$nomeArquivo";
$caminhoCompleto = "$host/$caminhoFinal";

// Tenta buscar imagem nas duas chaves (ordem randomizada)
$chaves = [
    [
        'nome' => 'Chave 1',
        'host' => 'whatsapp-data1.p.rapidapi.com',
        'key'  => 'c96544b5afmshae5c34f07eb44adp17268cjsne7584120f776'
    ],
    [
        'nome' => 'Chave 2',
        'host' => 'whatsapp-data1.p.rapidapi.com',
        'key'  => 'dd5b61beb8msh2f27ea737b75215p1ccd30jsn6f05fbf44ab9'
    ]
];
shuffle($chaves);

// Tenta as 4 variações nas duas chaves
foreach ($chaves as $chave) {
    foreach ([$numero, $numeroSem9] as $numTestado) {
        $imagemUrl = buscarImagemAPI1($numTestado, $chave['host'], $chave['key'], $chave['nome']);
        if ($imagemUrl) {
            salvarERetornarImagem($imagemUrl, $caminhoFinal, $caminhoCompleto, $caminhoPadrao);
        }
    }
}

// Tenta API 3 (BKUP)
$imagemUrl = buscarImagemAPI3($numero);
if ($imagemUrl) {
    salvarERetornarImagem($imagemUrl, $caminhoFinal, $caminhoCompleto, $caminhoPadrao);
}

// Se nenhuma imagem encontrada
retornaImagemPadrao();

function buscarImagemAPI1($numero, $host, $key, $nomeChave) {
    $url = "https://$host/number/$numero?base64=false";
    logTentativa("Tentando $url com $nomeChave");

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 5,
        CURLOPT_HTTPHEADER => [
            "x-rapidapi-host: $host",
            "x-rapidapi-key: $key"
        ],
    ]);

    $response = curl_exec($curl);
    curl_close($curl);

    if (!$response) return null;

    $resposta = json_decode($response, true);
    if (isset($resposta['error']) && str_contains($resposta['error'], "doesn't exist")) return null;

    return $resposta['urlImage'] ?? $resposta['profilePic'] ?? null;
}

function buscarImagemAPI3($numero) {
    logTentativa("Tentando API 3 com número: $numero");

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => "https://whatsapp-data.p.rapidapi.com/wspicture?phone=$numero",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 5,
        CURLOPT_HTTPHEADER => [
            "x-rapidapi-host: whatsapp-data.p.rapidapi.com",
            "x-rapidapi-key: dd5b61beb8msh2f27ea737b75215p1ccd30jsn6f05fbf44ab9"
        ],
    ]);

    $response = curl_exec($curl);
    curl_close($curl);

    if (!$response) return null;

    if (preg_match('/https?:\/\/[^\"\'\s]+/', $response, $matches)) {
        return $matches[0]; // A imagem está no corpo puro da resposta
    }

    return null;
}

function salvarERetornarImagem($url, $destino, $urlFinal, $fallback) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
    $imgData = curl_exec($ch);
    curl_close($ch);

    if (!$imgData) retornaImagemPadrao();

    $srcImage = @imagecreatefromstring($imgData);
    if (!$srcImage) retornaImagemPadrao();

    $destImage = imagecreatetruecolor(150, 150);
    imagecopyresampled($destImage, $srcImage, 0, 0, 0, 0, 150, 150, imagesx($srcImage), imagesy($srcImage));

    if (!is_dir(dirname($destino))) {
        mkdir(dirname($destino), 0755, true);
    }
    imagejpeg($destImage, $destino, 90);
    imagedestroy($srcImage);
    imagedestroy($destImage);

    echo json_encode(['imagem' => $urlFinal], JSON_UNESCAPED_SLASHES);
    exit;
}

function retornaImagemPadrao() {
    global $caminhoPadrao;
    echo json_encode(['imagem' => $caminhoPadrao], JSON_UNESCAPED_SLASHES);
    exit;
}
