<?php
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
if ($mysqli->connect_error) {
    exit;
}

// 1. Buscar domínios com ref ou domínio em branco
$resDominios = $mysqli->query("SELECT id, dominio FROM dominios WHERE ref IS NULL OR ref = ''");
if (!$resDominios) {
    exit;
}

while ($dom = $resDominios->fetch_assoc()) {
    $idDom = $dom['id'];
    $dominioAtual = trim($dom['dominio']);

    // 2. Buscar os últimos 300 produtos com página de vendas válida e ref preenchida
    $resProdutos = $mysqli->query("
        SELECT referencia, link, link_solicitado
        FROM produtos
        WHERE pagina_vendas = 'sim'
          AND referencia IS NOT NULL AND referencia != ''
        ORDER BY id DESC
        LIMIT 300
    ");

    $encontrado = false;

    while ($prod = $resProdutos->fetch_assoc()) {
        $ref = $prod['referencia'];
        $url = $prod['link'] ?: $prod['link_solicitado'];
        if (!$url) continue;

        $dominioProduto = parse_url($url, PHP_URL_HOST);
        $dominioProduto = strtolower(str_replace('www.', '', $dominioProduto));
        if (!$dominioProduto) continue;

        if ($dominioAtual && $dominioProduto !== $dominioAtual) continue;

        $refEscapada = $mysqli->real_escape_string($ref);
        $domEscapado = $mysqli->real_escape_string($dominioProduto);
        $check = $mysqli->query("SELECT id FROM dominios WHERE dominio = '$domEscapado' AND ref = '$refEscapada' LIMIT 1");

        if ($check && $check->num_rows > 0) continue;

        $stmt = $mysqli->prepare("UPDATE dominios SET dominio = ?, ref = ? WHERE id = ?");
        $stmt->bind_param("ssi", $dominioProduto, $ref, $idDom);
        $stmt->execute();
        $stmt->close();

        $encontrado = true;
        break;
    }
}
?>
