<!doctype html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificação de mensagens - 1</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet" />

    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-image: url('6240b66d5c50c8661eee78b439a7d33c.webp');
            /* Fundo similar ao do WhatsApp */
            background-size: cover;
            background-repeat: repeat-y;
            /* Repetir verticalmente */
            height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            color: white;
        }

        .main-container {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100vh;
            width: 100%;
        }

        .container {
            background-color: #fafafa;
            /* Cor de fundo do card parecida com o WhatsApp */
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            text-align: center;
            width: 90%;
            max-width: 500px;
            margin-bottom: 20px;
            /* Adicionando margem inferior para separar as seções */
        }

        h1 {
            margin-bottom: 20px;
            font-size: 1.5em;
            color: #DCF8C6;
            /* Cor do texto do título */
        }

        .btn-custom {
            background-color: #25D366;
            /* Cor do botão do WhatsApp */
            color: white;
            border: none;
            padding: 15px;
            border-radius: 5px;
            font-size: 1em;
            margin: 10px 0;
            width: 100%;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .btn-custom:hover {
            background-color: #1EBE57;
            /* Cor do botão ao passar o mouse */
        }

        .container-info {
            background-color: rgba(0, 0, 0, 0.7);
            /* Fundo semitransparente */
            padding: 1px;
            border-radius: 10px;
            width: 90%;
            max-width: 500px;
            color: white;
            text-align: left;
            /* Alinhamento do texto à esquerda */
        }

        .container-info h2 {
            font-size: 1.3em;
            margin-top: 10px;
            margin-bottom: 10px;
            color: #DCF8C6;
        }

        .container-info p {
            font-size: 1em;
            margin-bottom: 10px;
            color: #ffffff;
        }

        .destaque {
            font-weight: 600;
        }

        .titulo {
            color: rgb(75, 75, 75);
            font-size: 22px;
            line-height: 100%;
            font-weight: 600;
        }

        .input-group-text {
            background-color: #e9ecef;
            font-weight: bold;
            border-right: 0;
        }

        .form-control {
            border-left: 0;
        }

        hr {
            border: none;
            height: 1px;
            background-color: #ccc;
            margin: 20px 0;
        }
        .btn-custom:disabled {
    background-color:rgb(150, 189, 164);
    cursor: not-allowed;
}

    </style>
</head>

<body>
    <div class="main-container">
        <br><br>
        <div class="container">

            <h1 class=destaque style="color:red; font-size: 18px;">Você ganhou <span
                    style="color:red; font-size: 18px; text-decoration: underline;">1 Acesso grátuito, </span> após
                investigar um número não será possível procurar outro na versão gratúita</h1>
            <hr><br>
            <div class="titulo">Digite o Numero para ivnestigar</div>
            <br>
            <form action="pesquisando.php" method="post">
                <div class="input-group mb-3">
                    <span class="input-group-text" id="basic-addon1">+55</span>
                    <input type="tel" name="numero" id="numero" class="form-control" placeholder="(99) 9 9999-9999"
    aria-label="Número de telefone" aria-describedby="basic-addon1">
                </div>
                <button id="btn-investigar" class="submit btn btn-custom" disabled>INVESTIGAR AGORA</button>

            </form>
        </div>
    </div>



    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"
        integrity="sha384-7+zCNj/IqJ95wo16oMtfsKbZ9ccEh31eOz1HGyDuCQ6wgnyJNSYdrPa03rtR1zdB"
        crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"
        integrity="sha384-QJHtvGhmr9XOIpI6YVutG+2QOK9T+ZnN4kzFN1RtK3zEFEIsxhlmWl5/YESvpZ13"
        crossorigin="anonymous"></script>

    <script>


 const urlParams = new URLSearchParams(window.location.search);
    const pessoaadd = urlParams.get('pessoa');
    if (pessoaadd) {
        setCookie('genero', pessoaadd, 7); // Salvar por 7 dias
    }

function formatPhoneInput(event) {
    const inputField = event.target;
    let inputRaw = inputField.value.replace(/\D/g, '');

    // Formatar número para visualização
    let inputFormatado = inputRaw;
    if (inputRaw.length > 10) {
        inputFormatado = inputRaw.replace(/^(\d{2})(\d{5})(\d{4}).*/, '($1) $2-$3');
    } else if (inputRaw.length > 6) {
        inputFormatado = inputRaw.replace(/^(\d{2})(\d{4})(\d{0,4}).*/, '($1) $2-$3');
    } else if (inputRaw.length > 2) {
        inputFormatado = inputRaw.replace(/^(\d{2})(\d{0,5})/, '($1) $2');
    } else {
        inputFormatado = inputRaw.replace(/^(\d*)/, '($1');
    }

    // Atualiza o valor no input
    inputField.value = inputFormatado;

    // Verificação final com base nos dígitos puros
    const button = document.getElementById('btn-investigar');
    if (inputRaw.length === 11) {
        button.disabled = false;
        setCookie('numero', inputFormatado, 7);
    } else {
        button.disabled = true;
        setCookie('numero', '', -1);
    }
}





        // Função para obter valor do cookie
        function getCookie(name) {
            let match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
            if (match) return match[2];
        }

        // Função para obter os parâmetros da URL
        function getUrlParams() {
            return window.location.search.substring(1);
        }

        // Função para definir o cookie
        function setCookie(name, value, days) {
            var expires = "";
            if (days) {
                var date = new Date();
                date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
                expires = "; expires=" + date.toUTCString();
            }
            document.cookie = name + "=" + (value || "") + expires + "; path=/";
        }

        window.onload = function () {

            // Verifica se o cookie já existe
            if (!getCookie('parametros')) {
                // Obter os parâmetros da URL e salvar no cookie
                var params = getUrlParams();
                setCookie('parametros', params, 7); // Salva o cookie por 7 dias

                var links = document.getElementsByTagName("a");
                for (var i = 0, n = links.length; i < n; i++) {
                    var href = new URL(links[i].href);
                    if (!href.search) {
                        href.search = document.location.search;
                        links[i].href = href.toString();
                    }
                }
            } else {
                // Se não houver parâmetros na URL, buscar no cookie e adicionar à URL
                var currentParams = new URLSearchParams(window.location.search);
                if (!currentParams.toString()) {
                    var cookieParams = getCookie('parametros');
                    if (cookieParams) {
                        var newUrl = window.location.origin + window.location.pathname + '?' + cookieParams;
                        window.history.replaceState({}, '', newUrl);
                    }
                }
            }
        }
// Verifica se os cookies 'numero' e 'print' existem
    const hasNumero = getCookie('numero') !== null;
    const hasPrint = getCookie('print') !== null;

// Caminho padrão do back redirect
    let urlBackRedirect = window.location.origin + window.location.pathname.replace(/\/[^\/]*$/, '/') + 'desconto1.php';

    // Se ambos os cookies existirem, muda o redirecionamento
    if (hasNumero && hasPrint) {
        urlBackRedirect = window.location.origin + window.location.pathname.replace(/\/[^\/]*$/, '/') + 'bk_gratis_expirado.php';
    }
    


        // Pegar todos os parâmetros da URL atual
        var currentParams = new URLSearchParams(window.location.search);

        // Se não houver parâmetros na URL, buscar no cookie
        if (!currentParams.toString()) {
            var cookieParams = getCookie('parametros');
            if (cookieParams) {
                currentParams = new URLSearchParams(cookieParams);
            }
        }

        // Adicionar os parâmetros à URL de redirecionamento
        if (currentParams.toString()) {
            urlBackRedirect += (urlBackRedirect.indexOf('?') > -1 ? '&' : '?') + currentParams.toString();
        }

        history.pushState({}, "", location.href);
        history.pushState({}, "", location.href);
        window.onpopstate = function () {
            setTimeout(function () {
                location.href = urlBackRedirect;
            }, 1);
        };

        function getOnlyDigits(value) {
    return value.replace(/\D/g, '');
}

function formatToPhone(value) {
    let digits = getOnlyDigits(value);
    if (digits.length > 10) {
        return digits.replace(/^(\d{2})(\d{5})(\d{4}).*/, '($1) $2-$3');
    } else if (digits.length > 6) {
        return digits.replace(/^(\d{2})(\d{4})(\d{0,4}).*/, '($1) $2-$3');
    } else if (digits.length > 2) {
        return digits.replace(/^(\d{2})(\d{0,5})/, '($1) $2');
    } else {
        return digits.replace(/^(\d*)/, '($1');
    }
}

function validateAndToggleButton() {
    const input = document.getElementById('numero');
    const button = document.getElementById('btn-investigar');

    let onlyDigits = getOnlyDigits(input.value);

    // Garante no máximo 11 dígitos
    if (onlyDigits.length > 11) {
        onlyDigits = onlyDigits.substring(0, 11);
    }

    // Atualiza o campo com formatação
    input.value = formatToPhone(onlyDigits);

    // Verifica se tem exatamente 11 dígitos após truncar
    if (onlyDigits.length === 11) {
        button.disabled = false;
        setCookie('numero', input.value, 7);
    } else {
        button.disabled = true;
        setCookie('numero', '', -1);
    }
}


// Adiciona ouvintes de evento
document.addEventListener('DOMContentLoaded', function () {
    const input = document.getElementById('numero');

    input.addEventListener('input', validateAndToggleButton);
    input.addEventListener('blur', validateAndToggleButton);
    input.addEventListener('change', validateAndToggleButton);
});

    </script>

</body>

</html>