<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// ------------------ Função para desenhar microfone ------------------
function desenhar_microfone(&$base, $path, $x, $y, $tamanho)
{
    if (!file_exists($path)) {
        die("Imagem microfone não encontrada.");
    }

    $mic = imagecreatefrompng($path);

    $micResized = imagecreatetruecolor($tamanho, $tamanho);
    imagealphablending($micResized, false);
    imagesavealpha($micResized, true);
    $transp = imagecolorallocatealpha($micResized, 0, 0, 0, 127);
    imagefill($micResized, 0, 0, $transp);

    imagecopyresampled(
        $micResized, $mic,
        0, 0, 0, 0,
        $tamanho, $tamanho,
        imagesx($mic), imagesy($mic)
    );

    imagecopy($base, $micResized, $x, $y, 0, 0, $tamanho, $tamanho);

    imagedestroy($micResized);
    imagedestroy($mic);
}

// ------------------ Variáveis de entrada ------------------
$pessoa = $_COOKIE['imagem_perfil'] ?? ($_POST['caminho_imagem'] ?? '');
$numerotemp = $_COOKIE['numero'] ?? ($_POST['numero'] ?? '');
$nomeSeguro = preg_replace('/[^a-zA-Z0-9]/', '', $numerotemp);
$numeroparte = substr($numerotemp, 1, 2);
$numero = "+55 " . $numeroparte . " 98";

$baseImagePath = 'homem.jpg';
$microfonePath = __DIR__ . '/microfone.png';

if (empty($pessoa)) die("Imagem de perfil não foi definida.");
if (!file_exists($baseImagePath)) die("Imagem base não encontrada.");
$base = imagecreatefromjpeg($baseImagePath);

// ------------------ Configurações ------------------
$tamanho = 142;
$tamanho2 = 140;
$escala = 1.0;
$tamanho_mic = 90;
$tamanho3 = (int)($tamanho * $escala);

$coords = [
    'img1' => ['x' => 179, 'y' => 302],
    'img2' => ['x' => 179, 'y' => 790],
    'img3' => ['x' => 168, 'y' => 1240],
    'img4' => ['x' => 168, 'y' => 1420],
    'img5' => ['x' => 168, 'y' => 1826],
    'mic1' => ['x' => 266, 'y' => 368],
    'mic2' => ['x' => 266, 'y' => 856],
];

// ------------------ Carrega imagem do perfil ------------------
$ch = curl_init($pessoa);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
$imageContent = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);
if (!$imageContent || $http_code !== 200) die("Erro ao carregar imagem: $pessoa");

$overlay = @imagecreatefromstring($imageContent);
if (!$overlay) die("Erro ao criar imagem a partir do conteúdo carregado.");

// ------------------ Cria imagem circular ------------------
$circle = imagecreatetruecolor($tamanho, $tamanho);
imagealphablending($circle, false);
imagesavealpha($circle, true);
$transp = imagecolorallocatealpha($circle, 0, 0, 0, 127);
imagefill($circle, 0, 0, $transp);

$mask = imagecreatetruecolor($tamanho, $tamanho);
imagecopyresampled($mask, $overlay, 0, 0, 0, 0, $tamanho, $tamanho, imagesx($overlay), imagesy($overlay));

// Aplica máscara circular
for ($i = 0; $i < $tamanho; $i++) {
    for ($j = 0; $j < $tamanho; $j++) {
        $dx = $i - $tamanho / 2;
        $dy = $j - $tamanho / 2;
        if (sqrt($dx * $dx + $dy * $dy) <= $tamanho / 2) {
            $color = imagecolorat($mask, $i, $j);
            imagesetpixel($circle, $i, $j, $color);
        }
    }
}

// ------------------ Cola imagens da pessoa ------------------
imagecopy($base, $circle, $coords['img1']['x'], $coords['img1']['y'], 0, 0, $tamanho, $tamanho);
imagecopy($base, $circle, $coords['img2']['x'], $coords['img2']['y'], 0, 0, $tamanho, $tamanho);

// ------------------ Microfones ------------------
desenhar_microfone($base, $microfonePath, $coords['mic1']['x'], $coords['mic1']['y'], $tamanho_mic);
desenhar_microfone($base, $microfonePath, $coords['mic2']['x'], $coords['mic2']['y'], $tamanho_mic);

// ------------------ Imagens com blur ------------------
$circle_scaled = imagecreatetruecolor($tamanho3, $tamanho3);
imagealphablending($circle_scaled, false);
imagesavealpha($circle_scaled, true);
$transp = imagecolorallocatealpha($circle_scaled, 0, 0, 0, 127);
imagefill($circle_scaled, 0, 0, $transp);

imagecopyresampled($circle_scaled, $circle, 0, 0, 0, 0, $tamanho3, $tamanho3, $tamanho, $tamanho);

$blurred = imagecreatetruecolor($tamanho3, $tamanho3);
imagealphablending($blurred, false);
imagesavealpha($blurred, true);
imagefill($blurred, 0, 0, $transp);

imagecopy($blurred, $circle_scaled, 0, 0, 0, 0, $tamanho3, $tamanho3);

imagefilter($blurred, IMG_FILTER_PIXELATE, 15, true);

// Dissolver nas bordas
$center = $tamanho3 / 2;
$maxRadius = $tamanho3 / 2;
for ($i = 0; $i < $tamanho3; $i++) {
    for ($j = 0; $j < $tamanho3; $j++) {
        $dx = $i - $center;
        $dy = $j - $center;
        $distance = sqrt($dx * $dx + $dy * $dy);
        if ($distance > $maxRadius) {
            imagesetpixel($blurred, $i, $j, $transp);
        } elseif ($distance > $maxRadius * 0.8) {
            $alpha = 127 * (($distance - ($maxRadius * 0.8)) / ($maxRadius * 0.2));
            $rgba = imagecolorsforindex($blurred, imagecolorat($blurred, $i, $j));
            $newColor = imagecolorallocatealpha($blurred, $rgba['red'], $rgba['green'], $rgba['blue'], (int)$alpha);
            imagesetpixel($blurred, $i, $j, $newColor);
        }
    }
}

imagecopy($base, $blurred, $coords['img3']['x'], $coords['img3']['y'], 0, 0, $tamanho3, $tamanho3);
imagecopy($base, $blurred, $coords['img4']['x'], $coords['img4']['y'], 0, 0, $tamanho3, $tamanho3);
imagecopy($base, $blurred, $coords['img5']['x'], $coords['img5']['y'], 0, 0, $tamanho3, $tamanho3);

// ------------------ Texto ------------------
if (!empty($numero)) {
    $textX = 212;
    $textY = 60;
    $tamanhoFonte = 30;
    $angulo = 0;
    $corHex = "#FFFFFF";

    list($r, $g, $b) = sscanf($corHex, "#%02x%02x%02x");
    $corTexto = imagecolorallocate($base, $r, $g, $b);

    $fonte = __DIR__ . "/arialbd.ttf";
    imagettftext($base, $tamanhoFonte, $angulo, $textX, $textY, $corTexto, $fonte, $numero);
}


// ------------------ Salvar imagem em WEBP com nome do número ------------------

// Garante que o número seja um nome de arquivo seguro (remove espaços, símbolos, etc.)
$nomeSeguro = preg_replace('/[^a-zA-Z0-9]/', '', $numerotemp);
$nomeArquivo = "Print_".$nomeSeguro . '.webp';
$caminhoRelativo = 'prints/' . $nomeArquivo;
$caminhoAbsoluto = __DIR__ . '/' . $caminhoRelativo;

// Salva em WEBP (0 = menor qualidade/mais leve, 100 = máxima qualidade)
imagewebp($base, $caminhoAbsoluto, 70); // 70 é um bom equilíbrio entre qualidade e tamanho

// Monta URL com barras certas
$protocolo = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$host = $_SERVER['HTTP_HOST'];
$urlCompleta = $protocolo . $host . '/' . str_replace('\\', '/', $caminhoRelativo);

// Retorna via JSON
header('Content-Type: application/json');
echo json_encode(['url' => $urlCompleta], JSON_UNESCAPED_SLASHES);




// ------------------ Libera memória ------------------
imagedestroy($base);
imagedestroy($overlay);
imagedestroy($mask);
imagedestroy($circle);
imagedestroy($blurred);
imagedestroy($circle_scaled);
?>
