<?php
// Mostrar erros para debug
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
if ($mysqli->connect_error) {
    die("Erro na conexão: " . $mysqli->connect_error);
}

$criadas = 0;

function contarFaltantesComReferencia($mysqli) {
    $res = $mysqli->query("SELECT COUNT(*) AS total FROM produtos WHERE pagina_vendas = 'sim' AND referencia IS NOT NULL AND TRIM(referencia) != '' AND (oferta_criada IS NULL OR oferta_criada = '')");
    if ($res && $r = $res->fetch_assoc()) {
        return intval($r['total']);
    }
    return 0;
}

$totalFaltando = contarFaltantesComReferencia($mysqli);
while ($totalFaltando > 0) {
    $sql = "SELECT * FROM produtos WHERE pagina_vendas = 'sim' AND referencia IS NOT NULL AND TRIM(referencia) != '' AND (oferta_criada IS NULL OR oferta_criada = '') ORDER BY id ASC LIMIT 1";
    $result = $mysqli->query($sql);
    if (!$result || $result->num_rows == 0) break;

    $linha = $result->fetch_assoc();
    $referencia = $mysqli->real_escape_string($linha['referencia']);
    $link = $mysqli->real_escape_string($linha['link']);

    $nome = '';
    $res = $mysqli->query("SELECT nome FROM produtos WHERE referencia = '$referencia' AND nome IS NOT NULL AND TRIM(nome) != '' LIMIT 1");
    if ($res && $r = $res->fetch_assoc()) $nome = $r['nome'];

    $imagem = '';
    $res = $mysqli->query("SELECT imagem FROM produtos WHERE referencia = '$referencia' AND imagem IS NOT NULL AND TRIM(imagem) != '' LIMIT 1");
    if ($res && $r = $res->fetch_assoc()) $imagem = $r['imagem'];

    $email = '';
    $res = $mysqli->query("SELECT email_suporte FROM produtos WHERE referencia = '$referencia' AND email_suporte IS NOT NULL AND TRIM(email_suporte) != '' LIMIT 1");
    if ($res && $r = $res->fetch_assoc()) $email = $r['email_suporte'];

    $nomeEsc = $mysqli->real_escape_string($nome);
    $emailEsc = $mysqli->real_escape_string($email);
    $verificaOferta = $mysqli->query("SELECT id FROM ofertas WHERE nome = '$nomeEsc' AND email = '$emailEsc' LIMIT 1");
    if ($verificaOferta && $verificaOferta->num_rows > 0) {
        echo "<p style='color:orange;'>⚠️ Oferta já existente com mesmo nome e email: <strong>$nome</strong> | <strong>$email</strong></p>";
        $mysqli->query("UPDATE produtos SET oferta_criada = 'sim' WHERE referencia = '$referencia'");
        $totalFaltando = contarFaltantesComReferencia($mysqli);
        continue;
    }

    $criado_em = date("Y-m-d H:i:s");
    $res = $mysqli->query("SELECT data FROM produtos WHERE referencia = '$referencia' ORDER BY data ASC LIMIT 1");
    if ($res && $r = $res->fetch_assoc()) $criado_em = $r['data'];

    $checkouts = 0;
    $res = $mysqli->query("SELECT COUNT(*) AS total FROM produtos WHERE referencia = '$referencia'");
    if ($res && $r = $res->fetch_assoc()) $checkouts = intval($r['total']);

    preg_match('/https?:\/\/([^\/]+)/', $link, $matches);
    $dominio = isset($matches[1]) ? $mysqli->real_escape_string($matches[1]) : '';
    $anuncios = 0;
    if ($dominio) {
        $res = $mysqli->query("SELECT qnt_anuncios FROM dominios WHERE dominio = '$dominio'");
        if ($res && $r = $res->fetch_assoc()) $anuncios = intval($r['qnt_anuncios']);
    }

    $checkouts_dominio = 0;
    $dolar = 'nao';
    if ($dominio) {
        $res = $mysqli->query("SELECT DISTINCT referencia FROM produtos WHERE link LIKE '%$dominio%' AND referencia IS NOT NULL AND TRIM(referencia) != ''");
        $refs = [];
        while ($r = $res->fetch_assoc()) {
            $refs[] = "'" . $mysqli->real_escape_string($r['referencia']) . "'";
        }
        if (!empty($refs)) {
            $refsSql = implode(",", $refs);
            $res = $mysqli->query("SELECT COUNT(*) AS total FROM produtos WHERE referencia IN ($refsSql)");
            if ($res && $r = $res->fetch_assoc()) $checkouts_dominio = intval($r['total']);

            $res = $mysqli->query("SELECT 1 FROM produtos WHERE referencia IN ($refsSql) AND internacional = 'sim' LIMIT 1");
            if ($res && $res->num_rows > 0) $dolar = 'sim';
        }
    }

    $acompanhar = '';
    $stmt = $mysqli->prepare("INSERT INTO ofertas (referencia, nome, link, imagem_produto, anuncios, dolar, criado_em, checkouts, checkouts_dominio, email, acompanhar) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssississs", $referencia, $nome, $link, $imagem, $anuncios, $dolar, $criado_em, $checkouts, $checkouts_dominio, $email, $acompanhar);
    $stmt->execute();
    $stmt->close();

    $mysqli->query("UPDATE produtos SET oferta_criada = 'sim' WHERE referencia = '$referencia'");
    $criadas++;
    $totalFaltando = contarFaltantesComReferencia($mysqli);

    echo "<hr><strong>✅ [$criadas] Oferta criada:</strong> $referencia<br>";
    ob_flush();
    flush();
}


// Agora processar os que não têm referência
// Agora processar os que não têm referência e página de vendas é 'sim'
// Buscar todos os domínios bloqueados
$dominiosBloqueados = [];
$resDom = $mysqli->query("SELECT dominio FROM dominios_padrao");
while ($row = $resDom->fetch_assoc()) {
    $dom = trim(strtolower($row['dominio']));
    if ($dom) $dominiosBloqueados[] = $dom;
}

// Agora processar os que não têm referência
$res = $mysqli->query("SELECT * FROM produtos WHERE pagina_vendas = 'sim' AND (referencia IS NULL OR TRIM(referencia) = '') AND (oferta_criada IS NULL OR oferta_criada = '')");

while ($linha = $res->fetch_assoc()) {
    $link = trim($linha['link']);
    $criado_em = $linha['data'] ?: date("Y-m-d H:i:s");

    // Extrair domínio e caminho
    $parsed = parse_url($link);
    $dominio = isset($parsed['host']) ? strtolower($parsed['host']) : '';
    $caminho = isset($parsed['path']) ? $parsed['path'] : '/';

    // Limpar www.
    $dominioLimpo = preg_replace('/^www\./', '', $dominio);

    // Verificar se o domínio está bloqueado
    if (in_array($dominioLimpo, $dominiosBloqueados)) {
        echo "<p style='color:red;'>⛔ Domínio bloqueado: <strong>$dominio</strong> (limpo: <strong>$dominioLimpo</strong>), pulando...</p>";
        continue;
    }

    // Verificar duplicidade por domínio + caminho
   // Verificar duplicidade por domínio + caminho
$dominioEsc = $mysqli->real_escape_string($dominio);
$caminhoEsc = $mysqli->real_escape_string($caminho);
$resDup = $mysqli->query("SELECT id, link FROM ofertas WHERE link LIKE '%$dominioEsc%' AND link LIKE '%$caminhoEsc%' LIMIT 1");

if ($resDup && $resDup->num_rows > 0) {
    // Atualizar os produtos com mesmo domínio + caminho para 'sim'
    $link_base = $dominio . $caminho;
    $stmt = $mysqli->prepare("UPDATE produtos SET oferta_criada = 'sim' WHERE link LIKE CONCAT('%', ?, '%')");
    $stmt->bind_param("s", $link_base);
    $stmt->execute();
    $stmt->close();

    echo "<p style='color:gray;'>🔁 Link já existente com mesmo caminho: <strong>$link</strong>, pulando...</p>";
    continue;
}
// Usar título da tabela produtos, se houver
$nome = isset($linha['titulo']) ? trim($linha['titulo']) : '';

    // Dados default
    $imagem = '';
    $anuncios = 0;
    $dolar = 'nao';
    $checkouts = 0;
    $checkouts_dominio = 0;
    $email = '';
    $acompanhar = '';

    $stmt = $mysqli->prepare("INSERT INTO ofertas (referencia, nome, link, imagem_produto, anuncios, dolar, criado_em, checkouts, checkouts_dominio, email, acompanhar) VALUES ('', ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssississs", $nome, $link, $imagem, $anuncios, $dolar, $criado_em, $checkouts, $checkouts_dominio, $email, $acompanhar);
    $stmt->execute();
    $stmt->close();
// Marcar apenas os produtos com esse domínio e caminho exato como processados
$host = parse_url($link, PHP_URL_HOST);
$path = parse_url($link, PHP_URL_PATH);

// Construir um padrão base: domínio + path ignorando parâmetros
$link_base = $host . $path;

// Atualizar SOMENTE os produtos com mesmo domínio e path
$stmt = $mysqli->prepare("UPDATE produtos SET oferta_criada = 'sim' WHERE link LIKE CONCAT('%', ?, '%')");
$stmt->bind_param("s", $link_base);
$stmt->execute();
$stmt->close();

    $criadas++;

    echo "<hr><p style='color:green;'>✅ [$criadas] Oferta criada sem referência</p>";
    echo "<p><strong>🔗 Link:</strong> <a href='$link' target='_blank'>$link</a></p>";
    echo "<p><strong>🌍 Domínio:</strong> $dominio</p>";
    ob_flush();
    flush();
}

// Processar ofertas que ainda não foram criadas e possuem referência válida
$resRef = $mysqli->query("SELECT DISTINCT referencia FROM produtos 
                          WHERE referencia IS NOT NULL AND TRIM(referencia) != '' 
                          AND (oferta_criada IS NULL OR oferta_criada = '')");

while ($ref = $resRef->fetch_assoc()) {
    $referencia = $mysqli->real_escape_string(trim($ref['referencia']));

    // Verifica se já existe uma oferta com essa referência
$check = $mysqli->query("SELECT id, link FROM ofertas WHERE referencia = '$referencia' LIMIT 1");
if ($check && $check->num_rows > 0) {
    $ofertaExistente = $check->fetch_assoc();
    $idOferta = $ofertaExistente['id'];
    $linkAntigo = $ofertaExistente['link'];

    // Verifica se o novo link começa com https://checkout.p
    if (strpos($link, 'https://checkout.p') === 0) {
        // Atualiza o link da oferta
        $stmtUp = $mysqli->prepare("UPDATE ofertas SET link = ? WHERE id = ?");
        $stmtUp->bind_param("si", $link, $idOferta);
        $stmtUp->execute();
        $stmtUp->close();

        // Marcar apenas esta linha como oferta criada
        $idLinhaProduto = intval($linha['id']);
        $stmtProduto = $mysqli->prepare("UPDATE produtos SET oferta_criada = 'sim' WHERE id = ?");
        $stmtProduto->bind_param("i", $idLinhaProduto);
        $stmtProduto->execute();
        $stmtProduto->close();

        // Salvar no histórico a mudança
        $linkCurtoAntigo = substr($linkAntigo, 0, 20) . '...' . substr($linkAntigo, -20);
        $linkCurtoNovo = substr($link, 0, 20) . '...' . substr($link, -20);
        $evento = "Link atualizado: {$linkCurtoAntigo} → {$linkCurtoNovo}";
        $dataAgora = date("Y-m-d H:i:s");

        $stmtHist = $mysqli->prepare("INSERT INTO historico (referencia, evento, data) VALUES (?, ?, ?)");
        $stmtHist->bind_param("sss", $referencia, $evento, $dataAgora);
        $stmtHist->execute();
        $stmtHist->close();

        echo "<p style='color:blue;'>🔁 Atualizado link da oferta para referência <strong>$referencia</strong>.</p>";
        echo "<p><strong>📌 Evento:</strong> $evento</p>";

        continue; // pula para a próxima iteração
    } else {
        // Se não for link do tipo desejado, apenas marca como criada para evitar repetição
        $idLinhaProduto = intval($linha['id']);
        $stmtProduto = $mysqli->prepare("UPDATE produtos SET oferta_criada = 'sim' WHERE id = ?");
        $stmtProduto->bind_param("i", $idLinhaProduto);
        $stmtProduto->execute();
        $stmtProduto->close();

        continue;
    }
}


    // Buscar um nome
    $nome = '';
    $res = $mysqli->query("SELECT nome FROM produtos WHERE referencia = '$referencia' AND nome IS NOT NULL AND TRIM(nome) != '' LIMIT 1");
    if ($res && $r = $res->fetch_assoc()) $nome = $r['nome'];

    // Buscar uma imagem
    $imagem = '';
    $res = $mysqli->query("SELECT imagem FROM produtos WHERE referencia = '$referencia' AND imagem IS NOT NULL AND TRIM(imagem) != '' LIMIT 1");
    if ($res && $r = $res->fetch_assoc()) $imagem = $r['imagem'];

    // Buscar um email
    $email = '';
    $res = $mysqli->query("SELECT email_suporte FROM produtos WHERE referencia = '$referencia' AND email_suporte IS NOT NULL AND TRIM(email_suporte) != '' LIMIT 1");
    if ($res && $r = $res->fetch_assoc()) $email = $r['email_suporte'];

    // Buscar uma data de criação
    $criado_em = date("Y-m-d H:i:s");
    $res = $mysqli->query("SELECT data FROM produtos WHERE referencia = '$referencia' AND data IS NOT NULL ORDER BY data ASC LIMIT 1");
    if ($res && $r = $res->fetch_assoc()) $criado_em = $r['data'];

    // Buscar um link
    $link = '';
    $dominio = '';
    $res = $mysqli->query("SELECT link FROM produtos WHERE referencia = '$referencia' AND link IS NOT NULL AND TRIM(link) != '' LIMIT 1");
    if ($res && $r = $res->fetch_assoc()) {
        $link = $r['link'];
        preg_match('/https?:\/\/([^\/]+)/', $link, $matches);
        $dominio = isset($matches[1]) ? $mysqli->real_escape_string($matches[1]) : '';
    }

    // Verificar se é internacional
    $dolar = 'nao';
    $res = $mysqli->query("SELECT 1 FROM produtos WHERE referencia = '$referencia' AND internacional = 'sim' LIMIT 1");
    if ($res && $res->num_rows > 0) $dolar = 'sim';

    // Contagem de checkouts
    $checkouts = 0;
    $res = $mysqli->query("SELECT COUNT(*) AS total FROM produtos WHERE referencia = '$referencia'");
    if ($res && $r = $res->fetch_assoc()) $checkouts = intval($r['total']);

    // Anúncios
    $anuncios = 0;
    if ($dominio) {
        $res = $mysqli->query("SELECT qnt_anuncios FROM dominios WHERE dominio = '$dominio'");
        if ($res && $r = $res->fetch_assoc()) $anuncios = intval($r['qnt_anuncios']);
    }

    // Inserir a nova oferta (checkouts_dominio fixo em 0)
    $checkouts_dominio = 0;
    $acompanhar = '';
    $stmt = $mysqli->prepare("INSERT INTO ofertas (referencia, nome, link, imagem_produto, anuncios, dolar, criado_em, checkouts, checkouts_dominio, email, acompanhar)
                              VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssississs", $referencia, $nome, $link, $imagem, $anuncios, $dolar, $criado_em, $checkouts, $checkouts_dominio, $email, $acompanhar);
    $stmt->execute();
    $stmt->close();

    // Marcar todos os produtos com essa referência como "oferta_criada = sim"
    $mysqli->query("UPDATE produtos SET oferta_criada = 'sim' WHERE referencia = '$referencia'");

    echo "<hr><strong>🆕 Oferta criada via referência:</strong> $referencia<br>";
    echo "<strong>📧 Email:</strong> $email<br>";
    echo "<strong>🔗 Link:</strong> $link<br>";
    echo "<strong>🌍 Domínio:</strong> $dominio<br>";
    echo "<strong>💲 Dólar:</strong> $dolar<br>";
    ob_flush();
    flush();
}

if ($criadas > 0) {
    $agora = date("Y-m-d H:i:s");
    $mensagemResumo = "$criadas novas ofertas encontradas!";
    $stmtHistFinal = $mysqli->prepare("INSERT INTO historico (id_oferta_referencia, evento, horario) VALUES (?, ?, ?)");
    $codigoResumo = 1; // valor simbólico
    $stmtHistFinal->bind_param("iss", $codigoResumo, $mensagemResumo, $agora);
    $stmtHistFinal->execute();
    $stmtHistFinal->close();
}
echo "<hr><h3>🏁 Finalizado. Total de ofertas criadas: $criadas</h3>";
?>
