<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Conexão com o banco
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
if ($mysqli->connect_error) {
    die("Erro ao conectar ao banco de dados: " . $mysqli->connect_error);
}

// Função para obter URL final após redirecionamento
function obterDestinoFinal($url) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => false, // não seguir redirecionamento automático
        CURLOPT_TIMEOUT => 8,
        CURLOPT_CONNECTTIMEOUT => 5,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)'
    ]);
    $html = curl_exec($ch);
    curl_close($ch);

    // 1. Tenta capturar redirecionamento via <meta http-equiv="refresh">
    if (preg_match('/<meta http-equiv=["\']refresh["\'] content=["\']\d+;\s*url=(.*?)["\']/', $html, $match)) {
        return trim(htmlspecialchars_decode($match[1]));
    }

    // 2. Tenta capturar redirecionamento via JavaScript
    if (preg_match('/window\.location\.href\s*=\s*[\'"](.*?)[\'"]/', $html, $match)) {
        return trim($match[1]);
    }

    // Se não detectar, retorna a mesma URL original
    return $url;
}


// Busca os 20 primeiros códigos
$result = $mysqli->query("SELECT id FROM produtos ORDER BY data ASC LIMIT 200");
$codigos = [];
while ($row = $result->fetch_assoc()) {
    $codigos[] = $row['id'];
}

$baseLink = "https://go.perfectpay.com.br/PPU38C";
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Verificação de Redirecionamento</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light p-4">
    <div class="container">
        <h1 class="mb-4">Resultado de Redirecionamento</h1>
        <div class="row">
            <?php foreach ($codigos as $codigo): ?>
                <?php
                    $url = $baseLink . $codigo;
                    $destino = obterDestinoFinal($url);
                    $redirecionado = ($destino !== $url);
                ?>
                <div class="col-md-6 mb-3">
                    <div class="card shadow-sm">
                        <div class="card-body">
                            <h5 class="card-title">Código: <?= htmlspecialchars($codigo) ?></h5>
                            <p class="card-text">Link original: <a href="<?= htmlspecialchars($url) ?>" target="_blank"><?= htmlspecialchars($url) ?></a></p>
                            <p class="card-text">Destino final: <strong><?= htmlspecialchars($destino) ?></strong></p>
                            <?php if ($redirecionado): ?>
                                <div class="alert alert-warning">Redirecionado para outro site!</div>
                            <?php else: ?>
                                <div class="alert alert-success">Permanece na PerfectPay.</div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</body>
</html>
