<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
if ($mysqli->connect_error) {
    http_response_code(500);
    exit("Erro ao conectar ao banco de dados.");
}

function obterHTMLViaCurl($url) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 5,
        CURLOPT_CONNECTTIMEOUT => 3,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)'
    ]);
    $output = curl_exec($ch);
    curl_close($ch);
    return $output ?: false;
}
function extrairNomeProduto($html) {
    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    $nodes = $xpath->query('//div[@id="you-are-buying"]//span');
    foreach ($nodes as $node) {
        $texto = trim($node->nodeValue);
        if ($texto !== '' && stripos($texto, 'VOCÊ ESTÁ ADQUIRINDO') === false) {
            return $texto;
        }
    }
    return false;
}
function decodificarCfEmail($cfemail) {
    $r = '';
    $k = hexdec(substr($cfemail, 0, 2));
    for ($i = 2; $i < strlen($cfemail); $i += 2) {
        $charCode = hexdec(substr($cfemail, $i, 2)) ^ $k;
        $r .= chr($charCode);
    }
    return $r;
}



function extrairImagemProduto($html) {
    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    $img = $xpath->query('//img[@id="product-image"]');
    return $img->length > 0 ? $img->item(0)->getAttribute('src') : false;
}

function extrairEmailSuporte($html) {
    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    
    $a = $xpath->query('//div[@id="support-email"]//a[contains(@class, "__cf_email__")]');

    if ($a->length > 0) {
        $cfemail = $a->item(0)->getAttribute('data-cfemail');
        return decodificarCfEmail($cfemail);
    }

    return null;
}




// --- Último código salvo ---
$res = $mysqli->query("SELECT codigo FROM ultimoacesso WHERE id = 1");
$codigoBase = ($res && $res->num_rows > 0) ? $res->fetch_assoc()['codigo'] : 'L0000';
$baseDecimal = base_convert($codigoBase, 36, 10);

// --- Offset e limit
$getOffset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;
$getLimit  = isset($_GET['limit']) ? intval($_GET['limit']) : 1;

$inicio = $baseDecimal + $getOffset;
$prefixo = "https://checkout.perfectpay.com.br/pay/PPU38C";
$ultimoCodigo = null;
$encontrouProduto = false;

for ($i = 0; $i < $getLimit; $i++) {
    $codigoDecimal = $inicio + $i;
    $sufixo = str_pad(strtoupper(base_convert($codigoDecimal, 10, 36)), 5, '0', STR_PAD_LEFT);
    $url = $prefixo . $sufixo;

    echo "<!-- Testando código: $sufixo -->";

    $html = obterHTMLViaCurl($url);
    if (!$html) {
        echo "<!-- Falha ao acessar $sufixo -->";
        flush();
        sleep(1);
        continue;
    }

    $nome = extrairNomeProduto($html);
    if (!$nome) {
        flush();
        sleep(1);
        continue;
    }

    $imagem = extrairImagemProduto($html) ?: 'https://via.placeholder.com/600x300?text=Sem+Imagem';
    $emailSuporte = extrairEmailSuporte($html) ?: 'N/A';
    $dataHoje = date('Y-m-d');

    // --- Salva no banco ---
    $stmt = $mysqli->prepare("
        INSERT INTO produtos (id, nome, link, imagem, data, email_suporte)
        VALUES (?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE
            nome = VALUES(nome),
            link = VALUES(link),
            imagem = VALUES(imagem),
            data = VALUES(data),
            email_suporte = VALUES(email_suporte)
    ");
    $stmt->bind_param("ssssss", $sufixo, $nome, $url, $imagem, $dataHoje, $emailSuporte);
    $stmt->execute();
    $stmt->close();

    echo '<div class="col-md-4 mb-4">';
    echo '<div class="card h-100 shadow">';
    echo '<img src="'.htmlspecialchars($imagem).'" class="card-img-top" alt="Imagem do produto">';
    echo '<div class="card-body">';
    echo '<h5 class="card-title">'.htmlspecialchars($nome).'</h5>';
    echo '<p class="card-text"><small class="text-muted">Link: <a href="'.htmlspecialchars($url).'" target="_blank">'.htmlspecialchars($url).'</a></small></p>';
    echo '<p class="card-text"><small class="text-muted">Suporte: '.htmlspecialchars($emailSuporte).'</small></p>';
    echo '<a href="'.htmlspecialchars($url).'" class="btn btn-primary" target="_blank">Acessar Checkout</a>';
    echo '</div></div></div>';

    $ultimoCodigo = $sufixo;
    $encontrouProduto = true;
    flush();
    sleep(1);
}

// --- Atualiza último acesso
if ($ultimoCodigo) {
    $stmt = $mysqli->prepare("UPDATE ultimoacesso SET codigo = ? WHERE id = 1");
    $stmt->bind_param("s", $ultimoCodigo);
    $stmt->execute();
    $stmt->close();
}

// --- Se nada encontrado
if (!$encontrouProduto) {
    echo "<!-- Nenhum produto encontrado neste offset -->";
}
