<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
if ($mysqli->connect_error) die("Erro na conexão: " . $mysqli->connect_error);

$totalAtualizadas = 0;
$totalIguais = 0;

$res = $mysqli->query("SELECT id, nome, link, checkouts, checkouts_dominio, anuncios, dolar FROM ofertas");

while ($oferta = $res->fetch_assoc()) {
    $id = intval($oferta['id']);
    $nome = $mysqli->real_escape_string($oferta['nome']);
    $link = $mysqli->real_escape_string($oferta['link']);
    $checkoutsAntigo = intval($oferta['checkouts']);
    $checkoutsDomAntigo = intval($oferta['checkouts_dominio']);
    $anunciosAntigo = intval($oferta['anuncios']);
    $dolarAntigo = $oferta['dolar'];

    // Checkouts com base no nome
    $checkoutsNovo = 0;
    $res2 = $mysqli->query("SELECT COUNT(*) AS total FROM produtos WHERE nome = '$nome'");
    if ($res2 && $r = $res2->fetch_assoc()) $checkoutsNovo = intval($r['total']);

    // Extrair domínio
    preg_match('/https?:\/\/([^\/]+)/', $link, $matches);
    $dominio = isset($matches[1]) ? $mysqli->real_escape_string($matches[1]) : '';

    // Anúncios
    $anunciosNovo = 0;
    if ($dominio) {
        $res2 = $mysqli->query("SELECT qnt_anuncios FROM dominios WHERE dominio = '$dominio'");
        if ($res2 && $r = $res2->fetch_assoc()) $anunciosNovo = intval($r['qnt_anuncios']);
    }

    // Checkouts do domínio
    $checkoutsDomNovo = 0;
    if (!str_starts_with($link, 'https://checkout')) {
        if ($dominio) {
            $res2 = $mysqli->query("SELECT COUNT(*) AS total FROM produtos WHERE link LIKE '%$dominio%' AND nome = '$nome'");
            if ($res2 && $r = $res2->fetch_assoc()) $checkoutsDomNovo = intval($r['total']);
        }
    } else {
        $checkoutsDomNovo = $checkoutsDomAntigo;
    }

    // Dólar com base no nome
    $dolarNovo = 'nao';
    $res2 = $mysqli->query("SELECT 1 FROM produtos WHERE nome = '$nome' AND internacional = 'sim' LIMIT 1");
    if ($res2 && $res2->num_rows > 0) $dolarNovo = 'sim';

    // Verificar alterações
    $alteracoes = [];
    if ($checkoutsAntigo !== $checkoutsNovo) {
        $alteracoes[] = "Produto '$nome': $checkoutsAntigo checkouts e agora tem $checkoutsNovo";
    }
    if ($checkoutsDomAntigo !== $checkoutsDomNovo) {
        $alteracoes[] = "$dominio tinha $checkoutsDomAntigo checkouts e agora tem $checkoutsDomNovo";
    }
    if ($anunciosAntigo !== $anunciosNovo) {
        $alteracoes[] = "$dominio tinha $anunciosAntigo anúncios e agora tem $anunciosNovo";
    }
    if ($dolarAntigo !== $dolarNovo) {
        $alteracoes[] = "Dólar: $dolarAntigo → $dolarNovo";
    }

    // Sempre marcar produtos como oferta criada
    $mysqli->query("UPDATE produtos SET oferta_criada = 'sim' WHERE nome = '$nome'");

    if (!empty($alteracoes)) {
        $agora = date("Y-m-d H:i:s");

        $stmt = $mysqli->prepare("UPDATE ofertas SET checkouts = ?, checkouts_dominio = ?, anuncios = ?, dolar = ?, atualizada_em = ? WHERE id = ?");
        $stmt->bind_param("iiissi", $checkoutsNovo, $checkoutsDomNovo, $anunciosNovo, $dolarNovo, $agora, $id);
        $stmt->execute();
        $stmt->close();

        foreach ($alteracoes as $evento) {
            $stmtHist = $mysqli->prepare("INSERT INTO historico (id_oferta_referencia, evento, horario) VALUES (?, ?, ?)");
            $stmtHist->bind_param("iss", $id, $evento, $agora);
            $stmtHist->execute();
            $stmtHist->close();
        }

        echo "<strong>✅ Oferta ID $id atualizada</strong><br>";
        foreach ($alteracoes as $a) {
            echo "$a<br>";
        }
        echo "<hr>";
        $totalAtualizadas++;
    } else {
        $totalIguais++;
    }

    ob_flush();
    flush();
}

echo "<hr><strong>🏁 Atualização finalizada.</strong><br>";
echo "🔄 Ofertas atualizadas: $totalAtualizadas<br>";
echo "✅ Sem alterações necessárias: $totalIguais<br>";

if ($totalAtualizadas > 0) {
    $agora = date("Y-m-d H:i:s");
    $mensagemResumo = "$totalAtualizadas ofertas atualizadas.";
    $stmtHistFinal = $mysqli->prepare("INSERT INTO historico (id_oferta_referencia, evento, horario) VALUES (?, ?, ?)");
    $codigoResumo = 1;
    $stmtHistFinal->bind_param("iss", $codigoResumo, $mensagemResumo, $agora);
    $stmtHistFinal->execute();
    $stmtHistFinal->close();
}
?>
