<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');

/* ================= CONFIG DBs ================= */
$DB_HOST = 'localhost';
$DB_USER = 'mari7851_admin';
$DB_PASS = 'zVq1$rBmIRbEo$K6';
$DB_MAIN_NAME = 'mari7851_banco';
$DB_TEST_NAME = 'wwmari_db_teste';
$TABLE_LOG = 'monitoramento_imagens';
$TABLE_NOTIF = 'notificacao_imagens';

/* ======== API (RapidAPI - whatsapp-profile-pic) ======== */
$API_KEY_RAPID = "0218e0716bmsh409331ab320a927p1dbf42jsn3a7a348cea06";
$API_HOST      = "whatsapp-profile-pic.p.rapidapi.com";
$API_ENDPOINT  = "https://whatsapp-profile-pic.p.rapidapi.com/wspic/url?phone=";

/* ======== META ======== */
$THIS_FILE = basename(__FILE__);
$ALLOC_JSON_PATH = '/api/carga_api_imagens.json';

/* ======== RATE LIMIT / DELAYS ======== */
$INTER_ATTEMPT_DELAY_MS = 1200; // pausa entre variações (ex.: com 9 -> sem 9)
$RATE_LIMIT_DELAY_MS    = 1600; // pausa quando API retorna 429
function sleep_ms(int $ms) { if ($ms > 0) usleep($ms * 1000); }
function jitter_ms(int $base, int $jitter=200) { return max(0, $base + random_int(-$jitter, $jitter)); }

/* =============== FUNÇÕES DB/LOG =============== */
function pdoMake($dbName) {
    global $DB_HOST, $DB_USER, $DB_PASS;
    return new PDO(
        "mysql:host={$DB_HOST};dbname={$dbName};charset=utf8mb4",
        $DB_USER,
        $DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
}
function logMonitoramentoDual($apiNome, $status, $numero, $temImagem, $iniciouEm, $latenciaSeg, $erroMsg = null) {
    global $DB_MAIN_NAME, $DB_TEST_NAME, $TABLE_LOG;
    $sql = "INSERT INTO {$TABLE_LOG}
            (api_nome, status, numero_consulta, erro_msg, tem_imagem, iniciou_em, latencia_seg)
            VALUES (:api, :st, :num, :err, :img, :ini, :lat)";
    $params = [
        ':api' => $apiNome, ':st' => $status, ':num' => $numero, ':err' => $erroMsg,
        ':img' => (int)$temImagem, ':ini' => $iniciouEm, ':lat' => (int)$latenciaSeg
    ];
    try { pdoMake($DB_MAIN_NAME)->prepare($sql)->execute($params); } catch (Throwable $e) { error_log("log main: ".$e->getMessage()); }
    try { pdoMake($DB_TEST_NAME)->prepare($sql)->execute($params); } catch (Throwable $e) { error_log("log test: ".$e->getMessage()); }
}
function logNotificacaoDual($apiNome, $mensagem, $horario, $tempoSeg, $temImagem) {
    global $DB_MAIN_NAME, $DB_TEST_NAME, $TABLE_NOTIF;
    $sql = "INSERT INTO {$TABLE_NOTIF} (api_nome, mensagem, horario, tempo, tem_imagem)
            VALUES (:api, :msg, :hor, :tmp, :img)";
    $params = [
        ':api' => $apiNome, ':msg' => $mensagem, ':hor' => $horario,
        ':tmp' => (int)$tempoSeg, ':img' => (int)$temImagem
    ];
    try { pdoMake($DB_MAIN_NAME)->prepare($sql)->execute($params); } catch (Throwable $e) { error_log("notif main: ".$e->getMessage()); }
    try { pdoMake($DB_TEST_NAME)->prepare($sql)->execute($params); } catch (Throwable $e) { error_log("notif test: ".$e->getMessage()); }
}

/* =============== UTIL =============== */
function protoHost() {
    $proto = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    return "$proto://$host";
}
function gerarURL($arquivo) { return protoHost() . "/app/imagens/$arquivo"; }
function salvarMiniaturaBytes($bytes, $nomeArquivo) {
    $img = @imagecreatefromstring($bytes);
    if (!$img) return false;
    $mini = imagecreatetruecolor(90, 90);
    $srcW = imagesx($img); $srcH = imagesy($img);
    $scale = min(90 / $srcW, 90 / $srcH);
    $nw = (int)round($srcW * $scale); $nh = (int)round($srcH * $scale);
    $dx = (int)floor((90 - $nw) / 2); $dy = (int)floor((90 - $nh) / 2);
    imagefilledrectangle($mini, 0, 0, 90, 90, imagecolorallocate($mini, 255, 255, 255));
    imagecopyresampled($mini, $img, $dx, $dy, 0, 0, $nw, $nh, $srcW, $srcH);
    $dir = $_SERVER['DOCUMENT_ROOT'] . '/app/imagens/';
    if (!is_dir($dir)) mkdir($dir, 0755, true);
    $path = $dir . $nomeArquivo;
    $ext = strtolower(pathinfo($nomeArquivo, PATHINFO_EXTENSION));
    $ok = false;
    if ($ext === 'png')      { $ok = imagepng($mini, $path, 6); }
    elseif ($ext === 'webp') { $ok = function_exists('imagewebp') ? imagewebp($mini, $path, 80) : imagejpeg($mini, $path, 90); }
    else                     { $ok = imagejpeg($mini, $path, 90); }
    imagedestroy($img); imagedestroy($mini);
    return $ok ? gerarURL($nomeArquivo) : false;
}
/** Normaliza + gera variações com 55, com/sem 9 */
function gerarVariacoesComDDI($numero) {
    $num = preg_replace('/\D/', '', $numero);
    if (substr($num, 0, 2) === '55') $num = substr($num, 2);
    if (!preg_match('/^(\d{2})(\d{8,9})$/', $num, $m)) return [];
    $ddd = $m[1]; $resto = $m[2];
    $com9 = preg_match('/^9\d{8}$/', $resto) ? $ddd.$resto : $ddd.'9'.$resto;
    $sem9 = preg_match('/^9\d{8}$/', $resto) ? $ddd.substr($resto,1) : $ddd.$resto;
    return ['55'.$com9, '55'.$sem9];
}

/* =============== CHAMADAS À NOVA API =============== */
function apiObterUrlDaFoto($numero, $apiKey, $apiHost, $endpointBase) {
    $url = $endpointBase . urlencode($numero);
    $ch  = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 20,
        CURLOPT_HEADER => false,
        CURLOPT_HTTPHEADER => [
            "x-rapidapi-host: {$apiHost}",
            "x-rapidapi-key: {$apiKey}",
        ],
        CURLOPT_USERAGENT => 'Mozilla/5.0 (compatible; WhatsProfileFetcher/1.0)',
        CURLOPT_IPRESOLVE => CURL_IPRESOLVE_V4,
    ]);
    $resp = curl_exec($ch);
    $err  = curl_error($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($err)          return ['ok'=>false, 'status'=>'error',      'http'=>$http, 'err'=>"cURL: $err"];
    if ($http === 429) return ['ok'=>false, 'status'=>'rate_limit', 'http'=>$http, 'err'=>'rate limit'];
    if ($http >= 400)  return ['ok'=>false, 'status'=>'error',      'http'=>$http, 'err'=>"HTTP $http"];

    $respStr = trim((string)$resp);
    if (preg_match('~https?://[^\s"\'<>]+~i', $respStr, $m)) {
        return ['ok'=>true, 'status'=>'success', 'foto_url'=>$m[0]];
    }
    return ['ok'=>false, 'status'=>'not_found', 'http'=>$http, 'err'=>'no url found'];
}
function baixarBytesImagem($url) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_MAXREDIRS => 5,
        CURLOPT_HEADER => true,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (compatible; WhatsProfileFetcher/1.0)',
        CURLOPT_IPRESOLVE => CURL_IPRESOLVE_V4,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_SSL_VERIFYHOST => 2,
    ]);
    $resp = curl_exec($ch);
    $err  = curl_error($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $hsz  = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $ctype= curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
    $body = substr($resp, $hsz);
    curl_close($ch);

    if ($err) return ['ok'=>false, 'err'=>"cURL: $err"];
    if ($http !== 200) return ['ok'=>false, 'err'=>"HTTP $http"];
    if (!$ctype || stripos($ctype, 'image/') !== 0 || strlen($body) === 0) {
        return ['ok'=>false, 'err'=>'conteudo nao-imagem ou vazio'];
    }
    $ext = 'jpg';
    if (stripos($ctype, 'png') !== false) $ext = 'png';
    if (stripos($ctype, 'webp') !== false) $ext = 'webp';
    if (strlen($body) > 5*1024*1024) return ['ok'=>false, 'err'=>'imagem muito grande (>5MB)'];
    return ['ok'=>true, 'bytes'=>$body, 'content_type'=>$ctype, 'ext'=>$ext];
}

/* =============== BALANCEADOR (mesmo que antes) =============== */
function escolherProximoArquivo($allocPath, $arquivoAtual) {
    $abspath = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . $allocPath;
    if (!is_file($abspath)) return null;
    $raw = @file_get_contents($abspath);
    if ($raw === false) return null;
    $j = json_decode($raw, true);
    if (!is_array($j) || !isset($j['alloc']) || !is_array($j['alloc'])) return null;

    $fallbackAtivos = ['whatsappprofilepic.php'];

    $cands = [];
    foreach ($j['alloc'] as $row) {
        $api   = $row['api']   ?? null;
        $carga = (float)($row['carga'] ?? 0);
        $kill  = (bool)($row['hard_kill'] ?? false);
        if (!is_string($api) || !preg_match('/^[a-z0-9._-]+\.php$/i', $api)) continue;
        if (strcasecmp($api, $arquivoAtual) === 0) continue;
        if (in_array($api, $fallbackAtivos, true)) continue;
        if ($kill || $carga <= 0) continue;
        $absApp = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . '/app/' . $api;
        if (!is_file($absApp)) continue;
        $cands[] = ['api'=>$api, 'carga'=>$carga];
    }
    if (empty($cands)) return null;
    usort($cands, function($a,$b){ if ($a['carga'] == $b['carga']) return 0; return ($a['carga'] > $b['carga']) ? -1 : 1; });
    return $cands[0]['api'];
}
function chamarApiInternaApp($arquivoPhp, $numero) {
    $url = protoHost() . '/app/' . $arquivoPhp;
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query(['numero' => $numero]),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 20,
        CURLOPT_HEADER => false,
    ]);
    $resp = curl_exec($ch);
    $err  = curl_error($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($err || $http < 200 || $http >= 300 || !$resp) {
        return ['ok'=>false, 'err'=>$err ? "cURL: $err" : "HTTP $http / resposta vazia"];
    }
    $j = json_decode($resp, true);
    if (!is_array($j)) return ['ok'=>false, 'err'=>'JSON inválido da API interna'];
    return ['ok'=>true, 'json'=>$j];
}

/* =============== FLUXO PRINCIPAL =============== */
$inicio_micro = microtime(true);
$iniciou_em   = date('Y-m-d H:i:s');

$numeroOriginal = isset($_POST['numero']) ? preg_replace('/\D/', '', $_POST['numero']) : null;
if (empty($numeroOriginal)) {
    $lat = max(0, (int) round(microtime(true) - $inicio_micro));
    logMonitoramentoDual($THIS_FILE, 'error', 'faltou_numero', 0, $iniciou_em, $lat, 'Nenhum número no POST');
    logNotificacaoDual($THIS_FILE, 'Consulta abortada: nenhum número informado no POST.', $iniciou_em, $lat, 0);
    echo json_encode(['url'=>gerarURL('perfilsemfoto.jpg'), 'nome'=>'', 'mensagem'=>'', 'evento_plausible'=>'naotemimagem'], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
    exit;
}

$apiNome  = $THIS_FILE;
$nome     = '';
$mensagem = '';

$variacoes = gerarVariacoesComDDI($numeroOriginal);
$imagemEncontrada = false;
$erroMsg = null;
$erroMsgAggregated = null;
$statusFinal = 'not_found';
$urlFinal = null;
$urlImagemApi = null;
$tentadas = [];              // <- variações exatamente como enviadas
$varEncontrada = null;       // <- guarda qual variação teve sucesso

foreach ($variacoes as $idx => $num) {
    $tentadas[] = $num; // registra a tentativa exata
    $rateLimited = false;

    // 1) Obter URL via API
    $r1 = apiObterUrlDaFoto($num, $API_KEY_RAPID, $API_HOST, $API_ENDPOINT);
    if (!$r1['ok']) {
        if (($r1['status'] ?? '') === 'rate_limit') {
            $statusFinal = 'error';
            $erroMsg = 'rate limit';
            $rateLimited = true;
        } else {
            $statusFinal = ($r1['status'] === 'not_found' && $statusFinal !== 'error') ? 'not_found' : 'error';
            $erroMsg = $r1['err'] ?? 'erro desconhecido na obtenção da URL';
        }
        if ($idx < count($variacoes)-1) {
            if ($rateLimited) sleep_ms(jitter_ms($RATE_LIMIT_DELAY_MS));
            else              sleep_ms(jitter_ms($INTER_ATTEMPT_DELAY_MS));
        }
        continue;
    }

    $urlImagemApi = $r1['foto_url'] ?? null;
    if (!$urlImagemApi) {
        $statusFinal = 'not_found';
        $erroMsg = 'API não retornou URL válida';
        if ($idx < count($variacoes)-1) sleep_ms(jitter_ms($INTER_ATTEMPT_DELAY_MS));
        continue;
    }

    // 2) Baixar bytes e salvar miniatura
    $r2 = baixarBytesImagem($urlImagemApi);
    if (!$r2['ok']) {
        $statusFinal = 'error';
        $erroMsg = $r2['err'] ?? 'falha ao baixar imagem';
        if ($idx < count($variacoes)-1) sleep_ms(jitter_ms($INTER_ATTEMPT_DELAY_MS));
        continue;
    }

    $ext = $r2['ext'] ?? 'jpg';
    $nomeArquivo = 'img_' . $num . '.' . $ext; // salva com a variação exata
    $urlFinal = salvarMiniaturaBytes($r2['bytes'], $nomeArquivo);

    if ($urlFinal) {
        $imagemEncontrada = true;
        $statusFinal = 'success';
        $varEncontrada = $num; // <- guarda qual variação deu certo
        break;
    } else {
        $erroMsg = 'falha ao salvar miniatura';
        $statusFinal = 'error';
        if ($idx < count($variacoes)-1) sleep_ms(jitter_ms($INTER_ATTEMPT_DELAY_MS));
    }
}

/* ======== Saída e Log ======== */
$latTotal = max(0, (int) round(microtime(true) - $inicio_micro));
$tentadasStr = implode(', ', $tentadas);

if ($imagemEncontrada) {
    setcookie('temimagem', 'sim', time()+86400*30, "/");

    logMonitoramentoDual($apiNome, 'success', $numeroOriginal, 1, $iniciou_em, $latTotal, null);

    // mensagem inclui variações e qual encontrou
    $mensagemNotif = "Imagem encontrada para o número {$numeroOriginal}. ".
                     "Variações tentadas: {$tentadasStr}. ".
                     "Encontrada com: {$varEncontrada}.";
    logNotificacaoDual($apiNome, $mensagemNotif, $iniciou_em, $latTotal, 1);

    echo json_encode(['url'=>$urlFinal, 'nome'=>$nome, 'mensagem'=>$mensagem, 'evento_plausible'=>'temimagem'], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
    exit;
}

/* ======== FAILOVER (opcional) ======== */
$proximo = escolherProximoArquivo($ALLOC_JSON_PATH, $THIS_FILE);
if ($proximo) {
    $ret = chamarApiInternaApp($proximo, $numeroOriginal);

    if ($ret['ok']) {
        $j = $ret['json'];
        if (!empty($j['url']) && isset($j['evento_plausible']) && $j['evento_plausible'] === 'temimagem') {
            if (!headers_sent()) setcookie('temimagem', 'sim', time()+86400*30, "/");
            $latAlt = max(0, (int) round(microtime(true) - $inicio_micro));
            $errCombined = "[Encontrado API {$proximo}] * Erro na API atual: " . ($erroMsg ?: 'não informado') .
                           " | Variações tentadas: {$tentadasStr}";
            logMonitoramentoDual($apiNome, 'success', $numeroOriginal, 1, $iniciou_em, $latAlt, $errCombined);

            $apiNomeNotif = "CHECK - {$proximo}";
            $mensagemNotif = "Imagem encontrada para o número {$numeroOriginal} via {$proximo}. ".
                             "Variações tentadas nesta API: {$tentadasStr}.";
            logNotificacaoDual($apiNomeNotif, $mensagemNotif, $iniciou_em, $latAlt, 1);

            echo json_encode($j, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
            exit;
        } else {
            $latAlt = max(0, (int) round(microtime(true) - $inicio_micro));
            $apiNomeNotif = "CHECK - {$proximo}";
            $mensagemNotif = "Sem imagem para {$numeroOriginal} via {$proximo}. ".
                             "Variações tentadas nesta API: {$tentadasStr}.";
            logNotificacaoDual($apiNomeNotif, $mensagemNotif, $iniciou_em, $latAlt, 0);
            $erroMsgAggregated = "[Sem imagem via {$proximo}] * Erro na API atual: " . ($erroMsg ?: 'não informado') .
                                 " | Variações tentadas: {$tentadasStr}";
        }
    } else {
        $latAlt = max(0, (int) round(microtime(true) - $inicio_micro));
        $apiNomeNotif = "CHECK - {$proximo}";
        $mensagemNotif = "Erro ao consultar alternativa para {$numeroOriginal}: ".($ret['err'] ?? 'erro desconhecido').". ".
                         "Variações tentadas nesta API: {$tentadasStr}.";
        logNotificacaoDual($apiNomeNotif, $mensagemNotif, $iniciou_em, $latAlt, 0);
        $erroMsgAggregated = "[Erro via {$proximo}: ".($ret['err'] ?? 'desconhecido')."] * Erro na API atual: " .
                             ($erroMsg ?: 'não informado')." | Variações tentadas: {$tentadasStr}";
    }
}

/* ======== Fallback final (sem imagem) ======== */
setcookie('temimagem', 'nao', time()+86400*30, "/");
$urlPadrao = gerarURL('perfilsemfoto.jpg');

$msgNotif = ($statusFinal === 'error')
    ? "Erro para o número {$numeroOriginal}: ".($erroMsg ?: 'erro desconhecido').". Variações tentadas: {$tentadasStr}."
    : "Sem imagem de perfil para o número {$numeroOriginal}. Variações tentadas: {$tentadasStr}.";

if (!$imagemEncontrada && $urlImagemApi) {
    $msgNotif .= " URL sugerida: {$urlImagemApi}";
}

$erroParaLogTecnico = ($erroMsgAggregated ?: $erroMsg);
if ($erroParaLogTecnico) {
    // anexa as variações ao erro técnico também
    $erroParaLogTecnico .= " | Tentadas: {$tentadasStr}";
}

logMonitoramentoDual($apiNome, $statusFinal, $numeroOriginal, 0, $iniciou_em, $latTotal, $erroParaLogTecnico);
logNotificacaoDual($apiNome, $msgNotif, $iniciou_em, $latTotal, 0);

echo json_encode(['url'=>$urlPadrao, 'nome'=>'', 'mensagem'=>'', 'evento_plausible'=>'naotemimagem'], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
