<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');

/* =============== DB + LOG =============== */
function pdoConn(): PDO {
    $dsn  = "mysql:host=localhost;dbname=mari7851_banco;charset=utf8mb4";
    $user = "mari7851_admin";
    $pass = "zVq1$rBmIRbEo$K6";
    return new PDO($dsn, $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
}



$API_FILE_NAME = 'whatsapp-data1.php'; // nome padrão desta API para logs

function logMonitoramento(string $apiNome, string $status, string $numeroConsulta, int $temImagem, string $iniciouEm, int $latenciaSeg, ?string $erroMsg=null): void {
    try {
        $sql = "INSERT INTO monitoramento_imagens
                (api_nome, status, numero_consulta, erro_msg, tem_imagem, iniciou_em, latencia_seg)
                VALUES (:api, :status, :num, :erro, :img, :ini, :lat)";
        pdoConn()->prepare($sql)->execute([
            ':api'   => $apiNome,
            ':status'=> $status,              // 'success' | 'not_found' | 'error'
            ':num'   => $numeroConsulta,
            ':erro'  => $erroMsg,
            ':img'   => $temImagem,           // 0/1
            ':ini'   => $iniciouEm,           // 'Y-m-d H:i:s'
            ':lat'   => $latenciaSeg          // segundos (int)
        ]);
    } catch (Throwable $e) {
        error_log("Falha ao logar monitoramento_imagens: ".$e->getMessage());
    }
}

/** notificacao_imagens: api_nome | mensagem | horario | tempo | tem_imagem */
function logNotificacao(string $apiNome, string $mensagem, string $horario, int $tempoSeg, int $temImagem): void {
    try {
        $sql = "INSERT INTO notificacao_imagens (api_nome, mensagem, horario, tempo, tem_imagem)
                VALUES (:api, :msg, :hor, :tmp, :img)";
        pdoConn()->prepare($sql)->execute([
            ':api' => $apiNome,
            ':msg' => $mensagem,
            ':hor' => $horario,
            ':tmp' => $tempoSeg,
            ':img' => $temImagem
        ]);
    } catch (Throwable $e) {
        error_log("Falha ao logar notificacao_imagens: ".$e->getMessage());
    }
}

/* ======== (Opcional) Telegram debug ======== */
function sendToTelegram($message) {
    if (rand(1, 100) > 100) return; // desativado
    $bot_token = "7574620663:AAHVrt1wimE5ZlbAoCZnq8L9myIm0CK3Wus";
    $chat_id   = "-1002456760125";
    $url = "https://api.telegram.org/bot$bot_token/sendMessage";
    $data = ['chat_id'=>$chat_id, 'text'=>$message, 'parse_mode'=>'HTML'];
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
    ]);
    curl_exec($ch);
    curl_close($ch);
}

/* ======== Utils ======== */
function gerarURL($arquivo) {
    $protocolo = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    return "$protocolo://$host/app/imagens/$arquivo";
}

function baixarImagemSegura($url) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_USERAGENT => 'Mozilla/5.0',
        CURLOPT_TIMEOUT => 12,
    ]);
    $data = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ($httpCode === 200 && $data) ? $data : false;
}

function consultarAPI($numero, $chaveApi) {
    $url = "https://whatsapp-data1.p.rapidapi.com/number/$numero?base64=false&telegram=false&google=false";
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 20,
        CURLOPT_HTTPHEADER => [
            "x-rapidapi-host: whatsapp-data1.p.rapidapi.com",
            "x-rapidapi-key: $chaveApi"
        ],
    ]);
    $resposta = curl_exec($ch);
    $erro = curl_error($ch);
    curl_close($ch);
    return $erro ? null : json_decode($resposta, true);
}

function salvarMiniatura($urlImagem, $nomeArquivo) {
    $conteudo = baixarImagemSegura($urlImagem);
    if (!$conteudo) return false;
    $img = @imagecreatefromstring($conteudo);
    if (!$img) return false;

    $mini = imagecreatetruecolor(90, 90);
    imagecopyresampled($mini, $img, 0, 0, 0, 0, 90, 90, imagesx($img), imagesy($img));

    $dir = $_SERVER['DOCUMENT_ROOT'] . '/app/imagens/';
    if (!is_dir($dir)) mkdir($dir, 0755, true);
    $path = $dir . $nomeArquivo;

    // salva como jpg por padrão (mais robusto)
    imagejpeg($mini, $path, 90);
    imagedestroy($img);
    imagedestroy($mini);

    return gerarURL($nomeArquivo);
}

/* ======== MEDIÇÃO DO TEMPO TOTAL ======== */
$inicio_micro = microtime(true);
