<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');

/* ================= CONFIG DBs ================= */
$DB_HOST = 'localhost';
$DB_USER = 'mari7851_admin';
$DB_PASS = 'zVq1$rBmIRbEo$K6';
$DB_MAIN_NAME = 'mari7851_banco';
$DB_TEST_NAME = 'wwmari_db_teste'; // banco de teste
$TABLE_LOG = 'monitoramento_imagens';
$TABLE_NOTIF = 'notificacao_imagens';

/* ======== META ======== */
$THIS_FILE = basename(__FILE__); // nome do script para logs

/* =============== FUNÇÕES DB/LOG =============== */
function pdoMake($dbName) {
    global $DB_HOST, $DB_USER, $DB_PASS;
    return new PDO(
        "mysql:host={$DB_HOST};dbname={$dbName};charset=utf8mb4",
        $DB_USER,
        $DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
}

/** monitoramento_imagens */
function logMonitoramentoDual($apiNome, $status, $numero, $temImagem, $iniciouEm, $latenciaSeg, $erroMsg = null) {
    global $DB_MAIN_NAME, $DB_TEST_NAME, $TABLE_LOG;
    $sql = "INSERT INTO {$TABLE_LOG}
            (api_nome, status, numero_consulta, erro_msg, tem_imagem, iniciou_em, latencia_seg)
            VALUES (:api, :st, :num, :err, :img, :ini, :lat)";
    $params = [
        ':api' => $apiNome,
        ':st'  => $status,
        ':num' => $numero,
        ':err' => $erroMsg,
        ':img' => (int)$temImagem,
        ':ini' => $iniciouEm,
        ':lat' => (int)$latenciaSeg
    ];
    try { pdoMake($DB_MAIN_NAME)->prepare($sql)->execute($params); } catch (Throwable $e) { error_log("log main: ".$e->getMessage()); }
    try { pdoMake($DB_TEST_NAME)->prepare($sql)->execute($params); } catch (Throwable $e) { error_log("log test: ".$e->getMessage()); }
}

/** notificacao_imagens */
function logNotificacaoDual($apiNome, $mensagem, $horario, $tempoSeg, $temImagem) {
    global $DB_MAIN_NAME, $DB_TEST_NAME, $TABLE_NOTIF;

    $sql = "INSERT INTO {$TABLE_NOTIF} (api_nome, mensagem, horario, tempo, tem_imagem)
            VALUES (:api, :msg, :hor, :tmp, :img)";
    $params = [
        ':api' => $apiNome,
        ':msg' => $mensagem,
        ':hor' => $horario,
        ':tmp' => (int)$tempoSeg,
        ':img' => (int)$temImagem
    ];

    try { pdoMake($DB_MAIN_NAME)->prepare($sql)->execute($params); } catch (Throwable $e) { error_log("notif main: ".$e->getMessage()); }
    try { pdoMake($DB_TEST_NAME)->prepare($sql)->execute($params); } catch (Throwable $e) { error_log("notif test: ".$e->getMessage()); }
}

/* =============== UTIL =============== */
function protoHost() {
    $proto = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    return "$proto://$host";
}
function baseUrl() { return protoHost(); }

function gerarURL($arquivo) {
    return protoHost() . "/app/imagens/$arquivo";
}

function salvarMiniaturaBytes($bytes, $nomeArquivo) {
    $img = @imagecreatefromstring($bytes);
    if (!$img) return false;

    $mini = imagecreatetruecolor(90, 90);
    $srcW = imagesx($img);
    $srcH = imagesy($img);
    $scale = min(90 / $srcW, 90 / $srcH);
    $nw = (int)round($srcW * $scale);
    $nh = (int)round($srcH * $scale);
    $dx = (int)floor((90 - $nw) / 2);
    $dy = (int)floor((90 - $nh) / 2);
    imagefilledrectangle($mini, 0, 0, 90, 90, imagecolorallocate($mini, 255, 255, 255));
    imagecopyresampled($mini, $img, $dx, $dy, 0, 0, $nw, $nh, $srcW, $srcH);

    $dir = $_SERVER['DOCUMENT_ROOT'] . '/app/imagens/';
    if (!is_dir($dir)) mkdir($dir, 0755, true);
    $path = $dir . $nomeArquivo;

    $ext = strtolower(pathinfo($nomeArquivo, PATHINFO_EXTENSION));
    $ok = false;
    if ($ext === 'png')      { $ok = imagepng($mini, $path, 6); }
    elseif ($ext === 'webp') { $ok = function_exists('imagewebp') ? imagewebp($mini, $path, 80) : imagejpeg($mini, $path, 90); }
    else                     { $ok = imagejpeg($mini, $path, 90); }

    imagedestroy($img);
    imagedestroy($mini);

    return $ok ? gerarURL($nomeArquivo) : false;
}

/** Normaliza + gera variações com 55, com/sem 9 */
function gerarVariacoesComDDI($numero) {
    $num = preg_replace('/\D/', '', $numero);
    if (substr($num, 0, 2) === '55') $num = substr($num, 2);
    if (!preg_match('/^(\d{2})(\d{8,9})$/', $num, $m)) return [];
    $ddd = $m[1];
    $resto = $m[2];
    $com9 = preg_match('/^9\d{8}$/', $resto) ? $ddd.$resto : $ddd.'9'.$resto;
    $sem9 = preg_match('/^9\d{8}$/', $resto) ? $ddd.substr($resto,1) : $ddd.$resto;
    return ['55'.$com9, '55'.$sem9];
}

/* =============== CHAMADA WASPABLE =============== */
function consultarWaspableImagem($numero, $apiKey) {
    $url = "https://waspable1.p.rapidapi.com/users/profile-picture/{$numero}";
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 25,               // timeout maior
        CURLOPT_HEADER => true,
        CURLOPT_HTTPHEADER => [
            "x-rapidapi-host: waspable1.p.rapidapi.com",
            "x-rapidapi-key: {$apiKey}"
        ],
        CURLOPT_USERAGENT => 'Mozilla/5.0 (compatible; WaspableFetcher/1.0)',
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_MAXREDIRS => 5,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_SSL_VERIFYHOST => 2,
    ]);
    $resp = curl_exec($ch);
    $err  = curl_error($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $hsz  = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $hdrs = substr($resp, 0, $hsz);
    $body = substr($resp, $hsz);
    curl_close($ch);

    if ($err) {
        return ['ok'=>false, 'status'=>'error', 'http'=>$http, 'err'=>"cURL: $err"];
    }

    // Content-Type
    $ctype = null;
    foreach (explode("\r\n", $hdrs) as $h) {
        if (stripos($h, 'Content-Type:') === 0) {
            $ctype = trim(substr($h, strlen('Content-Type:')));
            break;
        }
    }

    // Se imagem
    if ($http === 200 && $ctype && stripos($ctype, 'image/') === 0 && strlen($body) > 0) {
        $ext = 'jpg';
        if (stripos($ctype, 'png') !== false) $ext = 'png';
        if (stripos($ctype, 'webp') !== false) $ext = 'webp';
        if (strlen($body) > 5*1024*1024) return ['ok'=>false, 'status'=>'error', 'http'=>$http, 'err'=>'imagem muito grande (>5MB)'];
        return ['ok'=>true, 'status'=>'success', 'bytes'=>$body, 'content_type'=>$ctype, 'ext'=>$ext];
    }

    // Se JSON/erro
    $msg = "HTTP $http; ctype=".($ctype ?: 'desconhecido')."; body=".strlen($body);
    if ($ctype && stripos($ctype, 'application/json') !== false && $body !== '') {
        $j = json_decode($body, true);
        if (is_array($j)) {
            $cand = $j['message'] ?? $j['error'] ?? $j['detail'] ?? $j['status'] ?? null;
            if ($cand) $msg = is_string($cand) ? $cand : json_encode($cand);
            $low = is_string($cand) ? strtolower($cand) : '';
            if ($http === 404 || str_contains($low, 'not found') || ($j['found'] ?? null) === false) {
                return ['ok'=>false, 'status'=>'not_found', 'http'=>$http, 'err'=>$msg];
            }
            if ($http === 429 || str_contains($low, 'rate limit')) {
                return ['ok'=>false, 'status'=>'error', 'http'=>$http, 'err'=>'rate limit'];
            }
            return ['ok'=>false, 'status'=>'error', 'http'=>$http, 'err'=>$msg];
        }
    }

    if ($http === 404) {
        return ['ok'=>false, 'status'=>'not_found', 'http'=>$http, 'err'=>'not found'];
    }
    return ['ok'=>false, 'status'=>'error', 'http'=>$http, 'err'=>$msg];
}

/* =============== DISPARO SECUNDÁRIO (GET + aguarda até 7s) =============== */
function dispararPesquisaSecundaria($numero) {
    if (!$numero) return;
    $url = baseUrl() . '/app/whatsapp-data1.php?numero=' . urlencode($numero);
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_HTTPGET => true,
        CURLOPT_RETURNTRANSFER => true,  // ainda que não usemos, isso faz o cURL aguardar o corpo
        CURLOPT_HEADER => false,
        CURLOPT_CONNECTTIMEOUT => 2,     // até 2s para conectar
        CURLOPT_TIMEOUT => 7,            // aguarda no máximo 7s a resposta
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_MAXREDIRS => 2,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (compatible; SecondaryPing/1.0)'
    ]);
    // executa e aguarda até 7s
    @curl_exec($ch);
    @curl_close($ch);
}

/* =============== FLUXO PRINCIPAL =============== */
$inicio_micro = microtime(true);
$iniciou_em   = date('Y-m-d H:i:s');

$numeroOriginal = isset($_POST['numero']) ? preg_replace('/\D/', '', $_POST['numero']) : null;
if (empty($numeroOriginal)) {
    $lat = max(0, (int) round(microtime(true) - $inicio_micro));

    logMonitoramentoDual($THIS_FILE, 'error', 'faltou_numero', 0, $iniciou_em, $lat, 'Nenhum número no POST');
    logNotificacaoDual($THIS_FILE, 'Consulta abortada: nenhum número informado no POST.', $iniciou_em, $lat, 0);

    echo json_encode(['url'=>gerarURL('perfilsemfoto.jpg'), 'nome'=>'', 'mensagem'=>'', 'evento_plausible'=>'naotemimagem'], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
    exit;
}

$API_KEY_WASPABLE = "0218e0716bmsh409331ab320a927p1dbf42jsn3a7a348cea06";
$apiNome = $THIS_FILE;
$nome = '';
$mensagem = '';

$variacoes = gerarVariacoesComDDI($numeroOriginal);
$imagemEncontrada = false;
$erroMsg = null;
$statusFinal = 'not_found';
$urlFinal = null;
$tentadas = [];

/* tenta as variações (com 9 / sem 9) */
foreach ($variacoes as $num) {
    $tentadas[] = $num;

    $r = consultarWaspableImagem($num, $API_KEY_WASPABLE);

    if ($r['ok'] && $r['status'] === 'success') {
        $ext = $r['ext'] ?: 'jpg';
        $nomeArquivo = 'img_' . $num . '.' . $ext;
        $urlFinal = salvarMiniaturaBytes($r['bytes'], $nomeArquivo);
        if ($urlFinal) {
            $imagemEncontrada = true;
            $statusFinal = 'success';
            break;
        } else {
            $erroMsg = 'falha ao salvar miniatura';
            $statusFinal = 'error';
        }
    } else {
        $statusTent = $r['status'] ?? 'error';
        $statusFinal = ($statusTent === 'not_found' && $statusFinal !== 'error') ? 'not_found' : 'error';
        if (!empty($r['err'])) $erroMsg = $r['err'];
        if (($r['http'] ?? 0) == 429 || ($r['err'] ?? '') === 'rate limit') {
            sleep(3); // respeita limite e tenta próxima variação
        }
    }
}

/* ======== Saída e Log ======== */
$latTotal = max(0, (int) round(microtime(true) - $inicio_micro));
$tentadasStr = implode(', ', $tentadas);

if ($imagemEncontrada) {
    setcookie('temimagem', 'sim', time()+86400*30, "/");

    logMonitoramentoDual($apiNome, 'success', $numeroOriginal, 1, $iniciou_em, $latTotal, null);
    logNotificacaoDual(
        $apiNome,
        "Imagem encontrada para o número {$numeroOriginal}. Variações tentadas: {$tentadasStr}.",
        $iniciou_em,
        $latTotal,
        1
    );

    echo json_encode(['url'=>$urlFinal, 'nome'=>$nome, 'mensagem'=>$mensagem, 'evento_plausible'=>'temimagem'], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
    exit;
}

/* >>> Disparar SEMPRE a pesquisa secundária (GET) e AGUARDAR até 7s <<< */
dispararPesquisaSecundaria($numeroOriginal);

/* ======== Fallback final (sem imagem) ======== */
setcookie('temimagem', 'nao', time()+86400*30, "/");
$urlPadrao = gerarURL('perfilsemfoto.jpg');

$msgNotif = ($statusFinal === 'error')
    ? "Erro na consulta para o número {$numeroOriginal}: ".($erroMsg ?: 'erro desconhecido').". Variações: {$tentadasStr}."
    : "Sem imagem de perfil para o número {$numeroOriginal}. Variações: {$tentadasStr}.";

logMonitoramentoDual($apiNome, $statusFinal, $numeroOriginal, 0, $iniciou_em, $latTotal, $erroMsg);
logNotificacaoDual($apiNome, $msgNotif, $iniciou_em, $latTotal, 0);

echo json_encode(['url'=>$urlPadrao, 'nome'=>'', 'mensagem'=>'', 'evento_plausible'=>'naotemimagem'], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
