<?php
header('Content-Type: application/json');

function enviarParaTelegram($mensagem) {
    $bot_token = "7574620663:AAHVrt1wimE5ZlbAoCZnq8L9myIm0CK3Wus";
    $chat_id = "-1002456760125";

    $url = "https://api.telegram.org/bot$bot_token/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $mensagem,
        'parse_mode' => 'HTML'
    ];

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $data,
    ]);
    curl_exec($ch);
    curl_close($ch);
}

if (!isset($_POST['numero'])) {
    echo json_encode(['error' => 'Número não enviado.']);
    exit;
}

$numeroOriginal = preg_replace('/\D/', '', $_POST['numero']);

function gerarVariacoesComDDI($numero) {
    if (substr($numero, 0, 2) === '55') {
        $numero = substr($numero, 2);
    }

    if (!preg_match('/^(\d{2})(\d{8,9})$/', $numero, $m)) {
        return [];
    }

    $ddd = $m[1];
    $resto = $m[2];

    $com9 = preg_match('/^9\d{8}$/', $resto) ? $ddd . $resto : $ddd . '9' . $resto;
    $sem9 = preg_match('/^9\d{8}$/', $resto) ? $ddd . substr($resto, 1) : $ddd . $resto;

    return ['55' . $com9, '55' . $sem9];
}

function baixarImagemSegura($url) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_USERAGENT => 'Mozilla/5.0',
        CURLOPT_TIMEOUT => 10,
    ]);
    $data = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ($httpCode === 200 && $data) ? $data : false;
}

$variacoes = gerarVariacoesComDDI($numeroOriginal);
$ultimaResposta = 'Sem resposta';
$duracao = 0;
$testados = [];

foreach ($variacoes as $numero) {
    $testados[] = $numero;
    enviarParaTelegram("🔍 <b>Consultando número:</b> <code>$numero</code>");

    $tentativas = 0;

    do {
        $tentativas++;
        $inicio = microtime(true);

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://whatsapp-data.p.rapidapi.com/wspicture?phone={$numero}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => true,
            CURLOPT_HTTPHEADER => [
                "x-rapidapi-host: whatsapp-data.p.rapidapi.com",
                "x-rapidapi-key: dd5b61beb8msh2f27ea737b75215p1ccd30jsn6f05fbf44ab9"
            ],
        ]);

        $response = curl_exec($curl);
        $headerSize = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $body = substr($response, $headerSize);
        $err = curl_error($curl);
        $fim = microtime(true);
        $duracao = number_format($fim - $inicio, 2);
        curl_close($curl);

        $ultimaResposta = $body ?: 'Sem resposta';

        if ($httpCode == 429) {
            enviarParaTelegram("⚠️ <b>Rate limit</b> atingido para <code>$numero</code>. Tentativa #$tentativas. Aguardando 3 segundos...");
            sleep(3);
        }
    } while ($httpCode == 429 && $tentativas < 2);

    if ($err || $body === false) {
        enviarParaTelegram("⚠️ Erro ao consultar <code>$numero</code>");
        continue;
    }

    if (preg_match('/https:\/\/.*?\.whatsapp\.net\/.*?\.(jpg|png)[^"]*/', $body, $match)) {
        $imagemUrl = $match[0];
        $extensao = pathinfo(parse_url($imagemUrl, PHP_URL_PATH), PATHINFO_EXTENSION);
        $nomeArquivo = 'img_' . $numero . '.' . $extensao;

        $pastaImagens = __DIR__ . '/imagens/';
        if (!is_dir($pastaImagens)) {
            mkdir($pastaImagens, 0755, true);
        }

        $caminhoCompleto = $pastaImagens . $nomeArquivo;
        $protocolo = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'];
        $caminhoWeb = "$protocolo://$host/imagens/$nomeArquivo";

        $conteudo = baixarImagemSegura($imagemUrl);
        if (!$conteudo) {
            enviarParaTelegram("❌ Não foi possível baixar a imagem para <code>$numero</code>");
            echo json_encode(['error' => 'Não foi possível baixar a imagem.']);
            exit;
        }

        $imagemOriginal = @imagecreatefromstring($conteudo);
        if (!$imagemOriginal) {
            enviarParaTelegram("❌ A imagem de <code>$numero</code> está corrompida.");
            echo json_encode(['error' => 'Imagem inválida ou não pôde ser processada.']);
            exit;
        }

        $miniatura = imagecreatetruecolor(50, 50);
        imagecopyresampled($miniatura, $imagemOriginal, 0, 0, 0, 0, 50, 50, imagesx($imagemOriginal), imagesy($imagemOriginal));

        if ($extensao === 'png') {
            imagepng($miniatura, $caminhoCompleto);
        } else {
            imagejpeg($miniatura, $caminhoCompleto);
        }

        imagedestroy($imagemOriginal);
        imagedestroy($miniatura);

        enviarParaTelegram("✅ <b>Imagem encontrada:</b> <code>$numero</code>\nSalva como: <code>$caminhoWeb</code>");

        echo json_encode([
            'imagem' => $imagemUrl,
            'salva_em' => $caminhoWeb,
            'tempo' => $duracao,
            'numero_testado' => $numero,
            'api_response' => $body,
            'variacoes_testadas' => $testados
        ]);
        exit;
    }

    enviarParaTelegram("❌ Nenhuma imagem encontrada para <code>$numero</code>. Tentando próxima variação...");
    usleep(300000);
}

enviarParaTelegram("🛑 <b>Nenhuma imagem encontrada</b> para <code>$numeroOriginal</code> após testar todas variações.");

echo json_encode([
    'imagem' => null,
    'tempo' => $duracao,
    'api_response' => $ultimaResposta,
    'numero_testado' => $numeroOriginal,
    'variacoes_testadas' => $testados
]);
