<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <title>Espião - Receber Arquivos</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-image: url('6240b66d5c50c8661eee78b439a7d33c.webp');
            background-size: cover;
            background-repeat: repeat-y;
            height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding-top: 120px;
        }
        .form-container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
            max-width: 400px;
            width: 100%;
        }
        .form-container h2 {
            font-size: 20px;
            text-align: center;
            margin-bottom: 20px;
            color: #333;
        }
        .btn-primary {
            background-color: #25D366;
            border-color: #25D366;
        }
    </style>
</head>
<body>
    <img src="topo.png" alt="" class="img-fluid fixed-top">

    <div class="form-container">
        <h2>Digite seu email para receber os arquivos que encontramos</h2>
        <form action="https://mariaceciliasite.com.br/sendmail/upsell.php" method="post" onsubmit="return validarFormulario()">
            <div class="mb-3">
                <input type="email" class="form-control" name="email" placeholder="Seu email" required>
            </div>
            <button type="submit" class="btn btn-primary w-100">Receber os arquivos no email</button>
        </form>
    </div>

    <script>
        function validarFormulario() {
            const email = document.querySelector('input[name="email"]').value.trim();
            if (!email || !email.includes('@')) {
                alert("Por favor, insira um email válido.");
                return false;
            }
            return true;
        }
    </script>
    
    <script>
    // Funções para manipular cookies
    function getCookie(nome) {
        const valor = `; ${document.cookie}`;
        const partes = valor.split(`; ${nome}=`);
        if (partes.length === 2) return partes.pop().split(';').shift();
    }

    // Verifica se o cookie 'email' está como 'enviado'
    if (getCookie('email') === 'enviado') {
        window.location.href = '5.html';
    }
</script>
</body>
</html>
