function iniciarBusca() {
  const textarea = document.getElementById('numeros');
  const numeros = textarea.value.split(/[\n,;]+/).map(n => n.trim()).filter(n => n);
  const resultado = document.getElementById('resultado');
  resultado.innerHTML = '';

  async function buscarProximo(i) {
    if (i >= numeros.length) {
      resultado.innerHTML += '<p><strong>Fim da lista. Nenhuma imagem encontrada.</strong></p>';
      return;
    }

    const numero = numeros[i];
    resultado.innerHTML += `<p><em>Consultando ${numero}...</em></p>`;

    try {
      const response = await fetch('validador.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: 'numero=' + encodeURIComponent(numero)
      });

      const data = await response.json();

      if (data.error) {
        resultado.innerHTML += `<p style="color:red;">Erro: ${data.error}</p>`;
        await new Promise(resolve => setTimeout(resolve, 500)); // Aguarda e continua
        buscarProximo(i + 1);
        return;
      }

      resultado.innerHTML += `<pre>Resposta completa:\n${JSON.stringify(data.api_response, null, 2)}</pre>`;
      resultado.innerHTML += `<p>Tempo: ${data.tempo} segundos</p>`;

      if (data.imagem) {
        resultado.innerHTML += `<p><strong>Imagem encontrada para ${data.numero_testado}:</strong><br><img src="${data.imagem}" width="50" height="50"></p>`;

        // Se imagem foi salva localmente, exibe também
        if (data.salva_em) {
          resultado.innerHTML += `<p><em>Miniatura salva em:</em> ${data.salva_em}</p>`;
        }

        // Mostra as variações testadas (opcional)
        if (data.variacoes_testadas) {
          resultado.innerHTML += `<p>Variações testadas: ${data.variacoes_testadas.join(', ')}</p>`;
        }

        return; // 🛑 Para aqui, não chama próximo número
      } else {
        resultado.innerHTML += `<p>Nenhuma imagem encontrada para ${data.numero_testado}.</p>`;
      }

      if (data.variacoes_testadas) {
        resultado.innerHTML += `<p>Variações testadas: ${data.variacoes_testadas.join(', ')}</p>`;
      }

      await new Promise(resolve => setTimeout(resolve, 500)); // Aguarda e continua
      buscarProximo(i + 1);

    } catch (e) {
      resultado.innerHTML += `<p style="color:red;">Erro de rede ou servidor: ${e}</p>`;
      await new Promise(resolve => setTimeout(resolve, 500)); // Aguarda e continua
      buscarProximo(i + 1);
    }
  }

  buscarProximo(0);
}
