<?php
// Conexão com banco de dados
$host = 'localhost';
$db   = 'wwmari_db';
$user = 'wwmari_admin';
$pass = '1UQ4^%naXgaFc8Zq8B&bL*85Nj5dkt*A';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['erro' => 'Falha na conexão com o banco']);
    exit;
}

// Recebe dados do frontend
$input = json_decode(file_get_contents('php://input'), true);
$event_id = $input['event_id'] ?? null;
$ip = $input['ip'] ?? null;
$fbclid = $input['fbclid'] ?? null;
$fbp = $input['fbp'] ?? null;
$fbc = $input['fbc'] ?? null;

if (!$event_id || !$ip) {
    http_response_code(400);
    echo json_encode(['erro' => 'event_id ou ip ausente']);
    exit;
}

// Verifica se já existe
$stmt = $pdo->prepare("SELECT id FROM eventos_facebook WHERE ip = ? AND event_id = ?");
$stmt->execute([$ip, $event_id]);
if ($stmt->fetch()) {
    echo json_encode(['status' => 'ja registrado']);
    exit;
}

// Insere o novo registro
$stmt = $pdo->prepare("
    INSERT INTO eventos_facebook (ip, event_id, fbclid, fbp, fbc)
    VALUES (?, ?, ?, ?, ?)
");
$stmt->execute([$ip, $event_id, $fbclid, $fbp, $fbc]);

echo json_encode(['status' => 'ok']);
