<?php
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
if ($mysqli->connect_error) die("Erro na conexão.");

$email = $_GET['email'] ?? '';
$email = $mysqli->real_escape_string($email);

// Produto mais antigo com referência
$res = $mysqli->query("
  SELECT * FROM produtos 
  WHERE email_suporte = '$email' 
    AND referencia IS NOT NULL 
    AND TRIM(referencia) != '' 
  ORDER BY data ASC 
  LIMIT 1
");
$produtos = $res ? $res->fetch_all(MYSQLI_ASSOC) : [];

if (!$produtos) {
  echo "<p>Nenhum produto encontrado com esse e-mail.</p>";
  exit;
}

$p = $produtos[0];
$referencia = $p['referencia'];

// Produto mais recente com a mesma referência
$resUltimo = $mysqli->query("
  SELECT * FROM produtos 
  WHERE referencia = '$referencia' 
    AND TRIM(referencia) != '' 
  ORDER BY data DESC 
  LIMIT 1
");
$ultimo = $resUltimo ? $resUltimo->fetch_assoc() : null;
?>

<div class="container-fluid">
  <div class="row align-items-start">
    <div class="col-2 mt-3">
      <img src="<?= htmlspecialchars($p['imagem']) ?>" class="img-fluid" alt="Imagem" style="width: 190px; height: 190px; object-fit: cover; border-radius: 8px;">
    </div>
    <div class="col-10">
      <br>
      <h2 class="produto-titulo"><?= htmlspecialchars($p['nome']) ?></h2>
      <h3 class="produto-nome"><?= htmlspecialchars($p['email_suporte']) ?></h3>
      <h3 class="produto-nome">REF: <?= htmlspecialchars($p['referencia']) ?></h3>

      <?php
      // Data de criação
      if (!empty($p['data'])) {
        try {
          $dataCriacao = new DateTime($p['data']);
          $hoje = new DateTime();
          $intervalo = $hoje->diff($dataCriacao);
          $dias = $intervalo->days;

          echo "<h3 class='produto-nome'>CRIADO HÁ {$dias} dia" . ($dias != 1 ? 's' : '') . "</h3>";
        } catch (Exception $e) {}
      }

      // Última atualização (sem mostrar a data)
      if (!empty($ultimo['data']) && $ultimo['data'] !== $p['data']) {
        try {
          $dataUltima = new DateTime($ultimo['data']);
          $hoje = new DateTime();
          $intervaloUltima = $hoje->diff($dataUltima);
          $diasUltima = $intervaloUltima->days;

          echo "<h3 class='produto-nome'>ATUALIZADO HÁ {$diasUltima} dia" . ($diasUltima != 1 ? 's' : '') . "</h3>";
        } catch (Exception $e) {}
      }

      // Buscar domínios únicos pela referência
      $resDominios = $mysqli->query("
        SELECT DISTINCT link FROM produtos 
        WHERE referencia = '$referencia'
          AND link IS NOT NULL 
          AND TRIM(link) != ''
      ");

      $dominiosUnicos = [];

      if ($resDominios) {
        while ($row = $resDominios->fetch_assoc()) {
          $link = trim($row['link']);
          $parsed = parse_url($link);
          if (!isset($parsed['host'])) continue;

          $dominio = strtolower($parsed['host']);
          $dominio = preg_replace('/^www\./', '', $dominio);

          if (
            str_starts_with($dominio, 'go.perfectpay.com.br') ||
            str_starts_with($dominio, 'checkout.perfectpay.com.br')
          ) continue;

          if (!in_array($dominio, $dominiosUnicos)) {
            $dominiosUnicos[] = $dominio;
          }
        }

        if (!empty($dominiosUnicos)) {
          foreach ($dominiosUnicos as $dom) {
            echo "<a href=\"https://$dom\" target=\"_blank\" style=\"display: inline-block; margin: 4px; padding: 6px 12px; background-color: #f0f0f0; border-radius: 6px; text-decoration: none; color: blue; font-weight: bold;\">$dom</a>";
          }
        } else {
          echo "<li>Nenhum domínio externo encontrado.</li>";
        }
      } else {
        echo "<li>Erro ao buscar domínios.</li>";
      }
      ?>
    </div>
  </div>
</div>
