<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Checkouts em tempo real</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
    <h2 class="mb-4">Checkouts encontrados</h2>
    <div id="resultado" class="row"></div>
</div>

<script>
let offset = 0;             // Posição atual
const limit = 2;            // Quantos checkouts por chamada
const delay = 60000;         // Tempo de espera após cada resposta (ms)

async function buscarCheckoutsSequencial() {
    try {
       const res = await fetch(`busca.php?offset=${offset}&limit=${limit}`);
        const html = await res.text();

        document.getElementById('resultado').insertAdjacentHTML('beforeend', html);
        offset += limit;

        // Espera 'delay' milissegundos antes de chamar o próximo
        setTimeout(buscarCheckoutsSequencial, delay);
    } catch (error) {
        console.error("Erro ao buscar:", error);
        // Tenta novamente depois de um tempo mesmo com erro
        setTimeout(buscarCheckoutsSequencial, delay);
    }
}

// Inicia o ciclo
buscarCheckoutsSequencial();
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>