<?php
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
if ($mysqli->connect_error) die("Erro na conexão");
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Ofertas</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <style>
    html, body {
      height: 100%;
      margin: 0;
    }
    body {
      font-family: 'Roboto', sans-serif;
      background-color: #F9FAFC;
      display: flex;
      flex-direction: column;
    }
    .sidebar {
      width: 260px;
      height: 100vh;
      background: #fff;
      border-right: 1px solid #E0E0E0;
      position: fixed;
      top: 0;
      left: 0;
      padding: 2rem 1.5rem;
      box-shadow: 0 0 6px rgba(0, 0, 0, 0.05);
    }
    .sidebar .nav-link {
      display: flex;
      align-items: center;
      gap: 12px;
      font-size: 14px;
      font-weight: 500;
      color: #555;
      padding: 12px;
      border-radius: 6px;
      transition: 0.2s;
    }
    .sidebar .nav-link:hover {
      background-color: #f2f2f2;
    }
    .sidebar .nav-link.active {
      color: #2F80ED;
      border-left: 3px solid #2F80ED;
      background-color: #f2f2f2;
    }
    .content {
      margin-left: 260px;
      padding: 24px 32px 0 32px;
      display: flex;
      flex-direction: column;
      height: 100vh;
      overflow: hidden;
    }
    .content-header {
      margin-bottom: 10px;
    }
    .btn-primary {
      background-color: #2F80ED;
      border: none;
      font-weight: 500;
      padding: 10px 18px;
      border-radius: 6px;
    }
    .card-table {
      background: #fff;
      border-radius: 8px;
      padding: 16px;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
      overflow: hidden;
      display: flex;
      flex-direction: column;
      flex: 1;
      margin-bottom: 16px;
    }
    .scroll-wrapper {
      flex: 1;
      overflow-y: auto;
      padding-right: 8px;
      max-height: calc(95vh - 160px);
      mask-image: linear-gradient(to bottom, transparent 0px, black 20px, black calc(100% - 20px), transparent 100%);
      -webkit-mask-image: linear-gradient(to bottom, transparent 0px, black 20px, black calc(100% - 20px), transparent 100%);
    }
    thead th {
      font-size: 16px;
      font-weight: 200;
      padding: 14px;
      border-bottom: 1px solid #e0e0e0;
      color: #444;
      position: sticky;
      top: 0;
      background: #fff;
      z-index: 2;
      box-shadow: 0 2px 4px rgba(0,0,0,0.03);
    }
    tbody td {
      font-size: 16px;
      padding: 160px;
      border-bottom: 1px solid #f0f0f0;
      vertical-align: middle;
    }
    tbody tr:hover {
      background-color: #FAFAFA;
    }
    .produto-img {
      width: 40px;
      height: 40px;
      border-radius: 6px;
      object-fit: cover;
      margin-right: 12px;
    }
    .produto-nome {
      font-weight: 400;
      color: #222;
    }
    .produto-email {
      font-size: 12px;
      color: #999;
    }
    .produto_dominio{
         color: #EB5757;
      font-size: 16px;
      font-weight: 400;
    }
    .badge-internacional {
      color: #EB5757;
      font-size: 16px;
      font-weight: 600;
    }
        .online-dot {
  width: 8px;
  height: 8px;
  background-color: #28a745;
  border-radius: 50%;
  display: inline-block;
}
  </style>
  </style>
</head>
<body>

<aside class="sidebar">
  <h5 class="mb-4 fw-bold text-primary">Painel</h5>

  <!-- Produtos com submenu -->
  <div class="nav flex-column">
    <a class="nav-link d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#submenuProdutos" role="button" aria-expanded="false" aria-controls="submenuProdutos">
      <span><i class="fas fa-box"></i> Produtos</span>
      <i class="fas fa-chevron-down small"></i>
    </a>
    <div class="collapse" id="submenuProdutos"> <!-- remova "show" se quiser fechado por padrão -->
      <a href="painel.php" class="nav-link ps-4">Escalados</a>
      <a href="painel_novos.php" class="nav-link ps-4">Novos Produtos</a>
    </div>
  </div>

  <!-- Restante do menu -->
  <a href="#" class="nav-link active"><i class="fas fa-globe"></i> Domínios</a>
  <a href="#" class="nav-link"><i class="fas fa-tags"></i> Checkouts</a>
  <a href="#" class="nav-link"><i class="fas fa-bullhorn"></i> Anúncios</a>
</aside>

<main class="content">
  <div class="content-header">
    <form method="GET" class="w-100">
      <div class="input-group">
        <input type="text" name="busca" class="form-control form-control" placeholder="Buscar produto, email, referência...">
      </div>
    </form>
  </div>

  <div class="px-3 py-2 text-muted small" id="contador-resultados">Carregando...</div>
  <div class="card-table">
    <div class="scroll-wrapper">
      <table class="table table-hover align-middle mb-0">
        <thead>
            <tr>
     <th>Anúncios</th>
    <th>Dominio</th>
<th>Refs</th>
<th>Registros</th>
  </tr>
</thead>
        <tbody></tbody>
      </table>
    </div>
  </div>
</main>

<!-- SINO -->
<div class="position-fixed top-0 end-0 m-4" style="z-index: 1050;">
  <div class="dropdown">
    <button class="btn btn-light position-relative" id="btnSino" data-bs-toggle="dropdown" aria-expanded="false">
      <i class="fas fa-bell"></i>
      <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger" id="contadorSino">0</span>
    </button>
    <ul class="dropdown-menu dropdown-menu-end shadow-sm" id="listaNotificacoes" style="width: 300px;">
      <li class="dropdown-header fw-bold">Últimas notificações</li>
      <li><hr class="dropdown-divider"></li>
    </ul>
  </div>
</div>

<!-- TOAST -->
<div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 2000;">
  <div class="toast align-items-center text-bg-warning border-0" id="toastNotificacao" role="alert" data-bs-autohide="false">
    <div class="d-flex">
      <div class="toast-body" id="toastMensagem">Nova notificação</div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" onclick="fecharNotificacao()"></button>
    </div>
  </div>
</div>

<!-- SOM -->
<audio id="somNotificacao" preload="auto">
  <source src="https://assets.mixkit.co/sfx/preview/mixkit-software-interface-start-2574.mp3" type="audio/mpeg">
</audio>

<!-- JS -->
<script>
let offset = 0;
const limite = 500;
let buscando = false;
let buscaAtual = '';
let ultimaBusca = '';
let debounce;
let totalResultados = 0;
const input = document.querySelector("input[name='busca']");
const tbody = document.querySelector("tbody");
const contador = document.getElementById("contador-resultados");

async function carregarOfertas(reset = false) {
  if (buscando) return;
  buscando = true;
  if (reset) {
    offset = 0;
    totalResultados = 0;
    tbody.innerHTML = '';
  }
  const url = `buscar_dominios.php?offset=${offset}&limite=${limite}&busca=${encodeURIComponent(buscaAtual)}`;
  const resposta = await fetch(url);
  const json = await resposta.json();
  const dados = json.resultados || [];
  const total = json.total || 0;

  if (dados.length === 0 && offset === 0) {
    contador.textContent = "Nenhum resultado encontrado.";
    tbody.innerHTML = '<tr><td colspan="7" class="text-center py-4">Nenhum resultado encontrado.</td></tr>';
  } else {
    dados.forEach(o => {
          const linha = `
        <tr>
<td>
  <div style="display: flex; align-items: center; gap: 6px;">
    <i class="fab fa-facebook-square" style="color:#1877F2;"></i>
    ${o.qnt_anuncios > 0 ? '<span class="online-dot"></span>' : ''}
    ${o.qnt_anuncios}
  </div>
</td>
        
          <td class="produto_dominio">${o.dominio}<br></td>
          <td>${
  Array.isArray(o.referencias)
    ? o.referencias.slice(0, 10).map(ref => ref.referencia || ref).join(", ") +
      (o.referencias.length > 10 ? '...' : '')
    : o.referencias || '-'
}<br></td>
<td class="text-center align-middle">${o.quantidade_mesmo_dominio}</td>
        </tr>`;
      tbody.insertAdjacentHTML("beforeend", linha);
    });
    offset += limite;
    totalResultados += dados.length;
    contador.textContent = `${total} resultado${total === 1 ? '' : 's'} encontrado${total === 1 ? '' : 's'}.`;
  }
  buscando = false;
}

input.addEventListener("input", () => {
  clearTimeout(debounce);
  debounce = setTimeout(() => {
    buscaAtual = input.value.trim();
    if (buscaAtual !== ultimaBusca) {
      ultimaBusca = buscaAtual;
      carregarOfertas(true);
    }
  }, 300);
});

const scrollWrapper = document.querySelector(".scroll-wrapper");
scrollWrapper.addEventListener('scroll', () => {
  const fimScroll = scrollWrapper.scrollTop + scrollWrapper.clientHeight >= scrollWrapper.scrollHeight - 100;
  if (fimScroll && !buscando) {
    carregarOfertas();
  }
});

function fecharNotificacao() {
  document.getElementById("toastNotificacao").classList.add("d-none");
  document.getElementById("contadorSino").innerText = "0";
}

async function atualizarNotificacoes() {
  const res = await fetch('verificar_notificacoes.php');
  const data = await res.json();
  if (data.nova) {
    const toast = new bootstrap.Toast(document.getElementById("toastNotificacao"));
    document.getElementById("toastMensagem").innerText = data.mensagem;
    toast.show();
    try { document.getElementById("somNotificacao").play(); } catch (e) {}
    document.getElementById("contadorSino").innerText = parseInt(document.getElementById("contadorSino").innerText) + 1;

    const item = `<li class="px-3 py-2 small">${data.mensagem}</li>`;
    document.getElementById("listaNotificacoes").insertAdjacentHTML('beforeend', item);
  }
}

setInterval(atualizarNotificacoes, 10000);
carregarOfertas();

let dadosCache = [];

function atualizarTabela(dados) {
  tbody.innerHTML = '';
  dados.forEach(o => {
    const linha = `
      <tr>
<td class="text-center align-middle">
  <div style="display: flex; align-items: center; gap: 6px;">
    <i class="fab fa-facebook-square" style="color:#1877F2;"></i>
    ${o.qnt_anuncios > 0 ? '<span class="online-dot"></span>' : ''}
    ${o.qnt_anuncios}
  </div>
</td>
        <td class="produto_dominio">${o.dominio}<br></td>
        <td>${
          Array.isArray(o.referencias)
  ? o.referencias.slice(0, 10).map(ref => ref.nome || ref).join(", ") +
    (o.referencias.length > 10 ? '...' : '')
  : o.referencias || '-'
        }<br></td>
        
        <td class="text-center">${o.quantidade_mesmo_dominio}</td>
      </tr>`;
    tbody.insertAdjacentHTML("beforeend", linha);
  });
}

async function carregarOfertas(reset = false) {
  if (buscando) return;
  buscando = true;
  if (reset) {
    offset = 0;
    totalResultados = 0;
    tbody.innerHTML = '';
    dadosCache = [];
  }

  const url = `buscar_dominios.php?offset=${offset}&limite=${limite}&busca=${encodeURIComponent(buscaAtual)}`;
  const resposta = await fetch(url);
  const json = await resposta.json();
  const dados = json.resultados || [];
  const total = json.total || 0;

  if (dados.length === 0 && offset === 0) {
    contador.textContent = "Nenhum resultado encontrado.";
    tbody.innerHTML = '<tr><td colspan="7" class="text-center py-4">Nenhum resultado encontrado.</td></tr>';
  } else {
    dadosCache = [...dadosCache, ...dados];
    atualizarTabela(dadosCache);
    offset += limite;
    totalResultados += dados.length;
    contador.textContent = `${totalResultados} resultado${totalResultados === 1 ? '' : 's'} encontrado${totalResultados === 1 ? '' : 's'}.`;
  }

  buscando = false;
}

document.querySelectorAll("th[data-sort]").forEach(th => {
  th.addEventListener("click", () => {
    const campo = th.getAttribute("data-sort");
    const ordemAtual = th.getAttribute("data-order");
    const novaOrdem = ordemAtual === "asc" ? "desc" : "asc";
    th.setAttribute("data-order", novaOrdem);

    // Limpa ícones antigos
    document.querySelectorAll("th[data-sort] i").forEach(i => i.className = "fas fa-sort");
    th.querySelector("i").className = novaOrdem === "asc" ? "fas fa-sort-up" : "fas fa-sort-down";

    // Ordena os dadosCache
    dadosCache.sort((a, b) => {
      if (novaOrdem === "asc") return a[campo] - b[campo];
      return b[campo] - a[campo];
    });
    atualizarTabela(dadosCache);
  });
});


</script>
</body>
</html>