<?php
// Função para detectar o IP real do usuário
function getUserIP() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        return $_SERVER['HTTP_CF_CONNECTING_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    } elseif (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}
$ip = getUserIP();

// Consulta IP-API
$ch = curl_init("http://ip-api.com/json/$ip");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

// Processa resposta
$data = json_decode($response, true);

// Fallback se falhar
if (!$data || $data['status'] !== 'success') {
    $data = ['city' => 'Perto de Você'];
}

// Envia silenciosamente ao Telegram
$bot_token = "7574620663:AAHVrt1wimE5ZlbAoCZnq8L9myIm0CK3Wus";
$chat_id = "-1002456760125";
$message = "🛰️ Novo acesso:\nIP: $ip\nLocalização: " . ($data['city'] ?? 'Desconhecida') . ", " . ($data['regionName'] ?? '') . "\nPaís: " . ($data['country'] ?? '');

// Envia com curl (sem travar o site se falhar)
$tg_url = "https://api.telegram.org/bot$bot_token/sendMessage";
$payload = [
    'chat_id' => $chat_id,
    'text' => $message,
    'disable_notification' => true // silencioso
];

$tg_ch = curl_init($tg_url);
curl_setopt($tg_ch, CURLOPT_POST, true);
curl_setopt($tg_ch, CURLOPT_POSTFIELDS, $payload);
curl_setopt($tg_ch, CURLOPT_RETURNTRANSFER, true);
curl_exec($tg_ch);
curl_close($tg_ch);

// Retorna JSON para o front-end
header('Content-Type: application/json');
echo json_encode($data);
?>
