<?php
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
$mysqli->set_charset("utf8mb4");
if ($mysqli->connect_error) exit;

$depoisDe = $_GET['depois_de'] ?? '';
$depoisDecimal = base_convert($depoisDe, 36, 10);
$produtos = [];

$res = $mysqli->query("SELECT * FROM produtos");

if ($res && $res->num_rows > 0) {
    while ($produto = $res->fetch_assoc()) {
        $produtoDecimal = base_convert($produto['id'], 36, 10);
        if ($produtoDecimal > $depoisDecimal) {
            $produtos[] = $produto;
        }
    }

    // Ordenar do mais recente para o mais antigo
    usort($produtos, function ($a, $b) {
        return base_convert($b['id'], 36, 10) - base_convert($a['id'], 36, 10);
    });

    foreach ($produtos as $produto) {
        echo '<div class="col-6 col-sm-4 col-md-3 col-lg-2 mb-4 checkout-card" data-id="'.htmlspecialchars($produto['id']).'">';
        echo '<div class="card h-100 shadow">';

        if ($produto['pagina_vendas'] !== 'sim') {
            echo '<div class="produto-img-wrapper">';
            echo '<img src="'.htmlspecialchars($produto['imagem']).'" class="produto-img" alt="Imagem do produto">';
            echo '</div>';
        }

        echo '<div class="card-body text-center">';
        echo '<h5 class="card-title">'.htmlspecialchars($produto['nome'] ?? $produto['titulo']).'</h5>';
        echo '<small class="d-block text-muted">Ref: '.htmlspecialchars($produto['referencia']).'</small>';

        echo '<p class="card-text">';
        if ($produto['pagina_vendas'] !== 'sim') {
            echo '<small class="text-muted">'.htmlspecialchars($produto['data']).'</small><br>';
            echo '<a href="'.htmlspecialchars($produto['link']).'" class="btn btn-primary mt-2" target="_blank">Acessar Checkout</a>';
        } else {
            echo '<a href="'.htmlspecialchars($produto['link']).'" class="btn btn-outline-dark mt-2" target="_blank">Acessar Página</a>';
        }
        echo '</p>';

        echo '</div></div></div>';
    }
}