<!-- index.php -->
<?php
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
$produtos = [];
$totalCheckouts = 0;
$totalPaginas = 0;
$solicitado = '-';
$realizado = '-';
$ultimoStatus = '-';

if (!$mysqli->connect_error) {
    $resultado = $mysqli->query("SELECT * FROM produtos ORDER BY id DESC LIMIT 200");
    $produtos = $resultado ? $resultado->fetch_all(MYSQLI_ASSOC) : [];

usort($produtos, function ($a, $b) {
    return base_convert($b['id'], 36, 10) <=> base_convert($a['id'], 36, 10);
});
    // Total de checkouts
$res = $mysqli->query("SELECT COUNT(*) AS total FROM produtos WHERE pagina_vendas != 'sim'");
if ($res && $row = $res->fetch_assoc()) {
    $totalCheckouts = $row['total'];
}

// Total de páginas
$res = $mysqli->query("SELECT COUNT(*) AS total FROM produtos WHERE pagina_vendas = 'sim'");
if ($res && $row = $res->fetch_assoc()) {
    $totalPaginas = $row['total'];
}
    $resHorarios = $mysqli->query("SELECT * FROM horarios WHERE id = 1");
    if ($resHorarios && $resHorarios->num_rows > 0) {
        $row = $resHorarios->fetch_assoc();
        $solicitado = $row['solicitado'];
        $realizado = $row['realizado'];
    }

    $resUltimo = $mysqli->query("SELECT encontrou FROM ultimoproduto WHERE id = 1");
    if ($resUltimo && $resUltimo->num_rows > 0) {
        $row = $resUltimo->fetch_assoc();
        $ultimoStatus = $row['encontrou'] === 'sim' ? 'Sim' : 'Não';
    }
    $emEspera = '-';
$tentativas = '-';

$resEsperar = $mysqli->query("SELECT calma, tentativas FROM esperar WHERE id = 1");
if ($resEsperar && $resEsperar->num_rows > 0) {
    $row = $resEsperar->fetch_assoc();
    $emEspera = $row['calma'] === 'sim' ? 'Sim' : 'Não';
    $tentativas = $row['tentativas'];
}
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Checkouts encontrados</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .produto-img-wrapper {
      aspect-ratio: 1 / 1;
      width: 100%;
      overflow: hidden;
      border-bottom: 1px solid #eee;
    }
    .produto-img-wrapper img {
      width: 100%;
      height: 100%;
      object-fit: cover;
    }
    .card-title {
      font-size: 1rem;
      overflow: hidden;
      text-overflow: ellipsis;
      display: -webkit-box;
      -webkit-line-clamp: 2;
      -webkit-box-orient: vertical;
      min-height: 3em;
    }
  </style>
</head>
<body>
<div class="container mt-4">
  <div class="row mb-4">
    <div class="col-md-3"><strong>Checkouts encontrados:</strong> <span id="count-checkouts"><?= $totalCheckouts ?></span></div>
    <div class="col-md-3"><strong>Páinas externas:</strong> <span id="count-paginas"><?= $totalPaginas ?></span></div>
    <div class="col-md-3"><strong>Solicitado:</strong> <span id="data-solicitado"><?= $solicitado ?></span></div>
    <div class="col-md-3"><strong>Atualizado:</strong> <span id="data-realizado"><?= $realizado ?></span></div>
    <div class="col-md-3 mt-2"><strong>Chegou ao último?</strong> <span id="status-ultimo"><?= $ultimoStatus ?></span></div>
  <div class="col-md-3"><strong>Em espera:</strong> <span id="info-espera"><?= $emEspera ?></span></div>
<div class="col-md-3"><strong>Tentativas:</strong> <span id="info-tentativas"><?= $tentativas ?></span></div>

  </div>

  <div id="resultado" class="row">
    <?php foreach ($produtos as $produto): ?>
      <div class="col-6 col-sm-4 col-md-3 col-lg-2 mb-4 checkout-card" data-id="<?= $produto['id'] ?>">
        <div class="card h-100 shadow">
          <?php if ($produto['pagina_vendas'] !== 'sim'): ?>
            <div class="produto-img-wrapper">
              <img src="<?= htmlspecialchars($produto['imagem']) ?>" alt="Imagem do produto">
            </div>
          <?php endif; ?>
          <div class="card-body text-center">
            <h5 class="card-title"><?= htmlspecialchars($produto['nome'] ?? $produto['titulo']) ?></h5>
            <small class="d-block text-muted">Ref: <?= htmlspecialchars($produto['referencia']) ?></small>
            <p class="card-text">
              <?php if ($produto['pagina_vendas'] !== 'sim'): ?>
                <small class="text-muted"><?= htmlspecialchars($produto['data']) ?></small><br>
                <a href="<?= htmlspecialchars($produto['link']) ?>" class="btn btn-primary mt-2" target="_blank">Acessar Checkout</a>
              <?php else: ?>
                <a href="<?= htmlspecialchars($produto['link']) ?>" class="btn btn-outline-dark mt-2" target="_blank">Acessar Página</a>
              <?php endif; ?>
            </p>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<script>
let ultimoId = <?= $totalCheckouts + $totalPaginas > 0 ? json_encode($produtos[0]['id']) : 0 ?>;

setInterval(async () => {
  try {
    const res = await fetch('listar_ajax.php?depois_de=' + ultimoId);
    const html = await res.text();

    if (html.trim() !== '') {
      const tempDiv = document.createElement('div');
      tempDiv.innerHTML = html;

      const novos = tempDiv.querySelectorAll('.checkout-card');
      if (novos.length > 0) {
        const container = document.getElementById('resultado');
       novos.forEach(novo => {
  container.insertAdjacentElement('afterbegin', novo);
});

// 🔁 Limita a 200 cards na tela
const todosCards = container.querySelectorAll('.checkout-card');
if (todosCards.length > 200) {
  for (let i = 200; i < todosCards.length; i++) {
    todosCards[i].remove();
  }
}
        ultimoId = novos[0].getAttribute('data-id');
      }
    }

    const painelRes = await fetch('listar_info.php');
    const painelData = await painelRes.json();
    document.getElementById('count-checkouts').textContent = painelData.checkouts;
    document.getElementById('count-paginas').textContent = painelData.paginas;
    document.getElementById('data-solicitado').textContent = painelData.solicitado;
    document.getElementById('data-realizado').textContent = painelData.realizado;
    document.getElementById('status-ultimo').textContent = painelData.ultimo;
document.getElementById('info-espera').textContent = painelData.espera;
document.getElementById('info-tentativas').textContent = painelData.tentativas;
  } catch (err) {
    console.warn("Erro ao buscar dados:", err);
  }
}, 5000);
</script>

<script>
let carregandoAntigos = false;

window.addEventListener('scroll', async () => {
  const scrollTop = window.scrollY;
  const docHeight = document.body.scrollHeight;
  const winHeight = window.innerHeight;

  if (!carregandoAntigos && (scrollTop + winHeight >= docHeight - 100)) {
    carregandoAntigos = true;

    const container = document.getElementById('resultado');
    const todos = container.querySelectorAll('.checkout-card');
    const ultimo = todos[todos.length - 1];
    if (!ultimo) return;

    const id = ultimo.getAttribute('data-id');

    try {
      const res = await fetch('listar_antigos.php?antes_de=' + id);
      const html = await res.text();
      if (html.trim() !== '') {
        const tempDiv = document.createElement('div');
        tempDiv.innerHTML = html;
        const novos = tempDiv.querySelectorAll('.checkout-card');
        novos.forEach(n => container.appendChild(n));
      }
    } catch (e) {
      console.warn("Erro ao carregar antigos:", e);
    } finally {
      carregandoAntigos = false;
    }
  }
});
</script>
</body>
</html>