<?php
function limparImagensAntigas($pastaRelativa, $protegerPerfil = false) {
    $pastaAbsoluta = realpath(__DIR__ . $pastaRelativa);
    $imagemProtegida = 'perfilsemfoto.jpg';
    $extensoes = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
    $limiteTempo = strtotime('-2 days');

    if (!$pastaAbsoluta || !is_dir($pastaAbsoluta)) {
        echo "<h3 style='color:red;'>Erro: Pasta não encontrada: $pastaRelativa</h3>";
        return;
    }

    echo "<h3>Limpando imagens mais antigas que 7 dias em: $pastaRelativa</h3>";

    $arquivos = scandir($pastaAbsoluta);
    $contadorDeletadas = 0;
    $contadorPreservadas = 0;

    foreach ($arquivos as $arquivo) {
        $caminho = $pastaAbsoluta . DIRECTORY_SEPARATOR . $arquivo;

        if (!is_file($caminho)) continue;

        $extensao = strtolower(pathinfo($arquivo, PATHINFO_EXTENSION));
        if (!in_array($extensao, $extensoes)) continue;

        if ($protegerPerfil && $arquivo === $imagemProtegida) {
            echo "<p><strong>Protegida:</strong> $arquivo (não será deletada)</p>";
            $contadorPreservadas++;
            continue;
        }

        $modificacao = filemtime($caminho);
        if ($modificacao < $limiteTempo) {
            if (unlink($caminho)) {
                echo "<p style='color:green;'>Deletada: $arquivo</p>";
                $contadorDeletadas++;
            } else {
                echo "<p style='color:red;'>Erro ao deletar: $arquivo</p>";
            }
        } else {
            $contadorPreservadas++;
        }
    }

    echo "<p><strong>Total deletadas:</strong> $contadorDeletadas</p>";
    echo "<p><strong>Total preservadas:</strong> $contadorPreservadas</p>";
    echo "<hr>";
}

// Executar limpeza nas duas pastas
limparImagensAntigas('/imagens', true);  // Protege perfilsemfoto.jpg
limparImagensAntigas('/prints', false); // Sem proteção
?>
