<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Globo 3D com Localização</title>
  <style>
    body { margin: 0; overflow: hidden; background-color: black; color: white; }
    #mensagem { position: absolute; top: 20px; left: 20px; z-index: 10; font-size: 18px; }
  </style>
</head>
<body>
  <div id="mensagem">Carregando o globo...</div>

  <!-- Scripts funcionais com versão compatível -->
  <script src="https://cdn.jsdelivr.net/npm/three@0.136.0/build/three.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/three@0.136.0/examples/js/controls/OrbitControls.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/three-globe@2.24.11/dist/three-globe.min.js"></script>

  <script>
    // Câmera, cena, renderizador
    const scene = new THREE.Scene();
    const camera = new THREE.PerspectiveCamera();
    camera.aspect = window.innerWidth / window.innerHeight;
    camera.updateProjectionMatrix();
    camera.position.z = 300;

    const renderer = new THREE.WebGLRenderer();
    renderer.setSize(window.innerWidth, window.innerHeight);
    document.body.appendChild(renderer.domElement);

    // Luzes
    const ambientLight = new THREE.AmbientLight(0xbbbbbb);
    scene.add(ambientLight);
    const directionalLight = new THREE.DirectionalLight(0xffffff, 0.6);
    directionalLight.position.set(0, 50, 100);
    scene.add(directionalLight);

    // Globo
    const globe = new ThreeGlobe()
      .globeImageUrl('//unpkg.com/three-globe/example/img/earth-dark.jpg')
      .bumpImageUrl('//unpkg.com/three-globe/example/img/earth-topology.png');

    scene.add(globe);

    // Controles
    const controls = new THREE.OrbitControls(camera, renderer.domElement);
    controls.autoRotate = true;
    controls.autoRotateSpeed = 0.5;

    // Loop de animação
    function animate() {
      requestAnimationFrame(animate);
      controls.update();
      renderer.render(scene, camera);
    }
    animate();

    // Após 10 segundos, buscar localização
    setTimeout(() => {
      fetch('localizacao.php')
        .then(res => res.json())
        .then(data => {
          console.log("Dados recebidos:", data);

          if (data.status === "success" && data.lat && data.lon) {
            document.getElementById("mensagem").textContent =
              `Localização encontrada: ${data.city}, ${data.country}`;

        globe
  .pointsData([{ lat: data.lat, lng: data.lon, size: 1 }])
  .pointAltitude(0.1)
  .pointColor(() => 'red');
          } else {
            document.getElementById("mensagem").textContent = "Localização não encontrada.";
          }
        })
        .catch((err) => {
          console.error("Erro ao buscar localizacao.php", err);
          document.getElementById("mensagem").textContent = "Erro ao carregar a localização.";
        });
    }, 10000);
  </script>
</body>
</html>
