<?php
header('Content-Type: application/json');

$diretorio = 'fotos/';
$extensoes = ['jpg', 'jpeg', 'png', 'webp', 'gif'];

$imagens = [];
foreach ($extensoes as $ext) {
    foreach (glob($diretorio . '*.' . $ext) as $arquivo) {
        $imagens[] = $arquivo;
    }
}

shuffle($imagens);
$imagens = array_slice($imagens, 0, 50); // Limita a 50 imagens

// Corrige o caminho para navegação web
$imagens = array_map(function($img) {
    return '/' . ltrim($img, '/'); // Garante que começa com "/"
}, $imagens);

echo json_encode($imagens);