<?php
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
if ($mysqli->connect_error) die("Erro na conexão");
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Ofertas</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <style>
    html, body {
      height: 100%;
      margin: 0;
    }
    body {
      font-family: 'Roboto', sans-serif;
      background-color: #F9FAFC;
      display: flex;
      flex-direction: column;
    }
    .sidebar {
      width: 260px;
      height: 100vh;
      background: #fff;
      border-right: 1px solid #E0E0E0;
      position: fixed;
      top: 0;
      left: 0;
      padding: 2rem 1.5rem;
      box-shadow: 0 0 6px rgba(0, 0, 0, 0.05);
    }
    .sidebar .nav-link {
      display: flex;
      align-items: center;
      gap: 12px;
      font-size: 14px;
      font-weight: 500;
      color: #555;
      padding: 12px;
      border-radius: 6px;
      transition: 0.2s;
    }
    .sidebar .nav-link:hover {
      background-color: #f2f2f2;
    }
    .sidebar .nav-link.active {
      color: #2F80ED;
      border-left: 3px solid #2F80ED;
      background-color: #f2f2f2;
    }
    .content {
      margin-left: 260px;
      padding: 24px 32px 0 32px;
      display: flex;
      flex-direction: column;
      height: 100vh;
      overflow: hidden;
    }
    .content-header {
      margin-bottom: 10px;
    }
    .btn-primary {
      background-color: #2F80ED;
      border: none;
      font-weight: 500;
      padding: 10px 18px;
      border-radius: 6px;
    }
    .card-table {
      background: #fff;
      border-radius: 8px;
      padding: 16px;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
      overflow: hidden;
      display: flex;
      flex-direction: column;
      flex: 1;
      margin-bottom: 16px;
    }
    .scroll-wrapper {
      flex: 1;
      overflow-y: auto;
      padding-right: 8px;
      max-height: calc(95vh - 160px);
      mask-image: linear-gradient(to bottom, transparent 0px, black 20px, black calc(100% - 20px), transparent 100%);
      -webkit-mask-image: linear-gradient(to bottom, transparent 0px, black 20px, black calc(100% - 20px), transparent 100%);
    }
    thead th {
      font-size: 16px;
      font-weight: 200;
      padding: 14px;
      border-bottom: 1px solid #e0e0e0;
      color: #444;
      position: sticky;
      top: 0;
      background: #fff;
      z-index: 2;
      box-shadow: 0 2px 4px rgba(0,0,0,0.03);
    }
    tbody td {
      font-size: 16px;
      padding: 14px;
      border-bottom: 1px solid #f0f0f0;
      vertical-align: middle;
    }
    tbody tr:hover {
      background-color: #FAFAFA;
    }
    .produto-img {
      width: 60px;
      height: 60px;
      border-radius: 3px;
      object-fit: cover;
      margin-right: 12px;
    }
    .produto-nome, .produto-email, .produto-anuncio, .produto-internacional, .produto-checkout, .produto-posicao {
      color: black;
      font-size: 16px;
      font-weight: 400;
    }
    .produto-titulo{
          color: black;
      font-size: 17px;
      font-weight: 500;
    }
    .online-dot {
      width: 8px;
      height: 8px;
      background-color: #28a745;
      border-radius: 50%;
      display: inline-block;
    }
    .nav-tabs .nav-link {
  font-weight: 500;
  color: #555;
}
.nav-tabs .nav-link.active {
  color: #2F80ED;
  border-color: #2F80ED #2F80ED #fff;
}
  </style>
</head>
<body>

<aside class="sidebar">
  <h5 class="mb-4 fw-bold text-primary">Painel</h5>

  <!-- Produtos com submenu -->
  <div class="nav flex-column">
    <a class="nav-link d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#submenuProdutos" role="button" aria-expanded="false" aria-controls="submenuProdutos">
      <span><i class="fas fa-box"></i> Produtos</span>
      <i class="fas fa-chevron-down small"></i>
    </a>
    <div class="collapse show" id="submenuProdutos"> <!-- remova "show" se quiser fechado por padrão -->
      <a href="painel.php" class="nav-link ps-4 ">Escalados</a>
      <a href="painel_novos.php" class="nav-link ps-4 active">Novos Produtos</a>
    </div>
  </div>

  <!-- Restante do menu -->
  <a href="painel_dominios.php" class="nav-link"><i class="fas fa-globe"></i> Domínios</a>
  <a href="#" class="nav-link"><i class="fas fa-tags"></i> Checkouts</a>
  <a href="#" class="nav-link"><i class="fas fa-bullhorn"></i> Anúncios</a>
</aside>

<main class="content">
  <div class="content-header">
    <form method="GET" class="w-100">
      <div class="input-group">
        <input type="text" name="busca" class="form-control form-control" placeholder="Buscar produto, email, referência...">
      </div>
    </form>
  </div>
  <div class="px-3 py-2 text-muted small" id="contador-resultados">Carregando...</div>
  <div class="card-table">
    <div class="scroll-wrapper">
      <table class="table table-hover align-middle mb-0">
        <thead>
          <tr>
            <th></th>
            <th>Produto</th>
            <th>Email</th>
            <th class="text-center">Anúncios</th>
            <th class="text-center">Checkouts</th>
            <th class="text-center">Internacional</th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
    </div>
  </div>
</main><!-- Modal fullscreen com abas -->
<div class="modal fade" id="modalDetalhes" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-fullscreen">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalTituloProduto">Detalhes do Produto</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <div class="modal-body p-0 d-flex flex-column" id="conteudoModal">

        <!-- Abas no topo -->
        <ul class="nav nav-tabs px-4 pt-3" id="tabsModal" role="tablist">
          <li class="nav-item" role="presentation">
            <button class="nav-link active" id="aba-geral-tab" data-bs-toggle="tab" data-bs-target="#aba-geral" type="button" role="tab">Geral</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="aba-links-tab" data-bs-toggle="tab" data-bs-target="#aba-links" type="button" role="tab">Links</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="aba-checkouts-tab" data-bs-toggle="tab" data-bs-target="#aba-checkouts" type="button" role="tab">Checkouts</button>
          </li>
        </ul>

        <!-- Conteúdo das abas -->
        <div class="tab-content flex-grow-1 overflow-auto p-4" style="min-height: 80vh;">
          <div class="tab-pane fade show active" id="aba-geral" role="tabpanel">
            <div class="card p-3" id="conteudo-aba-geral">Carregando...</div>
          </div>
          <div class="tab-pane fade" id="aba-links" role="tabpanel">
            <div class="card p-3" id="conteudo-aba-links">Carregando...</div>
          </div>
          <div class="tab-pane fade" id="aba-checkouts" role="tabpanel">
            <div class="card p-3" id="conteudo-aba-checkouts">Carregando...</div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>

</div>

<script>
let offset = 0;
const limite = 50;
let buscando = false;
let buscaAtual = '';
let ultimaBusca = '';
let debounce;
let totalResultados = 0;
let ultimaDataCriada = null;

const input = document.querySelector("input[name='busca']");
const tbody = document.querySelector("tbody");
const contador = document.getElementById("contador-resultados");

async function carregarOfertas(reset = false) {
  if (buscando) return;
  buscando = true;

  if (reset) {
    offset = 0;
    totalResultados = 0;
    tbody.innerHTML = '';
    ultimaDataCriada = null;
  }

  const url = `buscar_ultimas_ofertas.php?offset=${offset}&limite=${limite}&busca=${encodeURIComponent(buscaAtual)}`;
  const resposta = await fetch(url);
  const json = await resposta.json();
  const dados = json.resultados || [];

  if (dados.length === 0 && offset === 0) {
    contador.textContent = "Nenhum resultado encontrado.";
    tbody.innerHTML = '<tr><td colspan="7" class="text-center py-4">Nenhum resultado encontrado.</td></tr>';
  } else {
    dados.forEach(o => {
      const linha = criarLinhaProduto(o);
      tbody.insertAdjacentHTML("beforeend", linha);
    });

    atualizarTemposCriados();
    offset += limite;
    totalResultados += dados.length;

    // Define a referência da última data conhecida (para buscar novidades)
    if (!ultimaDataCriada && dados.length > 0) {
      ultimaDataCriada = dados[0].criado_em;
    }

    contador.textContent = `${totalResultados} resultado${totalResultados === 1 ? '' : 's'} encontrado${totalResultados === 1 ? '' : 's'}.`;
  }

  buscando = false;
}

function criarLinhaProduto(o) {
  const internacional = o.dolar === 'sim'
    ? `<span class="badge-internacional">Sim</span>`
    : `<span style="color: #999; font-size: 12px;">Não</span>`;

  const icones = o.anuncios > 0
    ? `<i class="fab fa-facebook-square" style="color:#1877F2;"></i><span class="online-dot"></span>`
    : '';

  return `
    <tr>
      <td><img src="${o.imagem_produto}" class="produto-img" alt=""></td>
      <td class="produto-nome">${o.nome} <br><span class="criado-em" data-criado-em="${o.criado_em}">Calculando...</span></td>
      <td class="produto-email">${o.email}</td>
      <td class="produto-anuncio text-right">
        <div style="display: flex; justify-content: end; align-items: center; gap: 6px;">
          ${o.anuncios} ${icones}
        </div>
      </td>
      <td class="text-center produto-checkout">${o.checkouts}</td>
      <td class="text-center produto-internacional">${internacional}</td>
    </tr>`;
}

async function buscarNovidades() {
  if (!ultimaDataCriada) return;

  const url = `buscar_novidades.php?depois_de=${encodeURIComponent(ultimaDataCriada)}`;
  const resposta = await fetch(url);
  const json = await resposta.json();
  const novos = json.resultados || [];

  if (novos.length > 0) {
    novos.reverse().forEach(o => {
      const linha = criarLinhaProduto(o);
      tbody.insertAdjacentHTML("afterbegin", linha);
    });

    atualizarTemposCriados();
    ultimaDataCriada = novos[0].criado_em;
    totalResultados += novos.length;
    contador.textContent = `${totalResultados} resultado${totalResultados === 1 ? '' : 's'} encontrado${totalResultados === 1 ? '' : 's'}.`;
  }
}

function tempoDecorrido(dataISO) {
  const agora = new Date();
  const criado = new Date(dataISO.replace(' ', 'T'));
  const diffMs = agora - criado;
  const segundos = Math.floor(diffMs / 1000);
  const minutos = Math.floor(segundos / 60);
  const horas = Math.floor(minutos / 60);
  const dias = Math.floor(horas / 24);

  if (segundos < 60) return `Criado há ${segundos} segundo${segundos !== 1 ? 's' : ''}`;
  if (minutos < 60) return `Criado há ${minutos} minuto${minutos !== 1 ? 's' : ''}`;
  if (horas < 24) return `Criado há ${horas} hora${horas !== 1 ? 's' : ''}`;
  return `Criado há ${dias} dia${dias !== 1 ? 's' : ''}`;
}

function atualizarTemposCriados() {
  document.querySelectorAll('.criado-em').forEach(el => {
    const data = el.getAttribute('data-criado-em');
    if (data) {
      el.textContent = tempoDecorrido(data);
    }
  });
}

// Scroll infinito com IntersectionObserver
const sentinela = document.createElement("tr");
sentinela.innerHTML = `<td colspan="7" id="sentinela" style="height: 1px;"></td>`;
tbody.appendChild(sentinela);

const observer = new IntersectionObserver(entries => {
  entries.forEach(entry => {
    if (entry.isIntersecting && !buscando) {
      carregarOfertas();
    }
  });
});
observer.observe(document.getElementById('sentinela'));

// Busca
input.addEventListener("input", () => {
  clearTimeout(debounce);
  debounce = setTimeout(() => {
    buscaAtual = input.value.trim();
    if (buscaAtual !== ultimaBusca) {
      ultimaBusca = buscaAtual;
      carregarOfertas(true);
    }
  }, 300);
});

// Modal
document.getElementById("modalDetalhes").addEventListener('hidden.bs.modal', () => {
  document.querySelectorAll('.modal-backdrop').forEach(e => e.remove());
  document.body.classList.remove('modal-open');
  document.body.style.overflow = '';
});

// Início
carregarOfertas();
setInterval(atualizarTemposCriados, 60000); // Atualiza "Criado há..."
setInterval(buscarNovidades, 60000);        // Busca novidades a cada 1 min
</script>
<tbody>
  <!-- Linhas dos produtos -->
  <tr><td colspan="7" id="sentinela" style="height: 1px;"></td></tr>
</tbody>
</body>
</html>
