<?php
$mysqli = new mysqli("localhost", "wwreve_admin", "*aFy6aoa*CjtiGRj4KMB4I9L!O1hQ1&z", "wwreve_base");
if ($mysqli->connect_error) {
    exit("Erro ao conectar ao banco de dados.");
}

// Selecionar domínios com ref válida, priorizando os sem checkouts
$sql = "SELECT id, dominio, ref 
        FROM dominios 
        WHERE ref IS NOT NULL AND ref != '' 
        ORDER BY 
            checkouts IS NOT NULL, 
            data_ultm_ckts ASC, 
            id ASC 
        LIMIT 10";

$result = $mysqli->query($sql);
if (!$result || $result->num_rows === 0) {
    exit("Nenhum domínio elegível encontrado.");
}

$segundosExtra = 0;

while ($row = $result->fetch_assoc()) {
    $id = intval($row['id']);
    $dominio = $row['dominio'];
    $ref = $mysqli->real_escape_string($row['ref']);

    // Contar produtos com mesma referência e sem página de vendas
    $countQuery = "
        SELECT COUNT(*) AS total 
        FROM produtos 
        WHERE referencia = '$ref' 
        AND (pagina_vendas IS NULL OR pagina_vendas = '')
    ";
    $countResult = $mysqli->query($countQuery);
    $totalCheckouts = 0;
    if ($countResult && $countRow = $countResult->fetch_assoc()) {
        $totalCheckouts = intval($countRow['total']);
    }

    $agora = date('Y-m-d H:i:s', time() + $segundosExtra);
    $segundosExtra++;

    // Se for prioridade alta, atualiza todos com mesmo domínio
    if ($totalCheckouts > 9) {
        $dominioEscapado = $mysqli->real_escape_string($dominio);
        $mysqli->query("
            UPDATE dominios 
            SET prioridade = 'alta' 
            WHERE dominio = '$dominioEscapado'
        ");
        echo "🔁 Domínio <strong>$dominio</strong> definido como <strong>prioridade alta</strong> em todos os registros.<br>";
    }

    // Atualiza o registro atual com os checkouts e a data
    $update = $mysqli->query("
        UPDATE dominios 
        SET checkouts = $totalCheckouts, 
            data_ultm_ckts = '$agora'
        WHERE id = $id
    ");

    echo "🔁 Domínio <strong>$dominio</strong> atualizado com <strong>$totalCheckouts</strong> checkouts.<br>";
}
?>
