<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <title>Dashboard A/B</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <!-- jQuery (obrigatrio para DataTables) -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
</head>
<body class="bg-light p-4">

<div class="container">
  <h2 class="mb-4">📊 Dashboard de Experimentos A/B</h2>
<div class="row mb-4" id="painel-extras">
  <div class="col-md-4">
    <div class="card text-bg-light border-primary shadow-sm">
      <div class="card-body">
        <h6 class="card-title mb-1">🎯 Participação no teste A/B</h6>
        <p class="fs-4 mb-0"><span id="participacao_ab">-</span></p>
      </div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card text-bg-light border-success shadow-sm">
      <div class="card-body">
        <h6 class="card-title mb-1">📈 Total no A/B</h6>
        <p class="fs-4 mb-0"><span id="total_ab">-</span></p>
      </div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card text-bg-light border-secondary shadow-sm">
      <div class="card-body">
        <h6 class="card-title mb-1">👥 Total eventos Facebook</h6>
        <p class="fs-4 mb-0"><span id="total_fb">-</span></p>
      </div>
    </div>
  </div>
</div>
  <!-- Filtros -->
  <form class="row g-3 mb-4" id="filtros">
    <div class="col-md-4">
  <label class="form-label">Experimento</label>
  <select id="experimento" class="form-select" required>
    <option value="">Carregando...</option>
  </select>
</div>
   <div class="col-md-5">
  <label class="form-label">Período</label>
  <div class="btn-group w-100" role="group">
    <button type="button" class="btn btn-outline-secondary" data-periodo="hoje">Hoje</button>
    <button type="button" class="btn btn-outline-secondary" data-periodo="ontem">Ontem</button>
    <button type="button" class="btn btn-outline-secondary" data-periodo="7dias">Últimos 7 dias</button>
    <button type="button" class="btn btn-outline-secondary" data-periodo="mes">Este mês</button>
    <button type="button" class="btn btn-outline-secondary" data-periodo="personalizado">Personalizado</button>
  </div>
</div>
<div class="col-md-3 d-none" id="range-personalizado">
  <label class="form-label">De</label>
  <input type="date" id="data_inicio" class="form-control">
</div>
<div class="col-md-3 d-none" id="range-personalizado2">
  <label class="form-label">Até</label>
  <input type="date" id="data_fim" class="form-control">
</div>

    <div class="col-md-2 d-grid">
      <label class="form-label invisible">.</label>
      <button type="submit" class="btn btn-primary">Analisar</button>
    </div>
  </form>

  <!-- Resultado -->
  <div id="resultado"></div>
  <canvas id="grafico" height="100"></canvas>
</div>

<script>

// Ao carregar a página
fetch('listar_experimentos.php')
  .then(res => res.json())
  .then(exp => {
    const select = document.getElementById('experimento');
    select.innerHTML = '<option value="">Selecione...</option>';
    exp.forEach(e => {
      const opt = document.createElement('option');
      opt.value = e;
      opt.textContent = e;
      select.appendChild(opt);
    });
  });

let data_inicio = '';
let data_fim = '';

document.querySelectorAll('[data-periodo]').forEach(btn => {
  btn.addEventListener('click', function () {
    document.querySelectorAll('[data-periodo]').forEach(b => b.classList.remove('active'));
    this.classList.add('active');
    
    const hoje = new Date();
    const ontem = new Date(Date.now() - 86400000);
    const primeiroDiaMes = new Date(hoje.getFullYear(), hoje.getMonth(), 1);

    const pad = n => n.toString().padStart(2, '0');
    const format = d => `${d.getFullYear()}-${pad(d.getMonth() + 1)}-${pad(d.getDate())}`;

    switch (this.dataset.periodo) {
      case 'hoje':
        data_inicio = data_fim = format(hoje);
        break;
      case 'ontem':
        data_inicio = data_fim = format(ontem);
        break;
      case '7dias':
        data_inicio = format(new Date(Date.now() - 6 * 86400000));
        data_fim = format(hoje);
        break;
      case 'mes':
        data_inicio = format(primeiroDiaMes);
        data_fim = format(hoje);
        break;
      case 'personalizado':
        document.getElementById('range-personalizado').classList.remove('d-none');
        document.getElementById('range-personalizado2').classList.remove('d-none');
        return;
    }

    document.getElementById('range-personalizado').classList.add('d-none');
    document.getElementById('range-personalizado2').classList.add('d-none');
  });
});

document.getElementById('filtros').addEventListener('submit', function (e) {
  e.preventDefault();
  const exp = document.getElementById('experimento').value;
  const campo_inicio = document.getElementById('data_inicio').value;
const campo_fim = document.getElementById('data_fim').value;

const inicio = campo_inicio || data_inicio;
const fim = campo_fim || data_fim;


fetch(`extras_ab.php?experimento=${encodeURIComponent(exp)}`)
  .then(res => res.json())
  .then(info => {
    document.getElementById('participacao_ab').textContent = info.percentual_participacao_ab + '%';
    document.getElementById('total_ab').textContent = info.total_ab_test;
    document.getElementById('total_fb').textContent = info.total_eventos_facebook;
  })
  .catch(() => {
    document.getElementById('participacao_ab').textContent = '-';
    document.getElementById('total_ab').textContent = '-';
    document.getElementById('total_fb').textContent = '-';
  });



fetch(`dados_dashboard.php?experimento=${encodeURIComponent(exp)}&data_inicio=${inicio}&data_fim=${fim}`)
    .then(res => res.json())
    .then(dados => {
      if (dados.erro) {
        document.getElementById('resultado').innerHTML = `<div class="alert alert-danger">${dados.erro}</div>`;
        return;
      }

      let html = `<table class="table table-bordered" id="tabela_ab"><thead><tr>
          <th>Variação</th><th>Total</th><th>Iniciaram</th><th>Converteram</th><th>💰 R$ Conversão</th><th>Upsell</th>
          <th>% Conversão</th><th>% Upsell</th><th>💰 R$ Upsell</th><th>💰 Total</th><th>💸 Retorno por Acesso</th></tr></thead><tbody>`;

      const labels = [];
      const conversoes = [];

dados.forEach(row => {
  const taxaConversao = row.total > 0 ? ((row.convertido / row.total) * 100).toFixed(1) : '0';
  const taxaUpsell = row.convertido > 0 ? ((row.upsell / row.convertido) * 100).toFixed(1) : '0';

  const valorTotalConversao = parseFloat(row.valor).toFixed(2); // já vem do backend
  const valorUpsell = 35.70;
  const valorTotalUpsell = (row.upsell * valorUpsell).toFixed(2);
const valorTotal = (parseFloat(valorTotalConversao) + parseFloat(valorTotalUpsell)).toFixed(2);
const custoPorInicio = row.iniciou > 0
  ? (valorTotal / parseInt(row.total)).toFixed(2)
  : '0.00';
  
  html += `<tr>
    <td>${row.variacao}</td>
    <td>${row.total}</td>
    <td>${row.iniciou}</td>
    <td>${row.convertido}</td>
    <td>R$ ${valorTotalConversao}</td>
    <td>${row.upsell}</td>
    <td>${taxaConversao}%</td>
    <td>${taxaUpsell}%</td>
    <td>R$ ${valorTotalUpsell}</td>
    <td>R$ ${valorTotal}</td>
    <td>R$ ${custoPorInicio}</td>
  </tr>`;

  labels.push(row.variacao);
  conversoes.push(taxaConversao);
});


      html += `</tbody></table>`;
      document.getElementById('resultado').innerHTML = html;


$(document).ready(function () {
  $('#tabela_ab').DataTable({
    language: {
      url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/pt-BR.json'
    }
  });
});


      const ctx = document.getElementById('grafico').getContext('2d');
      if (window.myChart) window.myChart.destroy(); // evita gráfico duplicado

      window.myChart = new Chart(ctx, {
        type: 'bar',
        data: {
          labels: labels,
          datasets: [{
            label: 'Taxa de Conversão (%)',
            data: conversoes,
            backgroundColor: '#0d6efd'
          }]
        },
        options: {
          scales: {
            y: { beginAtZero: true, max: 100 }
          }
        }
      });
    });
});
</script>
</body>
</html>
