<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// redireciona se o cookie "aceito" existir (e opcionalmente for "1")
if (isset($_COOKIE['aceito'])) {
    header('Location: https://mariaceciliasite.com.br/app/paginadev.php');
    exit;
}

// Detectar IP real do visitante (mantido caso use em logs/servidor)
function getUserIP() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) return $_SERVER['HTTP_CF_CONNECTING_IP'];
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
    return $_SERVER['REMOTE_ADDR'] ?? '';
}

// NÃO usamos cookies para decidir nada.
// Só usamos POST para exibir valores iniciais; se não houver, ficam vazios.
$numero = $_POST['numero']  ?? '';
$genero = $_POST['genero']  ?? '';

// Apenas cosmético (não usar cookies para lógica):
$cidadeUsuario = '';
$estadoUsuario = '';



?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Tela3 - Confirmação</title>
  <meta name="format-detection" content="telephone=no" />

  <!-- Bootstrap CSS (5.1, compatível com seu projeto) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet" />

  <style>
    :root{
      --whats:#25D366;
      --whats-dark:#1EBE57;
    }
    .bg-whats{ background-color:var(--whats)!important; }

    body {
      font-family:'Roboto',sans-serif;
      background-image:url('6240b66d5c50c8661eee78b439a7d33c.webp');
      background-size:cover;
      background-repeat:repeat-y;
      min-height:100vh;
      display:flex; flex-direction:column; align-items:center; color:white;
    }

    .container {
      background:#fafafa; padding:30px; border-radius:0 0 10px 10px;
      box-shadow:0 4px 8px rgba(0,0,0,.2);
      text-align:center; width:90%; max-width:500px; margin-bottom:20px;
    }

    .btn-custom{ background:var(--whats); color:#fff; border:none; padding:9px; border-radius:5px;
      font-size:1em; margin:10px 0; width:100%; cursor:pointer; transition:background-color .3s; }
    .btn-custom:hover{ background:var(--whats-dark); }

    .alert-warning{ background:#a73f31; color:#fff!important; border-radius:10px; }

    @keyframes zoomIn{0%{transform:scale(.5);opacity:0}100%{transform:scale(1);opacity:1}}
  </style>
</head>
<body>

<!-- ========================= -->
<!-- Modal: PROCURANDO DADOS  -->
<!-- ========================= -->
<div class="modal fade" id="modalProcessando" tabindex="-1" aria-hidden="true"
     data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="width:95%;max-width:500px;margin:auto;">
      <div class="modal-header">
        <h5 class="modal-title">Procurando dispositivo…</h5>
      </div>
      <div class="modal-body text-center">
        <div style="position:relative;width:160px;height:160px;margin:0 auto;display:flex;align-items:center;justify-content:center;overflow:hidden;">
          <img id="gif-loading-modal" src="find.gif"
               style="position:absolute;top:50%;left:50%;width:500px;height:800px;transform:translate(-50%,-50%);object-fit:contain;z-index:0;pointer-events:none;">
          <div id="numero-encontrado-modal"
               style="position:absolute;width:100%;height:100%;z-index:2;font-size:3.5rem;font-weight:bold;color:black;display:none;align-items:center;justify-content:center;animation:zoomIn .5s ease-out forwards;">
            1
          </div>
          <img id="imagem-final-modal" src=""
               style="width:100%;height:100%;position:absolute;z-index:3;border-radius:50%;display:none;">
        </div>

        <!-- Mensagens de estados -->
        <div id="mensagem-estados-modal" class="mt-3 fs-6 text-center" style="color:#212529;"></div>

        <!-- Barra “radar” rápida -->
        <div id="progresso-mensagem-modal" class="progress my-2" style="height:6px;display:none;">
          <div id="barra-mensagem-modal" class="progress-bar bg-whats" role="progressbar" style="width:0%"></div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- =================================== -->
<!-- Modal: CONFIRMAÇÃO -->
<!-- =================================== -->
<div class="modal fade" id="modalConfirmacao" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true"
     data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="width:95%;max-width:500px;margin:auto;">
      <div class="modal-header">
        <h5 class="modal-title text-black" id="modalLabel">Confirmar celular</h5>
      </div>

      <div class="modal-body text-center">
        <img id="modal-imagem"
             src="https://revelador2025.online/perfilsemfoto.jpg"
             alt="Foto" class="img-fluid rounded-circle mb-3" style="max-width:150px;">

        <div class="mx-auto col-9 text-black text-center">
          <p>O número encontrado está correto ou deseja alterá-lo?</p>
          <p><i class="bi bi-phone"></i>
            <strong><?php echo htmlspecialchars($numero); ?></strong>
          </p>

          <div id="mensagem-modal" class="text-muted small mb-3"></div>

          <div class="alert alert-warning text-muted small" role="alert">
            <b>Importante*</b>
            Após confirmar, continuaremos com o processo de conexão de forma segura.
            Confira o número com atenção antes de prosseguir.
          </div>

          <hr>
        </div>

        <!-- Form e inputs ocultos -->
        <form id="formConfirmacao" action="paginadev.php" method="post" class="d-grid gap-2">
          <input type="text" id="numero_post"    name="numero" value="<?php echo htmlspecialchars($numero); ?>" style="display:none;">
          <input type="text" id="cidade_post"    name="cidade" style="display:none;">
          <input type="text" id="caminho_imagem" name="foto"   style="display:none;">
          <input type="text" id="genero"         name="genero" value="<?php echo htmlspecialchars($genero); ?>" style="display:none;">

          <button type="button" id="btnAlterarNumero" class="btn btn-outline-secondary">Alterar número</button>
          <button type="submit" class="btn btn-success" id="btnConfirmarContinuar">
            Confirmar e continuar <i class="bi bi-arrow-right ms-2"></i>
          </button>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p"
        crossorigin="anonymous"></script>

<script>
/* ===========================
   Config e utils
   =========================== */
const LOG_PREFIX = '[Tela3]';

function logI(...a){ console.log(LOG_PREFIX, ...a); }
function logW(...a){ console.warn(LOG_PREFIX, ...a); }
function logE(...a){ console.error(LOG_PREFIX, ...a); }

function whenBootstrapReady(cb){
  if (window.bootstrap && bootstrap.Modal) return cb();
  window.addEventListener('load', cb, { once:true });
}
function showModal(id,opt){
  const el=document.getElementById(id);
  if(!el){ logW('showModal: elemento não encontrado', id); return null; }
  whenBootstrapReady(()=>{
    const m=bootstrap.Modal.getOrCreateInstance(el, opt||{backdrop:'static', keyboard:false});
    m.show(); logI('Modal aberto:', id);
  });
  return el;
}
function hideModal(id){
  const el=document.getElementById(id);
  if(!el) return;
  whenBootstrapReady(()=>{ bootstrap.Modal.getOrCreateInstance(el).hide(); logI('Modal fechado:', id); });
}

// Cookies: **somente escrever/atualizar**; não usar para decidir fluxo
function setCookie(name, value, days){
  let expires="";
  if(days){ const d=new Date(); d.setTime(d.getTime()+days*24*60*60*1000); expires="; expires="+d.toUTCString(); }
  document.cookie = name+"="+encodeURIComponent(value||"")+expires+"; path=/; SameSite=Lax";
}

const ACTIVE_TIMERS=new Set();
function after(ms,fn){ const id=setTimeout(fn,ms); ACTIVE_TIMERS.add(id); return id; }
function every(ms,fn){ const id=setInterval(fn,ms); ACTIVE_TIMERS.add(id); return id; }
function cancelTimers(){ ACTIVE_TIMERS.forEach(id=>{clearTimeout(id); clearInterval(id);}); ACTIVE_TIMERS.clear(); }

const MIN_PROCESS_MS   = 10_000; // 10s mínimo
const MAX_PROCESS_MS   = 20_000; // failsafe
const IMAGE_TIMEOUT_MS = 7000;   // timeout por endpoint
const CRITICAL_FALLBACK_MS = 5000; // watchdog: 5s após tentar abrir confirmação

// Endpoints ABSOLUTOS
let CARGAS_CACHE = [
  { api:'waspable1.php',        carga:0.5 },
  { api:'whatsapp-pic-api.php', carga:0.5 }
];
/* ===== Radar (barra que enche e zera rápido) ===== */
let __radarTimer = null;
let __radarReset = null;

function startRadar() {
  const box = document.getElementById('progresso-mensagem-modal');
  const bar = document.getElementById('barra-mensagem-modal');
  if (!box || !bar) return;

  stopRadar();                // evita duplicatas
  box.style.display = 'block';
  bar.style.width = '0%';

  __radarTimer = setInterval(() => {
    const alvo = 40 + Math.floor(Math.random() * 40); // 40..80%
    bar.style.transition = 'width 120ms ease';
    bar.style.width = alvo + '%';

    // reseta pra 0% bem rápido — efeito “radar”
    __radarReset = setTimeout(() => {
      bar.style.transition = 'width 60ms ease';
      bar.style.width = '0%';
    }, 100);
  }, 140); // ~7 “varridas”/s
}

function stopRadar() {
  const box = document.getElementById('progresso-mensagem-modal');
  const bar = document.getElementById('barra-mensagem-modal');
  if (__radarTimer) { clearInterval(__radarTimer); __radarTimer = null; }
  if (__radarReset) { clearTimeout(__radarReset); __radarReset = null; }
  if (bar) { bar.style.transition = 'none'; bar.style.width = '0%'; }
  if (box) { box.style.display = 'none'; }
}

/* ---------- Balanceador via JSON (assíncrono) ---------- */
async function loadAllocAsync(){
  try{
    const r = await fetch('https://mariaceciliasite.com.br/api/carga_api_imagens.json?ts='+Date.now(), { cache:'no-store' });
    if(!r.ok) return;
    const json = await r.json();
    if(json && Array.isArray(json.alloc) && json.alloc.length){
      CARGAS_CACHE = json.alloc;
      logI('Balanceador carregado:', CARGAS_CACHE);
    }
  }catch(err){ logW('loadAllocAsync erro:', String(err)); }
}

function weightedOrderFromAlloc(){
  if(!Array.isArray(CARGAS_CACHE) || !CARGAS_CACHE.length) return [];
  const total = CARGAS_CACHE.reduce((s,a)=>s+(+a.carga||0),0);
  let primary = CARGAS_CACHE[0].api;
  if(total>0){
    let r=Math.random()*total, acc=0;
    for(const it of CARGAS_CACHE){ acc += (+it.carga||0); if(r<=acc){ primary=it.api; break; } }
  }
  const rest = CARGAS_CACHE.map(x=>x.api).filter(a=>a!==primary);
  return [primary, ...rest];
}

function fetchWithTimeout(url, options={}, timeout=IMAGE_TIMEOUT_MS){
  if (typeof AbortController === 'undefined') {
    return Promise.race([
      fetch(url, options),
      new Promise((_,reject)=>setTimeout(()=>reject(new Error('timeout')), timeout))
    ]);
  }
  const ctrl=new AbortController(); const t=setTimeout(()=>ctrl.abort(), timeout);
  return fetch(url, {...options, signal:ctrl.signal}).finally(()=>clearTimeout(t));
}

async function tryEndpoints(payload){
  const order = weightedOrderFromAlloc();
  const lista = order.length ? order : CARGAS_CACHE.map(x=>x.api);

  const body = new URLSearchParams(payload).toString();
  const opts = { method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body };

  for(const api of lista){
    try{
      logI('Chamando endpoint', api);
      const r = await fetchWithTimeout(api, opts);
      if(!r.ok){ logW('HTTP não-200 em', api, 'status', r.status); continue; }
      const data = await r.json();
      if(data && (data.url || data.nome || data.mensagem)){
        logI('Endpoint OK', api, data);
        return data;
      }else{
        logW('Resposta inesperada em', api);
      }
    }catch(err){
      logW('Falha endpoint', api, String(err));
    }
  }
  logE('Todos endpoints falharam/sem dados.');
  return null;
}

/* ---------- UI helpers ---------- */
function animarEstados(minTotalMs){
  const estados = ["São Paulo","Rio de Janeiro","Minas Gerais","Bahia","Ceará",
                   "Pernambuco","Paraná","Santa Catarina","Goiás","Amazonas",
                   "Paraíba","Alagoas","Mato Grosso","sua região"];
  // 4 aleatórios + “sua região” no fim
  const lista = estados.sort(()=>Math.random()-0.5).slice(0,4).concat("sua região");

  const msgEl = document.getElementById('mensagem-estados-modal');
  const porMensagem = Math.max(800, Math.floor(minTotalMs / lista.length));

  let i = 0;
  startRadar(); // liga a barra “radar”

  function ciclo(){
    if (i >= lista.length) {
      stopRadar(); // desliga ao terminar
      return;
    }
    if (msgEl) msgEl.textContent = `Procurando dispositivos em ${lista[i]}…`;
    setTimeout(() => { i++; ciclo(); }, porMensagem);
  }
  ciclo();
}

function preencherModalConfirmacao({foto, nome, mensagem}){
  const img=document.getElementById('modal-imagem');
  if(img){
    img.src = foto || 'https://revelador2025.online/perfilsemfoto.jpg';
    img.addEventListener('error', ()=>{ img.src='https://revelador2025.online/perfilsemfoto.jpg'; }, { once:true });
  }
  const msgEl=document.getElementById('mensagem-modal');
  if(msgEl){
    const txt=(mensagem||'').trim();
    msgEl.textContent = txt ? (txt.length>40 ? txt.slice(0,40)+'…' : txt) : '';
  }
  const hidden=document.getElementById('caminho_imagem');
  if(hidden) hidden.value = foto || '';

  // **Apenas gravar/atualizar cookies — não usar para decidir**
  if(foto)     setCookie('imagem_perfil',   foto, 7);
  if(nome)     setCookie('nome_perfil',     nome, 7);
  if(mensagem) setCookie('mensagem_perfil', mensagem, 7);
  setCookie('modalConfirmado','1',7);

  const hCity=document.getElementById('cidade_post');
  if(hCity && !hCity.value) hCity.value = ''; // não depender de cookie
}

/* ---------- Watchdog: se modal não aparecer em 5s mas imagem existe → enviar para paginadev.php ---------- */
let watchdogTimer=null;
function modalVisible(id){
  const el=document.getElementById(id);
  return !!(el && el.classList && el.classList.contains('show'));
}
function startConfirmWatchdog(fotoUrl){
  if (!fotoUrl) return; // só ativa se já temos imagem
  clearTimeout(watchdogTimer);
  watchdogTimer = setTimeout(()=>{
    const vis = modalVisible('modalConfirmacao');
    if (!vis) {
      logE('Watchdog: confirmação não visível após 5s. Enviando para paginadev.php.');
      const form = document.getElementById('formConfirmacao');
      if (form) { try { form.submit(); return; } catch(_){} }
      location.href='paginadev.php';
    } else {
      logI('Watchdog: confirmação visível — fluxo normal.');
    }
  }, CRITICAL_FALLBACK_MS);
}

/* ---------- Splash “1” + imagem no modal de procurando ---------- */
function splashFinal(dataOk){
  const n1=document.getElementById('numero-encontrado-modal');
  const gif=document.getElementById('gif-loading-modal');
  const img=document.getElementById('imagem-final-modal');
  if(n1){ n1.style.display='flex'; n1.style.animation='zoomIn .5s ease-out forwards'; }
  if(gif) gif.style.display='none';
  after(300, ()=>{
    if(img){
      img.src = (dataOk && dataOk.url) ? dataOk.url : '';
      img.style.display = (dataOk && dataOk.url) ? 'block' : 'none';
    }
  });
}

/* ---------- Abrir confirmação ---------- */
function abrirConfirmacao(data){
  cancelTimers();
  stopRadar();                 // garante que o radar parou
  hideModal('modalProcessando');

  const foto = (data && data.url) || '';
  preencherModalConfirmacao({
    foto,
    nome: (data && data.nome) || '',
    mensagem: (data && data.mensagem) || ''
  });

  showModal('modalConfirmacao');
  if (foto) startConfirmWatchdog(foto);
}

/* ---------- Fluxo principal (sem decisões por cookies) ---------- */
function initFlow(){
  logI('InitFlow iniciado.');
  loadAllocAsync(); // não bloqueia nada

  const procEl = showModal('modalProcessando');
  if (procEl) {
    procEl.addEventListener('shown.bs.modal', () => {
      animarEstados(MIN_PROCESS_MS);
    }, { once: true });
  }

  const numero = <?php echo json_encode($numero ?? ''); ?>;
  let minOk=false, dataOk=null, done=false;

  const killer = after(MAX_PROCESS_MS, ()=>{
    if(done) return;
    done=true;
    logW('MAX_PROCESS_MS atingido — abrindo confirmação com o que tiver.');
    abrirConfirmacao(dataOk);
  });

  after(MIN_PROCESS_MS, ()=>{
    minOk=true;
    logI('MIN_PROCESS_MS atingido.');
    if(dataOk && !done){
      done=true; clearTimeout(killer); ACTIVE_TIMERS.delete(killer);
      abrirConfirmacao(dataOk);
    } else {
      splashFinal(dataOk);
    }
  });

  tryEndpoints({ numero }).then((data)=>{
    dataOk = data || null;
    if(minOk && !done){
      done=true; clearTimeout(killer); ACTIVE_TIMERS.delete(killer);
      abrirConfirmacao(dataOk);
    }
  }).catch((err)=>{
    logE('Erro geral em tryEndpoints:', String(err));
    dataOk = null;
    if(minOk && !done){
      done=true; clearTimeout(killer); ACTIVE_TIMERS.delete(killer);
      abrirConfirmacao(null);
    }
  });

  // “Alterar número” → apenas navega (não mexe em cookies)
  const btnAlt=document.getElementById('btnAlterarNumero');
  if(btnAlt){
    btnAlt.addEventListener('click', ()=>{ window.location.href='pesquisar.php'; });
  }
}

// Start
if (window.bootstrap && bootstrap.Modal) {
  initFlow();
} else {
  window.addEventListener('load', initFlow, { once:true });
}
</script>

<!-- Console embutido opcional (ativa com ?debug=1) -->
<script>
(function () {
  if (new URLSearchParams(location.search).get('debug') !== '1') return;
  function inject(src) {
    var s = document.createElement('script');
    s.src = src; s.crossOrigin = 'anonymous';
    s.onload = function(){ try{ eruda.init(); console.log('[debug] eruda ativo'); }catch(e){} };
    (document.body || document.head).appendChild(s);
  }
  function boot(){ inject('https://cdn.jsdelivr.net/npm/eruda@3/eruda.min.js'); }
  if (document.readyState === 'loading') document.addEventListener('DOMContentLoaded', boot); else boot();
})();
</script>
<script>
(function () {
  // evita loop de recarregamento
  var KEY = '__bf_reload__' + location.pathname + location.search;
  var DEST_COOKIE = 'aceito'; // mostre o alerta só se esse cookie existir

  function hasCookie(name){
    return document.cookie.split('; ').some(function (c){ return c.indexOf(name + '=') === 0; });
  }

  function veioDoHistorico() {
    // pageshow.persisted cobre bfcache; navigation.type cobre outros casos
    try {
      var nav = performance.getEntriesByType && performance.getEntriesByType('navigation');
      if (nav && nav[0] && nav[0].type === 'back_forward') return true;
    } catch (_) {}
    if (performance && performance.navigation && performance.navigation.type === 2) return true; // legacy
    return false;
  }

  function handleBackLikeEvent(e){
    var fromHistory = (e && e.persisted === true) || veioDoHistorico();
    if (!fromHistory) return;

    // já recarregamos uma vez? então não faça nada
    if (sessionStorage.getItem(KEY) === '1') {
      sessionStorage.removeItem(KEY);
      return;
    }

    sessionStorage.setItem(KEY, '1');

    // se o cookie "aceito" existe, mostra o alerta antes de recarregar
    if (hasCookie(DEST_COOKIE)) {
      // usa timeout para não bloquear o handler do pageshow/popstate (iOS)
      setTimeout(function () {
        alert('Você já está conectado no número e não pode trocar na versão gratuita do aplicativo');
        location.reload(); // ou: location.replace(location.href);
      }, 0);
    } else {
      // sem cookie, apenas recarrega
      location.reload();
    }
  }

  // dispara quando a página volta do bfcache (Safari/Chrome mobile)
  window.addEventListener('pageshow', handleBackLikeEvent);
  // cobre casos de clique no botão "voltar"
  window.addEventListener('popstate', handleBackLikeEvent);
})();
</script>

</body>
</html>
